/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.io.IOUtils;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.qubership.atp.common.lock.LockManager;
import org.qubership.atp.tdm.AbstractTest;
import org.qubership.atp.tdm.env.configurator.model.Connection;
import org.qubership.atp.tdm.env.configurator.model.Environment;
import org.qubership.atp.tdm.env.configurator.model.LazyEnvironment;
import org.qubership.atp.tdm.env.configurator.model.LazyProject;
import org.qubership.atp.tdm.env.configurator.model.LazySystem;
import org.qubership.atp.tdm.env.configurator.model.System;
import org.qubership.atp.tdm.env.configurator.service.EnvironmentsService;
import org.qubership.atp.tdm.mdc.TdmMdcHelper;
import org.qubership.atp.tdm.model.ColumnType;
import org.qubership.atp.tdm.model.FilterType;
import org.qubership.atp.tdm.model.TestDataTableCatalog;
import org.qubership.atp.tdm.model.TestDataTableImportInfo;
import org.qubership.atp.tdm.model.cleanup.CleanupSettings;
import org.qubership.atp.tdm.model.cleanup.CleanupType;
import org.qubership.atp.tdm.model.cleanup.TestDataCleanupConfig;
import org.qubership.atp.tdm.model.table.TestDataFlagsTable;
import org.qubership.atp.tdm.model.table.TestDataTable;
import org.qubership.atp.tdm.model.table.column.TestDataTableColumn;
import org.qubership.atp.tdm.model.table.column.TestDataTableColumnIdentity;
import org.qubership.atp.tdm.repo.CatalogRepository;
import org.qubership.atp.tdm.repo.ColumnRepository;
import org.qubership.atp.tdm.repo.ImportInfoRepository;
import org.qubership.atp.tdm.repo.TestDataColumnFlagsRepository;
import org.qubership.atp.tdm.repo.TestDataTableRepository;
import org.qubership.atp.tdm.service.CleanupService;
import org.qubership.atp.tdm.service.ProjectInformationService;
import org.qubership.atp.tdm.service.StatisticsService;
import org.qubership.atp.tdm.service.TestDataService;
import org.qubership.atp.tdm.utils.CurrentTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.web.multipart.MultipartFile;

public abstract class AbstractTestDataTest
extends AbstractTest {
    private static final Logger log = LoggerFactory.getLogger(AbstractTestDataTest.class);
    private static final String RESOURCES_PATH = "src/test/resources/";
    protected static final String projectName = "Test Project";
    protected static final String environmentName = "Test Environment";
    protected static final String systemName = "Test System";
    protected static final UUID projectId = UUID.randomUUID();
    protected static final UUID systemId = UUID.randomUUID();
    protected static final UUID environmentId = UUID.randomUUID();
    protected TdmMdcHelper tdmMdcHelper = new TdmMdcHelper();
    protected static final Connection httpConnection = new Connection(){
        {
            this.setName("http");
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("url", "http://localhost:8080/");
            this.setParameters(parameters);
        }
    };
    protected static final Connection dbConnection = new Connection(){
        {
            this.setName("DB");
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("db_type", "postgresql");
            parameters.put("jdbc_url", AbstractTest.integrationPostgresEnvironment.getPostgresJdbcUrl());
            parameters.put("db_login", "tdmadmin");
            parameters.put("db_password", "tdmadmin");
            this.setParameters(parameters);
        }
    };
    protected static final Connection dbConnectionErrorDbType = new Connection(){
        {
            this.setName("DB");
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("db_type", "errorType");
            parameters.put("jdbc_url", AbstractTest.integrationPostgresEnvironment.getPostgresJdbcUrl());
            parameters.put("db_login", "tdmadmin");
            parameters.put("db_password", "tdmadmin");
            this.setParameters(parameters);
        }
    };
    protected static final Connection dbConnectionErrorName = new Connection(){
        {
            this.setName("ErrorName");
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("db_type", "postgresql");
            parameters.put("jdbc_url", AbstractTest.integrationPostgresEnvironment.getPostgresJdbcUrl());
            parameters.put("db_login", "tdmadmin");
            parameters.put("db_password", "tdmadmin");
            this.setParameters(parameters);
        }
    };
    protected static final Connection dbConnectionErrorCredentials = new Connection(){
        {
            this.setName("DB");
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("db_type", "postgresql");
            parameters.put("jdbc_url", AbstractTest.integrationPostgresEnvironment.getPostgresJdbcUrl());
            parameters.put("db_login", "incorrect");
            parameters.put("db_password", "incorrect");
            this.setParameters(parameters);
        }
    };
    protected static final List<Connection> connections = new ArrayList<Connection>(){
        {
            this.add(httpConnection);
            this.add(dbConnection);
        }
    };
    protected static final System system = new System(){
        {
            this.setName(AbstractTestDataTest.systemName);
            this.setId(systemId);
            this.setConnections(connections);
        }
    };
    protected static final System systemErrorConnectionName = new System(){
        {
            this.setName(AbstractTestDataTest.systemName);
            this.setId(systemId);
            ArrayList<Connection> connections = new ArrayList<Connection>();
            connections.add(dbConnectionErrorName);
            this.setConnections(connections);
        }
    };
    protected static final System systemErrorCredentials = new System(){
        {
            this.setName(AbstractTestDataTest.systemName);
            this.setId(systemId);
            ArrayList<Connection> connections = new ArrayList<Connection>();
            connections.add(dbConnectionErrorCredentials);
            this.setConnections(connections);
        }
    };
    protected static final LazySystem lazySystem = new LazySystem(){
        {
            this.setName(AbstractTestDataTest.systemName);
            this.setId(systemId);
        }
    };
    protected static final Environment environment = new Environment(){
        {
            this.setName(AbstractTestDataTest.environmentName);
            this.setId(environmentId);
            this.setSystems(Collections.singletonList(system));
        }
    };
    protected static final LazyEnvironment lazyEnvironment = new LazyEnvironment(){
        {
            this.setName(AbstractTestDataTest.environmentName);
            this.setId(environmentId);
            this.setProjectId(projectId);
            this.setSystems(Collections.singletonList(lazySystem.getId().toString()));
        }
    };
    protected final List<LazyEnvironment> lazyEnvironments = Collections.singletonList(lazyEnvironment);
    protected static final LazyProject lazyProject = new LazyProject(){
        {
            this.setName(AbstractTestDataTest.projectName);
            this.setId(projectId);
        }
    };
    @Autowired
    protected ImportInfoRepository importInfoRepository;
    @Autowired
    protected TestDataService testDataService;
    @Autowired
    protected StatisticsService statisticsService;
    @Autowired
    protected CatalogRepository catalogRepository;
    @Autowired
    protected TestDataTableRepository testDataTableRepository;
    @Autowired
    protected CleanupService cleanupService;
    @Autowired
    protected ColumnRepository columnRepository;
    @Autowired
    protected TestDataColumnFlagsRepository flagsRepository;
    @Autowired
    protected ProjectInformationService projectInformationService;
    @Autowired
    protected LockManager lockManager;
    @MockBean
    protected EnvironmentsService environmentsService;
    @MockBean
    protected CurrentTime currentTime;

    protected TestDataTableCatalog createTestDataTableCatalog(UUID projectId, UUID systemId, UUID environmentId, String tableTitle, String tableName, String importQuery) {
        TestDataTableCatalog catalog = this.createTestDataTableCatalog(projectId, systemId, environmentId, tableTitle, tableName);
        catalog.setImportQuery(importQuery);
        this.importInfoRepository.save((Object)new TestDataTableImportInfo(tableName, importQuery, Integer.valueOf(30)));
        return (TestDataTableCatalog)this.catalogRepository.save((Object)catalog);
    }

    protected TestDataTableCatalog createTestDataTableCatalog(UUID projectId, UUID systemId, UUID environmentId, String tableTitle, String tableName) {
        TestDataTableCatalog catalog = new TestDataTableCatalog();
        catalog.setProjectId(projectId);
        catalog.setSystemId(systemId);
        catalog.setEnvironmentId(environmentId);
        catalog.setTableTitle(tableTitle);
        catalog.setTableName(tableName);
        return (TestDataTableCatalog)this.catalogRepository.save((Object)catalog);
    }

    protected TestDataTable createTestDataTable(String tableName) {
        this.deleteTestDataTableIfExists(tableName);
        return this.testDataTableRepository.saveTestData(tableName, false, this.buildTestDataTable());
    }

    protected TestDataTable createTestDataTable(String tableName, boolean createTableCatalog) {
        if (createTableCatalog) {
            this.createTestDataTableCatalog(projectId, systemId, environmentId, tableName, tableName);
        }
        return this.createTestDataTable(tableName);
    }

    protected TestDataTable createSmallTestDataTable(String tableName) {
        this.deleteTestDataTableIfExists(tableName);
        return this.testDataTableRepository.saveTestData(tableName, false, this.buildSmallTestDataTable());
    }

    protected List<TestDataTableColumn> createTestDataTableColumns(String tableName) {
        List<String> columns = Arrays.asList("sim", "Status", "Partner", "Partner category", "Partner ID", "Operator ID", "environment", "Assignment");
        return this.columnRepository.saveAll(this.getTestDataTableColumnsByColumnsAndTableName(columns, tableName));
    }

    protected void deleteTestDataTable(String tableName) {
        this.testDataTableRepository.dropTable(tableName);
    }

    protected void deleteTestDataTableIfExists(String tableName) {
        try {
            this.testDataTableRepository.dropTable(tableName);
        }
        catch (BadSqlGrammarException e) {
            log.warn("Table:[{}] does not exist", (Object)tableName, (Object)e);
        }
    }

    protected List<UUID> extractRowIds(List<Map<String, Object>> data) {
        return data.stream().map(row -> UUID.fromString(String.valueOf(row.get("ROW_ID")))).collect(Collectors.toList());
    }

    protected File getResourcesFile(String fileName) {
        return new File(RESOURCES_PATH + fileName);
    }

    protected MultipartFile toMultipartFile(File file) throws IOException {
        FileInputStream input = new FileInputStream(file);
        return new MockMultipartFile("file", file.getName(), "application/vnd.ms-excel", IOUtils.toByteArray((InputStream)input));
    }

    protected TestDataTable buildTestDataTable() {
        List<String> columns = Arrays.asList("sim", "Status", "Partner", "Partner category", "Partner ID", "Operator ID", "environment", "Assignment");
        TestDataTable table = new TestDataTable();
        table.setColumns(this.getTestDataTableColumns(columns));
        table.setData(this.getTestDataTableData(columns));
        table.setRecords(6);
        return table;
    }

    protected TestDataFlagsTable createFlagsTable(String tableName) {
        return (TestDataFlagsTable)this.flagsRepository.save((Object)new TestDataFlagsTable(tableName, false));
    }

    private TestDataTable buildSmallTestDataTable() {
        List<String> columns = Arrays.asList("sim", "Assignment");
        TestDataTable table = new TestDataTable();
        table.setColumns(this.getTestDataTableColumns(columns));
        table.setData(this.getTestDataTableData(columns));
        table.setRecords(6);
        return table;
    }

    protected TestDataCleanupConfig createSqlCleanupConfig(TestDataTableCatalog table, boolean shared) throws Exception {
        TestDataCleanupConfig cleanupConfig = this.createTestDataDateCleanupConfig();
        cleanupConfig.setType(CleanupType.SQL);
        cleanupConfig.setSearchSql("select * from test_data_table_catalog where table_title = ${'Partner'}");
        cleanupConfig.setShared(shared);
        CleanupSettings cleanupSettings = new CleanupSettings();
        cleanupSettings.setTestDataCleanupConfig(cleanupConfig);
        cleanupSettings.setTableName(table.getTableName());
        cleanupSettings.setEnvironmentsList(Collections.singletonList(table.getEnvironmentId()));
        return this.cleanupService.saveCleanupConfig(cleanupSettings).getTestDataCleanupConfig();
    }

    protected TestDataCleanupConfig createErrorSqlCleanupConfig(TestDataTableCatalog table, boolean shared) throws Exception {
        TestDataCleanupConfig cleanupConfig = this.createTestDataDateCleanupConfig();
        cleanupConfig.setType(CleanupType.SQL);
        cleanupConfig.setSearchSql("select * from test_data_table_catalog where table_title = ${'PartnerR'}");
        cleanupConfig.setShared(shared);
        CleanupSettings cleanupSettings = new CleanupSettings();
        cleanupSettings.setTestDataCleanupConfig(cleanupConfig);
        cleanupSettings.setTableName(table.getTableName());
        cleanupSettings.setEnvironmentsList(Collections.singletonList(table.getEnvironmentId()));
        return this.cleanupService.saveCleanupConfig(cleanupSettings).getTestDataCleanupConfig();
    }

    protected TestDataCleanupConfig createSqlCleanupConfig(String tableName, List<UUID> envIds) throws Exception {
        TestDataCleanupConfig cleanupConfig = this.createTestDataDateCleanupConfig();
        cleanupConfig.setType(CleanupType.SQL);
        cleanupConfig.setSearchSql("select * from test_data_table_catalog where table_title = ${'Partner'}");
        cleanupConfig.setShared(false);
        CleanupSettings cleanupSettings = new CleanupSettings();
        cleanupSettings.setTestDataCleanupConfig(cleanupConfig);
        cleanupSettings.setTableName(tableName);
        cleanupSettings.setEnvironmentsList(envIds);
        return this.cleanupService.saveCleanupConfig(cleanupSettings).getTestDataCleanupConfig();
    }

    protected TestDataCleanupConfig createDateCleanupConfig(TestDataTableCatalog table) throws Exception {
        TestDataCleanupConfig cleanupConfig = this.createTestDataDateCleanupConfig();
        cleanupConfig.setType(CleanupType.DATE);
        cleanupConfig.setSearchDate("3w 4d");
        CleanupSettings cleanupSettings = new CleanupSettings();
        cleanupSettings.setTestDataCleanupConfig(cleanupConfig);
        cleanupSettings.setEnvironmentsList(Collections.singletonList(table.getEnvironmentId()));
        cleanupSettings.setTableName(table.getTableName());
        return this.cleanupService.saveCleanupConfig(cleanupSettings).getTestDataCleanupConfig();
    }

    protected TestDataCleanupConfig createDateCleanupConfigToDay(TestDataTableCatalog table) throws Exception {
        TestDataCleanupConfig cleanupConfig = this.createTestDataDateCleanupConfig();
        cleanupConfig.setType(CleanupType.DATE);
        cleanupConfig.setSearchDate("0w 0d");
        CleanupSettings cleanupSettings = new CleanupSettings();
        cleanupSettings.setTestDataCleanupConfig(cleanupConfig);
        cleanupSettings.setEnvironmentsList(Collections.singletonList(table.getEnvironmentId()));
        cleanupSettings.setTableName(table.getTableName());
        return this.cleanupService.saveCleanupConfig(cleanupSettings).getTestDataCleanupConfig();
    }

    protected Map<String, Object> createTestDataTableRow(String tableName) {
        HashMap<String, Object> row = new HashMap<String, Object>();
        row.put("Status", "51");
        row.put("Partner ID", "1");
        row.put("Operator ID", "2501");
        row.put("ROW_ID", ((Map)this.testDataService.getTestData(tableName).getData().get(0)).get("ROW_ID"));
        row.put("SELECTED", false);
        row.put("Assignment", "Test Automation' 1");
        row.put("OCCUPIED_BY", null);
        row.put("sim", "8901260720040140811");
        row.put("CREATED_WHEN", ((Map)this.testDataService.getTestData(tableName).getData().get(0)).get("CREATED_WHEN"));
        row.put("Partner category", "MVNO");
        row.put("environment", "ZLAB01");
        row.put("OCCUPIED_DATE", null);
        row.put("Partner", "CINTEX");
        return row;
    }

    private TestDataCleanupConfig createTestDataDateCleanupConfig() {
        TestDataCleanupConfig cleanup = new TestDataCleanupConfig();
        cleanup.setEnabled(true);
        cleanup.setSchedule("0 0/1 * * * ?");
        cleanup.setShared(false);
        cleanup.setQueryTimeout(Integer.valueOf(30));
        return cleanup;
    }

    private List<Map<String, Object>> getTestDataTableData(List<String> columns) {
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        data.add(this.buildTestDataTableRow(columns, Arrays.asList("8901260720040140811", "51", "CINTEX", "MVNO", "1", "2501", "ZLAB01", "Test Automation' 1")));
        data.add(this.buildTestDataTableRow(columns, Arrays.asList("8901260720040140822", "52", "CINTEX", "MVNO", "2", "2502", "ZLAB02", "TeSt AutoMatioN 2")));
        data.add(this.buildTestDataTableRow(columns, Arrays.asList("8901260720040140973", "53", "CINTEX", "MVNO", "3", "2503", "ZLAB03", "Test Automation 3")));
        data.add(this.buildTestDataTableRow(columns, Arrays.asList("8901260720040141084", "54", "CINTEX", "MVNO", "4", "2504", "ZLAB04", "Test Automation 4")));
        data.add(this.buildTestDataTableRow(columns, Arrays.asList("8901260720040140975", "55", "CINTEX", "MVNO", "5", "2505", "ZLAB05", "Test Automation 5")));
        data.add(this.buildTestDataTableRow(columns, Arrays.asList("8901260720040141106", "56", "CINTEX", "MVNO", "6", "2506", "ZLAB06", "Test Automation 6")));
        return data;
    }

    private List<TestDataTableColumn> getTestDataTableColumns(List<String> columnNames) {
        return this.getTestDataTableColumnsByColumnsAndTableName(columnNames, "");
    }

    private List<TestDataTableColumn> getTestDataTableColumnsByColumnsAndTableName(List<String> columnNames, String tableName) {
        return columnNames.stream().map(columnName -> new TestDataTableColumn(new TestDataTableColumnIdentity(tableName, columnName), ColumnType.TEXT, FilterType.TEXT, "link", false)).collect(Collectors.toList());
    }

    private Map<String, Object> buildTestDataTableRow(List<String> columnNames, List<String> values) {
        return IntStream.range(0, columnNames.size()).boxed().collect(Collectors.toMap(columnNames::get, values::get));
    }

    protected void mockEnvironmentService(List<UUID> envs, UUID systemId1, UUID systemId2) {
        LazySystem lazySystem1 = new LazySystem();
        lazySystem1.setEnvironmentIds(Collections.singletonList(envs.get(0)));
        lazySystem1.setId(systemId1);
        lazySystem1.setName("Default");
        LazySystem lazySystem2 = new LazySystem();
        ArrayList<LazySystem> lazySystemList = new ArrayList<LazySystem>();
        lazySystemList.add(lazySystem1);
        if (envs.size() > 1) {
            lazySystem2.setEnvironmentIds(Collections.singletonList(envs.get(1)));
            lazySystem2.setId(systemId2);
            lazySystem2.setName("Default");
            lazySystemList.add(lazySystem2);
        }
        Mockito.when((Object)this.environmentsService.getLazySystemById((UUID)ArgumentMatchers.any())).thenReturn((Object)lazySystem1);
        Mockito.when((Object)this.environmentsService.getLazySystemsByProjectWithEnvIds((UUID)ArgumentMatchers.any())).thenReturn(lazySystemList);
    }
}

