/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.service.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.qubership.atp.tdm.AbstractTestDataTest;
import org.qubership.atp.tdm.env.configurator.model.LazyEnvironment;
import org.qubership.atp.tdm.model.TestDataTableCatalog;
import org.qubership.atp.tdm.model.cleanup.TestDataCleanupConfig;
import org.qubership.atp.tdm.model.rest.ApiDataFilter;
import org.qubership.atp.tdm.model.rest.ResponseMessage;
import org.qubership.atp.tdm.model.rest.ResponseType;
import org.qubership.atp.tdm.model.rest.requests.AddInfoToRowRequest;
import org.qubership.atp.tdm.model.rest.requests.ChangeRowRequest;
import org.qubership.atp.tdm.model.rest.requests.GetRowRequest;
import org.qubership.atp.tdm.model.rest.requests.OccupyFullRowRequest;
import org.qubership.atp.tdm.model.rest.requests.OccupyRowRequest;
import org.qubership.atp.tdm.model.rest.requests.ReleaseRowRequest;
import org.qubership.atp.tdm.model.rest.requests.UpdateRowRequest;
import org.qubership.atp.tdm.model.table.TestDataTable;
import org.qubership.atp.tdm.model.table.TestDataTableFilter;
import org.qubership.atp.tdm.service.AtpActionService;
import org.springframework.beans.factory.annotation.Autowired;

public class AtpActionServiceTest
extends AbstractTestDataTest {
    @Autowired
    protected AtpActionService atpActionService;

    @BeforeEach
    public void setUp() {
        Mockito.when((Object)this.environmentsService.getLazyProjectByName((String)ArgumentMatchers.any())).thenReturn((Object)lazyProject);
        Mockito.when((Object)this.environmentsService.getLazyEnvironmentByName((UUID)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)lazyEnvironment);
        Mockito.when((Object)this.environmentsService.getLazySystemByName((UUID)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)lazySystem);
        Mockito.when((Object)this.environmentsService.getConnectionsSystemById((UUID)ArgumentMatchers.any())).thenReturn((Object)connections);
    }

    @Test
    public void atpRefreshTestData_testDataForInsertExist_responseMessageWithSuccessRefreshTestData() {
        String tableTitle = "TDM API Test Refresh Exist Test Data";
        String tableName = "tdm_api_test_refresh_exist_test_data";
        TestDataTable testDataTable = this.createTestDataTable(tableName);
        String importQuery = "select sim from " + tableName;
        this.createTestDataTableCatalog(projectId, systemId, environmentId, tableTitle, tableName, importQuery);
        String msg = String.format("Successfully refreshed %s records fot table: %s.", testDataTable.getRecords(), tableTitle);
        String dataRefreshLink = "%s/project/%s/tdm/TEST%%20DATA/%s/%s";
        String tdmUrl = "localhost:8080";
        String resultLink = String.format(dataRefreshLink, tdmUrl, projectId, environmentId, systemId);
        ResponseMessage expectedResponseMessage = new ResponseMessage(ResponseType.SUCCESS, msg, resultLink);
        List responseMessages = this.atpActionService.refreshTables(lazyProject.getName(), lazyEnvironment.getName(), system.getName(), tableTitle);
        ResponseMessage actualResponseMessage = (ResponseMessage)responseMessages.get(0);
        this.deleteTestDataTableIfExists(tableName);
        this.catalogRepository.deleteByTableName(tableName);
        Assertions.assertEquals((Object)expectedResponseMessage, (Object)actualResponseMessage);
    }

    @Test
    public void atpRefreshTestData_testDataForInsertNotExist_responseMessageWithError() {
        String tableTitle = "TDM API Test Refresh Not Exist Test Data";
        String tableName = "tdm_api_test_refresh_not_exist_test_data";
        this.createTestDataTable(tableName);
        String importQuery = "select sim from " + tableName;
        this.createTestDataTableCatalog(projectId, systemId, environmentId, tableTitle, tableName, importQuery);
        this.testDataTableRepository.deleteAllRows(tableName);
        String msg = "Failed to refresh table with title:" + tableTitle + ". Root cause: Import info don't exist for table: " + tableName;
        String dataRefreshLink = "%s/project/%s/tdm/TEST%%20DATA/%s/%s";
        String tdmUrl = "localhost:8080";
        String resultLink = String.format(dataRefreshLink, tdmUrl, projectId, environmentId, systemId);
        ResponseMessage expectedResponseMessage = new ResponseMessage(ResponseType.ERROR, msg, resultLink);
        List responseMessages = this.atpActionService.refreshTables(lazyProject.getName(), lazyEnvironment.getName(), system.getName(), tableTitle);
        ResponseMessage actualResponseMessage = (ResponseMessage)responseMessages.get(0);
        this.deleteTestDataTableIfExists(tableName);
        this.catalogRepository.deleteByTableName(tableName);
        Assertions.assertEquals((Object)expectedResponseMessage, (Object)actualResponseMessage);
    }

    @Test
    public void atpInsertTestData_projectAndSystemSelected_newTableCreated() {
        String tableTitle = "TDM API Test Insert Under System";
        String expectedResponseMessage = "A new test data table has been created. Test data was inserted.";
        this.verifyCreationNewTableWithRecords(tableTitle, projectId, systemId, expectedResponseMessage);
    }

    @Test
    public void atpInsertTestData_projectAndSystemSelectedAndTableExists_dataInserted() {
        String tableName = "tdm_api_test_insert_precreated_table";
        TestDataTableCatalog catalog = this.createTestDataTableCatalog(projectId, systemId, environmentId, "TDM API Test Insert with pre-created table", tableName);
        this.createTestDataTable(catalog.getTableName());
        String expectedResponseMessage = "Test data table with specified name already exists. Test data was inserted.";
        this.verifyCreationPreCreatedTableWithRecords(catalog.getTableTitle(), catalog.getProjectId(), catalog.getSystemId(), expectedResponseMessage);
        this.deleteTestDataTableIfExists(tableName);
    }

    @Test
    public void atpInsertTestData_temporaryEnvironmentSelected_newTableCreated() {
        String tableTitle = "TDM API Test Insert Under Temporary Environment";
        LazyEnvironment lazyTemporaryEnvironment = new LazyEnvironment(){
            {
                this.setName("CI2 2020-04-23T12:29:30.589Z");
                this.setId(UUID.randomUUID());
            }
        };
        Mockito.when((Object)this.environmentsService.getLazyEnvironmentByName((UUID)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)lazyTemporaryEnvironment);
        String link = "localhost:8080/project/%s/tdm/TEST%%20DATA/%s/%s/";
        link = String.format(link, projectId, lazyTemporaryEnvironment.getId(), systemId);
        String expectedResponseMessage = "A new test data table has been created. Test data was inserted.";
        this.verifyCreationTableWithRecords(tableTitle, projectId, lazyProject.getName(), lazyTemporaryEnvironment.getName(), systemId, system.getName(), link, expectedResponseMessage);
    }

    @Test
    public void atpInsertTestData_projectOnlySelected_newTableCreated() {
        String tableTitle = "TDM API Test Insert Under Project";
        String expectedResponseMessage = "A new test data table has been created. Test data was inserted.";
        this.verifyCreationNewTableWithRecords(tableTitle, projectId, null, expectedResponseMessage);
    }

    @Test
    public void atpOccupyTestData_applyFilterTypeContains_successfullyFind() {
        String tableName = "tdm_api_test_occupy_contains_filter";
        TestDataTableCatalog catalog = this.createTestDataTableCatalog(projectId, systemId, environmentId, "TDM API Test Occupy", tableName);
        this.createTestDataTable(catalog.getTableName());
        OccupyRowRequest occupyRowRequest = this.buildOccupyRowRequest("Assignment", "sim", "Contains", "12607200401410");
        List responseMessages = this.atpActionService.occupyTestData(lazyProject.getName(), lazyEnvironment.getName(), system.getName(), catalog.getTableTitle(), Collections.singletonList(occupyRowRequest));
        ResponseMessage responseMessage = responseMessages.stream().findFirst().orElse(new ResponseMessage());
        Assertions.assertEquals((Object)ResponseType.SUCCESS, (Object)responseMessage.getType());
        String expectedResponseMessage = "Test Automation 4";
        String link = "localhost:8080/project/%s/tdm/TEST%%20DATA/%s/%s/tdm_api_test_occupy_contains_filter";
        this.deleteTestDataTableIfExists(tableName);
        this.catalogRepository.deleteByTableName(tableName);
        Assertions.assertEquals((Object)expectedResponseMessage, (Object)responseMessage.getContent());
        Assertions.assertEquals((Object)String.format(link, projectId, lazyEnvironment.getId(), systemId), (Object)responseMessage.getLink());
    }

    @Test
    public void atpOccupyTestDataFullRow_applyFilterTypeContains_successfullyFind() {
        String tableName = "tdm_api_test_occupy_full_row_contains_filter";
        TestDataTableCatalog catalog = this.createTestDataTableCatalog(projectId, systemId, environmentId, "TDM API Test Occupy Full Row", tableName);
        this.createTestDataTable(catalog.getTableName());
        OccupyFullRowRequest occupyRowRequest = this.buildOccupyFullRowRequest(Collections.singletonList("Assignment"), "sim", "Contains", "12607200401410");
        List responseMessages = this.atpActionService.occupyTestDataFullRow(lazyProject.getName(), lazyEnvironment.getName(), system.getName(), catalog.getTableTitle(), Collections.singletonList(occupyRowRequest));
        ResponseMessage responseMessage = responseMessages.stream().findFirst().orElse(new ResponseMessage());
        Assertions.assertEquals((Object)ResponseType.SUCCESS, (Object)responseMessage.getType());
        HashMap<String, String> expectedResponseValues = new HashMap<String, String>();
        expectedResponseValues.put("Assignment", "Test Automation 4");
        Object actualResponseMap = responseMessage.getContentObject();
        this.deleteTestDataTableIfExists(tableName);
        this.catalogRepository.deleteByTableName(tableName);
        Assertions.assertEquals(expectedResponseValues, (Object)actualResponseMap);
        String link = "localhost:8080/project/%s/tdm/TEST%%20DATA/%s/%s/tdm_api_test_occupy_full_row_contains_filter";
        Assertions.assertEquals((Object)String.format(link, projectId, lazyEnvironment.getId(), systemId), (Object)responseMessage.getLink());
    }

    @Test
    public void atpOccupyTestData_applyFilterTypeStartWith_successfullyFind() {
        String tableName = "tdm_api_test_occupy_stat_with_filter";
        TestDataTableCatalog catalog = this.createTestDataTableCatalog(projectId, systemId, environmentId, "TDM API Test Occupy - Start With", tableName);
        this.createTestDataTable(catalog.getTableName());
        OccupyRowRequest occupyRowRequest = this.buildOccupyRowRequest("Assignment", "sim", "Start With", "89012607200401410");
        List responseMessages = this.atpActionService.occupyTestData(lazyProject.getName(), lazyEnvironment.getName(), system.getName(), catalog.getTableTitle(), Collections.singletonList(occupyRowRequest));
        ResponseMessage responseMessage = responseMessages.stream().findFirst().orElse(new ResponseMessage());
        this.deleteTestDataTableIfExists(tableName);
        this.catalogRepository.deleteByTableName(tableName);
        Assertions.assertEquals((Object)ResponseType.SUCCESS, (Object)responseMessage.getType());
        String expectedResponseMessage = "Test Automation 4";
        String link = "localhost:8080/project/%s/tdm/TEST%%20DATA/%s/%s/tdm_api_test_occupy_stat_with_filter";
        Assertions.assertEquals((Object)expectedResponseMessage, (Object)responseMessage.getContent());
        Assertions.assertEquals((Object)String.format(link, projectId, lazyEnvironment.getId(), systemId), (Object)responseMessage.getLink());
    }

    @Test
    public void atpOccupyTestDataFullRow_applyFilterTypeStartWith_successfullyFind() {
        String tableName = "tdm_api_test_occupy_full_row_stat_with_filter";
        TestDataTableCatalog catalog = this.createTestDataTableCatalog(projectId, systemId, environmentId, "TDM API Test Occupy Full Row - Start With", tableName);
        this.createTestDataTable(catalog.getTableName());
        OccupyFullRowRequest occupyRowRequest = this.buildOccupyFullRowRequest(Collections.singletonList("Assignment"), "sim", "Start With", "89012607200401410");
        List responseMessages = this.atpActionService.occupyTestDataFullRow(lazyProject.getName(), lazyEnvironment.getName(), system.getName(), catalog.getTableTitle(), Collections.singletonList(occupyRowRequest));
        ResponseMessage responseMessage = responseMessages.stream().findFirst().orElse(new ResponseMessage());
        Assertions.assertEquals((Object)ResponseType.SUCCESS, (Object)responseMessage.getType());
        HashMap<String, String> expectedResponseValues = new HashMap<String, String>();
        expectedResponseValues.put("Assignment", "Test Automation 4");
        Object actualResponseMap = responseMessage.getContentObject();
        this.deleteTestDataTableIfExists(tableName);
        this.catalogRepository.deleteByTableName(tableName);
        Assertions.assertEquals(expectedResponseValues, (Object)actualResponseMap);
        String link = "localhost:8080/project/%s/tdm/TEST%%20DATA/%s/%s/tdm_api_test_occupy_full_row_stat_with_filter";
        Assertions.assertEquals((Object)String.format(link, projectId, lazyEnvironment.getId(), systemId), (Object)responseMessage.getLink());
    }

    @Test
    public void atpOccupyTestData_applyFilterTypeEqualsAndSelectedOnlyProject_successfullyFind() {
        String tableName = "tdm_api_test_occupy_equals_filter_under_project";
        this.verifyOccupationTableRow("TDM API Test Occupy Under Project", tableName, projectId, null, null);
    }

    @Test
    public void atpOccupyTestDataFullRow_applyFilterTypeEqualsAndSelectedOnlyProject_successfullyFind() {
        String tableName = "tdm_api_test_occupy_full_row_equals_filter_under_project";
        this.verifyOccupationTableFullRow("TDM API Test Occupy Full Under Project", tableName, projectId, null, null);
    }

    @Test
    public void atpOccupyTestData_applyFilterTypeEqualsAndSelectedProjectAndSystem_successfullyFind() {
        String tableName = "tdm_api_test_occupy_equals_filter_under_system";
        this.verifyOccupationTableRow("TDM API Test Occupy Under System", tableName, projectId, systemId, environmentId);
    }

    @Test
    public void atpOccupyTestDataFullRow_applyFilterTypeEqualsAndSelectedProjectAndSystem_successfullyFind() {
        String tableName = "tdm_api_test_occupy_full_row_equals_filter_under_system";
        this.verifyOccupationTableFullRow("TDM API Test Occupy Full Under System", tableName, projectId, systemId, environmentId);
    }

    @Test
    public void atpOccupyTestData_wrongColumnNameInput_returnErrorMessage() {
        String tableName = "tdm_api_test_occupy_wrong_response_column_name";
        TestDataTableCatalog catalog = this.createTestDataTableCatalog(projectId, systemId, environmentId, "TDM API Test Occupy - Wrong Column Name", tableName);
        this.createTestDataTable(catalog.getTableName());
        OccupyRowRequest occupyRowRequest = this.buildOccupyRowRequest("Wrong Column Name", "Assignment", "contains", "Test Automation 4");
        List responseMessages = this.atpActionService.occupyTestData(lazyProject.getName(), lazyEnvironment.getName(), system.getName(), catalog.getTableTitle(), Collections.singletonList(occupyRowRequest));
        ResponseMessage responseMessage = responseMessages.stream().findFirst().orElse(new ResponseMessage());
        this.deleteTestDataTableIfExists(tableName);
        this.catalogRepository.deleteByTableName(tableName);
        Assertions.assertEquals((Object)ResponseType.ERROR, (Object)responseMessage.getType());
        Assertions.assertEquals((Object)"Column with name \"Wrong Column Name\" was not found!", (Object)responseMessage.getContent());
    }

    @Test
    public void atpOccupyTestDataFullRow_wrongColumnNameInput_returnErrorMessage() {
        String tableName = "tdm_api_test_occupy_full_row_wrong_response_column_name";
        TestDataTableCatalog catalog = this.createTestDataTableCatalog(projectId, systemId, environmentId, "TDM API Test Occupy Full Row - Wrong Column Name", tableName);
        this.createTestDataTable(catalog.getTableName());
        OccupyFullRowRequest occupyRowRequest = this.buildOccupyFullRowRequest(Collections.singletonList("Wrong Column Name"), "Assignment", "contains", "Test Automation 4");
        List responseMessages = this.atpActionService.occupyTestDataFullRow(lazyProject.getName(), lazyEnvironment.getName(), system.getName(), catalog.getTableTitle(), Collections.singletonList(occupyRowRequest));
        ResponseMessage responseMessage = responseMessages.stream().findFirst().orElse(new ResponseMessage());
        this.deleteTestDataTableIfExists(tableName);
        this.catalogRepository.deleteByTableName(tableName);
        Assertions.assertEquals((Object)ResponseType.ERROR, (Object)responseMessage.getType());
        Assertions.assertEquals((Object)"Column with name \"Wrong Column Name\" was not found!", (Object)responseMessage.getContent());
    }

    @Test
    public void atpOccupyTestDataFullRow_wrongSearchValueInput_nothingFoundErrorMessage() {
        String tableName = "tdm_api_test_occupy_full_row_wrong_search_value";
        TestDataTableCatalog catalog = this.createTestDataTableCatalog(projectId, systemId, environmentId, "TDM API Test Occupy Full Row With Wrong Search Value", tableName);
        this.createTestDataTable(catalog.getTableName());
        OccupyFullRowRequest occupyRowRequest = this.buildOccupyFullRowRequest(Collections.singletonList("sim"), "Assignment", "contains", "Test Automation 124");
        List responseMessages = this.atpActionService.occupyTestDataFullRow(lazyProject.getName(), lazyEnvironment.getName(), system.getName(), catalog.getTableTitle(), Collections.singletonList(occupyRowRequest));
        ResponseMessage responseMessage = responseMessages.stream().findFirst().orElse(new ResponseMessage());
        this.deleteTestDataTableIfExists(tableName);
        this.catalogRepository.deleteByTableName(tableName);
        Assertions.assertEquals((Object)ResponseType.ERROR, (Object)responseMessage.getType());
        Assertions.assertEquals((Object)"No test data available for requested criteria!", (Object)responseMessage.getContent());
    }

    @Test
    public void atpOccupyTestData_wrongSearchValueInput_nothingFoundErrorMessage() {
        String tableName = "tdm_api_test_occupy_wrong_search_value";
        TestDataTableCatalog catalog = this.createTestDataTableCatalog(projectId, systemId, environmentId, "TDM API Test Occupy With Wrong Search Value", tableName);
        this.createTestDataTable(catalog.getTableName());
        OccupyRowRequest occupyRowRequest = this.buildOccupyRowRequest("SIM", "Assignment", "contains", "Test Automation 124");
        List responseMessages = this.atpActionService.occupyTestData(lazyProject.getName(), lazyEnvironment.getName(), system.getName(), catalog.getTableTitle(), Collections.singletonList(occupyRowRequest));
        ResponseMessage responseMessage = responseMessages.stream().findFirst().orElse(new ResponseMessage());
        this.deleteTestDataTableIfExists(tableName);
        this.catalogRepository.deleteByTableName(tableName);
        Assertions.assertEquals((Object)ResponseType.ERROR, (Object)responseMessage.getType());
        Assertions.assertEquals((Object)"No test data available for requested criteria!", (Object)responseMessage.getContent());
    }

    @Test
    public void atpOccupyTestData_wrongTable_tableWasNotFoundErrorMessage() {
        String tableTitle = "Wrong Table Title";
        List responseMessages = this.atpActionService.occupyTestData(lazyProject.getName(), lazyEnvironment.getName(), system.getName(), tableTitle, Collections.emptyList());
        ResponseMessage responseMessage = responseMessages.stream().findFirst().orElse(new ResponseMessage());
        Assertions.assertEquals((Object)ResponseType.ERROR, (Object)responseMessage.getType());
        Assertions.assertEquals((Object)String.format("Table with title \"%s\" was not found!", tableTitle), (Object)responseMessage.getContent());
    }

    @Test
    public void atpOccupyTestDataFullRow_wrongTable_tableWasNotFoundErrorMessage() throws IOException {
        String tableTitle = "Wrong Table Title";
        List responseMessages = this.atpActionService.occupyTestDataFullRow(lazyProject.getName(), lazyEnvironment.getName(), system.getName(), tableTitle, Collections.emptyList());
        ResponseMessage responseMessage = responseMessages.stream().findFirst().orElse(new ResponseMessage());
        Assertions.assertEquals((Object)ResponseType.ERROR, (Object)responseMessage.getType());
        Assertions.assertEquals((Object)String.format("Table with title \"%s\" was not found!", tableTitle), (Object)responseMessage.getContent());
    }

    @Test
    public void atpReleaseTestData_applyFilterTypeContains_successfullyFind() {
        String tableName = "tdm_api_test_release_contains_filter";
        TestDataTableCatalog catalog = this.createTestDataTableCatalog(projectId, systemId, environmentId, "TDM API Test Release", tableName);
        this.createTestDataTable(catalog.getTableName());
        OccupyRowRequest occupyRowRequest = this.buildOccupyRowRequest("Assignment", "sim", "Contains", "12607200401410");
        ReleaseRowRequest releaseRowRequest = this.buildReleaseRowRequest("Assignment", "sim", "Contains", "12607200401410");
        List responseMessages = this.atpActionService.occupyTestData(lazyProject.getName(), lazyEnvironment.getName(), system.getName(), catalog.getTableTitle(), Collections.singletonList(occupyRowRequest));
        ResponseMessage responseMessage = responseMessages.stream().findFirst().orElse(new ResponseMessage());
        Assertions.assertEquals((Object)ResponseType.SUCCESS, (Object)responseMessage.getType());
        List releaseResponseMessages = this.atpActionService.releaseTestData(lazyProject.getName(), lazyEnvironment.getName(), system.getName(), catalog.getTableTitle(), Collections.singletonList(releaseRowRequest));
        ResponseMessage releaseResponseMessage = releaseResponseMessages.stream().findFirst().orElse(new ResponseMessage());
        String expectedResponseMessage = "Test Automation 4";
        this.deleteTestDataTableIfExists(tableName);
        this.catalogRepository.deleteByTableName(tableName);
        Assertions.assertEquals((Object)expectedResponseMessage, (Object)releaseResponseMessage.getContent());
        Assertions.assertEquals((Object)ResponseType.SUCCESS, (Object)responseMessage.getType());
    }

    @Test
    public void atpReleaseTestData_applyFilterTypeStartWith_successfullyFind() {
        String tableName = "tdm_api_test_release_start_with_filter";
        TestDataTableCatalog catalog = this.createTestDataTableCatalog(projectId, systemId, environmentId, "TDM API Test Release - Start With", tableName);
        this.createTestDataTable(catalog.getTableName());
        OccupyRowRequest occupyRowRequest = this.buildOccupyRowRequest("Assignment", "sim", "Start With", "89012607200401410");
        ReleaseRowRequest releaseRowRequest = this.buildReleaseRowRequest("Assignment", "sim", "Start With", "89012607200401410");
        List responseMessages = this.atpActionService.occupyTestData(lazyProject.getName(), lazyEnvironment.getName(), system.getName(), catalog.getTableTitle(), Collections.singletonList(occupyRowRequest));
        ResponseMessage responseMessage = responseMessages.stream().findFirst().orElse(new ResponseMessage());
        Assertions.assertEquals((Object)ResponseType.SUCCESS, (Object)responseMessage.getType());
        List releaseResponseMessages = this.atpActionService.releaseTestData(lazyProject.getName(), lazyEnvironment.getName(), system.getName(), catalog.getTableTitle(), Collections.singletonList(releaseRowRequest));
        ResponseMessage releaseResponseMessage = releaseResponseMessages.stream().findFirst().orElse(new ResponseMessage());
        String expectedResponseMessage = "Test Automation 4";
        this.deleteTestDataTableIfExists(tableName);
        this.catalogRepository.deleteByTableName(tableName);
        Assertions.assertEquals((Object)expectedResponseMessage, (Object)releaseResponseMessage.getContent());
        Assertions.assertEquals((Object)ResponseType.SUCCESS, (Object)responseMessage.getType());
    }

    @Test
    public void atpReleaseTestData_applyFilterForMultipleRows_moreThanOneRowError() {
        String tableName = "tdm_api_test_release_multiple_rows";
        TestDataTableCatalog catalog = this.createTestDataTableCatalog(projectId, systemId, environmentId, "TDM API Test Release - Multiple Rows", tableName);
        this.createTestDataTable(catalog.getTableName());
        OccupyRowRequest occupyRowRequestFirst = this.buildOccupyRowRequest("Assignment", "sim", "Start With", "89012607200401410");
        OccupyRowRequest occupyRowRequestSecond = this.buildOccupyRowRequest("Assignment", "sim", "Start With", "8901260720040140975");
        ReleaseRowRequest releaseRowRequest = this.buildReleaseRowRequest("Assignment", "sim", "Start With", "89");
        List responseMessages = this.atpActionService.occupyTestData(lazyProject.getName(), lazyEnvironment.getName(), system.getName(), catalog.getTableTitle(), Collections.singletonList(occupyRowRequestFirst));
        ResponseMessage responseMessage = responseMessages.stream().findFirst().orElse(new ResponseMessage());
        Assertions.assertEquals((Object)ResponseType.SUCCESS, (Object)responseMessage.getType());
        responseMessages.clear();
        responseMessages = this.atpActionService.occupyTestData(lazyProject.getName(), lazyEnvironment.getName(), system.getName(), catalog.getTableTitle(), Collections.singletonList(occupyRowRequestSecond));
        responseMessage = responseMessages.stream().findFirst().orElse(new ResponseMessage());
        Assertions.assertEquals((Object)ResponseType.SUCCESS, (Object)responseMessage.getType());
        List releaseResponseMessages = this.atpActionService.releaseTestData(lazyProject.getName(), lazyEnvironment.getName(), system.getName(), catalog.getTableTitle(), Collections.singletonList(releaseRowRequest));
        ResponseMessage releaseResponseMessage = releaseResponseMessages.stream().findFirst().orElse(new ResponseMessage());
        String expectedResponseMessage = "More than one value was found using the specified search criteria!";
        this.deleteTestDataTableIfExists(tableName);
        this.catalogRepository.deleteByTableName(tableName);
        Assertions.assertEquals((Object)expectedResponseMessage, (Object)releaseResponseMessage.getContent());
        Assertions.assertEquals((Object)ResponseType.ERROR, (Object)releaseResponseMessage.getType());
    }

    @Test
    public void atpReleaseTestData_wrongColumnNameInput_returnErrorMessage() {
        String tableName = "tdm_api_test_release_wrong_response_column_name";
        TestDataTableCatalog catalog = this.createTestDataTableCatalog(projectId, systemId, environmentId, "TDM API Test Release - Wrong Column Name", tableName);
        this.createTestDataTable(catalog.getTableName());
        OccupyRowRequest occupyRowRequest = this.buildOccupyRowRequest("Assignment", "sim", "Start With", "89012607200401410");
        ReleaseRowRequest releaseRowRequest = this.buildReleaseRowRequest("Wrong Column Name", "sim", "Start With", "89012607200401410");
        List responseMessages = this.atpActionService.occupyTestData(lazyProject.getName(), lazyEnvironment.getName(), system.getName(), catalog.getTableTitle(), Collections.singletonList(occupyRowRequest));
        ResponseMessage responseMessage = responseMessages.stream().findFirst().orElse(new ResponseMessage());
        Assertions.assertEquals((Object)ResponseType.SUCCESS, (Object)responseMessage.getType());
        List releaseResponseMessages = this.atpActionService.releaseTestData(lazyProject.getName(), lazyEnvironment.getName(), system.getName(), catalog.getTableTitle(), Collections.singletonList(releaseRowRequest));
        ResponseMessage releaseResponseMessage = releaseResponseMessages.stream().findFirst().orElse(new ResponseMessage());
        this.deleteTestDataTableIfExists(tableName);
        this.catalogRepository.deleteByTableName(tableName);
        Assertions.assertEquals((Object)ResponseType.ERROR, (Object)releaseResponseMessage.getType());
        Assertions.assertEquals((Object)"Column with name \"Wrong Column Name\" was not found!", (Object)releaseResponseMessage.getContent());
    }

    @Test
    public void atpReleaseTestData_wrongSearchValueInput_nothingFoundErrorMessage() {
        String tableName = "tdm_api_test_release_wrong_search_value";
        TestDataTableCatalog catalog = this.createTestDataTableCatalog(projectId, systemId, environmentId, "TDM API Test Release With Wrong Search Value", tableName);
        this.createTestDataTable(catalog.getTableName());
        OccupyRowRequest occupyRowRequest = this.buildOccupyRowRequest("Assignment", "sim", "Start With", "89012607200401410");
        ReleaseRowRequest releaseRowRequest = this.buildReleaseRowRequest("Assignment", "sim", "Start With", "123");
        List responseMessages = this.atpActionService.occupyTestData(lazyProject.getName(), lazyEnvironment.getName(), system.getName(), catalog.getTableTitle(), Collections.singletonList(occupyRowRequest));
        ResponseMessage responseMessage = responseMessages.stream().findFirst().orElse(new ResponseMessage());
        Assertions.assertEquals((Object)ResponseType.SUCCESS, (Object)responseMessage.getType());
        List releaseResponseMessages = this.atpActionService.releaseTestData(lazyProject.getName(), lazyEnvironment.getName(), system.getName(), catalog.getTableTitle(), Collections.singletonList(releaseRowRequest));
        ResponseMessage releaseResponseMessage = releaseResponseMessages.stream().findFirst().orElse(new ResponseMessage());
        this.deleteTestDataTableIfExists(tableName);
        this.catalogRepository.deleteByTableName(tableName);
        Assertions.assertEquals((Object)ResponseType.ERROR, (Object)releaseResponseMessage.getType());
        Assertions.assertEquals((Object)"No test data available for requested criteria!", (Object)releaseResponseMessage.getContent());
    }

    @Test
    public void atpUpdateTestData_onlyProjectSelected_successfulUpdate() {
        String tableName = "tdm_api_test_update_under_project";
        TestDataTableCatalog catalog = this.createTestDataTableCatalog(projectId, null, null, "TDM API Test Update Under Project", tableName);
        this.createTestDataTable(catalog.getTableName());
        UpdateRowRequest updateRowRequest = new UpdateRowRequest();
        this.verifyChangingTableRow(catalog, (ChangeRowRequest)updateRowRequest);
        this.deleteTestDataTableIfExists(tableName);
        this.catalogRepository.deleteByTableName(tableName);
    }

    @Test
    public void atpUpdateTestData_projectAndSystemSelected_successfulUpdate() {
        String tableName = "tdm_api_test_update_under_system";
        TestDataTableCatalog catalog = this.createTestDataTableCatalog(projectId, systemId, environmentId, "TDM API Test Update Under System", tableName);
        this.createTestDataTable(catalog.getTableName());
        UpdateRowRequest updateRowRequest = new UpdateRowRequest();
        this.verifyChangingTableRow(catalog, (ChangeRowRequest)updateRowRequest);
        this.deleteTestDataTableIfExists(tableName);
        this.catalogRepository.deleteByTableName(tableName);
    }

    @Test
    public void atpUpdateTestData_wrongFilters_noTestDataAvailableErrorMessage() {
        String tableTitle = "TDM API Test Update Wrong Filters";
        String tableName = "tdm_api_update_wrong_filters";
        this.createTestDataTableCatalog(projectId, systemId, environmentId, tableTitle, tableName);
        this.createTestDataTable(tableName);
        List<ApiDataFilter> wrongFilters = Collections.singletonList(new ApiDataFilter("Assignment", "equals", "Test Automation 194", false));
        HashMap<String, String> recordWithDataForUpdate = new HashMap<String, String>();
        recordWithDataForUpdate.put("environment", "ZLAB109");
        ArrayList<UpdateRowRequest> updateRowRequests = new ArrayList<UpdateRowRequest>();
        UpdateRowRequest updateRowRequest = new UpdateRowRequest();
        updateRowRequest.setFilters(wrongFilters);
        updateRowRequest.setRecordWithDataForUpdate(recordWithDataForUpdate);
        updateRowRequests.add(updateRowRequest);
        List responseMessages = this.atpActionService.updateTestData(lazyProject.getName(), lazyEnvironment.getName(), system.getName(), tableTitle, updateRowRequests);
        ResponseMessage responseMessage = responseMessages.stream().findFirst().orElse(new ResponseMessage());
        this.deleteTestDataTableIfExists(tableName);
        this.catalogRepository.deleteByTableName(tableName);
        Assertions.assertEquals((Object)ResponseType.ERROR, (Object)responseMessage.getType());
        Assertions.assertEquals((Object)"No test data available for requested criteria!", (Object)responseMessage.getContent());
    }

    @Test
    public void atpUpdateTestData_wrongTable_tableWasNotFoundErrorMessage() {
        String tableTitle = "TDM API Test Update Wrong Table Title";
        List responseMessages = this.atpActionService.updateTestData(lazyProject.getName(), lazyEnvironment.getName(), system.getName(), tableTitle, Collections.emptyList());
        ResponseMessage responseMessage = responseMessages.stream().findFirst().orElse(new ResponseMessage());
        Assertions.assertEquals((Object)ResponseType.ERROR, (Object)responseMessage.getType());
        Assertions.assertEquals((Object)String.format("Table with title \"%s\" was not found!", tableTitle), (Object)responseMessage.getContent());
    }

    @Test
    public void atpGetTestData_onlyProjectSelected_returnTable() {
        String tableName = "tdm_api_test_get_under_project";
        this.verifyGettingTableRecord("TDM API Test Get Under Project", tableName, projectId, null, null);
    }

    @Test
    public void atpGetTestData_systemAndProjectSelected_returnTable() {
        String tableName = "tdm_api_test_get_under_system";
        this.verifyGettingTableRecord("TDM API Test Get Under System", tableName, projectId, systemId, environmentId);
    }

    @Test
    public void atpGetTestData_wrongTable_tableWasNotFoundErrorMessage() {
        String tableName = "tdm_api_test_get_date_wrong_table";
        TestDataTableCatalog catalog = this.createTestDataTableCatalog(projectId, null, null, "TDM API Test Get Data Wrong Table", tableName);
        this.createTestDataTable(catalog.getTableName());
        GetRowRequest getRowRequest = this.buildGetRowRequest("Assignment", "sim", "Contains", "12607200401410");
        String wrongTableTitle = "TDM API Test Get Data Wrong";
        List responseMessages = this.atpActionService.getTestData(lazyProject.getName(), lazyEnvironment.getName(), null, wrongTableTitle, Collections.singletonList(getRowRequest));
        ResponseMessage responseMessage = responseMessages.stream().findFirst().orElse(new ResponseMessage());
        this.deleteTestDataTableIfExists(tableName);
        this.catalogRepository.deleteByTableName(tableName);
        Assertions.assertEquals((Object)ResponseType.ERROR, (Object)responseMessage.getType());
        Assertions.assertEquals((Object)String.format("Table with title \"%s\" was not found!", wrongTableTitle), (Object)responseMessage.getContent());
    }

    @Test
    public void atpGetTestData_wrongFilters_rowsWereNotFoundErrorMessage() {
        String tableName = "tdm_api_test_get_date_wrong_filter";
        TestDataTableCatalog catalog = this.createTestDataTableCatalog(projectId, null, null, "TDM API Test Get Data Wrong Filter", tableName);
        this.createTestDataTable(catalog.getTableName());
        GetRowRequest getRowRequest = this.buildGetRowRequest("Assignment", "sim", "Contains", "126072004014133");
        List responseMessages = this.atpActionService.getTestData(lazyProject.getName(), lazyEnvironment.getName(), null, catalog.getTableTitle(), Collections.singletonList(getRowRequest));
        ResponseMessage responseMessage = responseMessages.stream().findFirst().orElse(new ResponseMessage());
        this.deleteTestDataTableIfExists(tableName);
        this.catalogRepository.deleteByTableName(tableName);
        Assertions.assertEquals((Object)ResponseType.ERROR, (Object)responseMessage.getType());
        Assertions.assertEquals((Object)"No test data available for requested criteria!", (Object)responseMessage.getContent());
    }

    @Test
    public void atpGetTestData_wrongColumnName_columnWasNotFoundErrorMessage() {
        String tableName = "tdm_api_test_get_date_wrong_column";
        TestDataTableCatalog catalog = this.createTestDataTableCatalog(projectId, null, null, "TDM API Test Get Data Wrong Column", tableName);
        this.createTestDataTable(catalog.getTableName());
        GetRowRequest getRowRequest = this.buildGetRowRequest("Assignment 123", "sim", "Contains", "12607200401410");
        List responseMessages = this.atpActionService.getTestData(lazyProject.getName(), lazyEnvironment.getName(), null, catalog.getTableTitle(), Collections.singletonList(getRowRequest));
        ResponseMessage responseMessage = responseMessages.stream().findFirst().orElse(new ResponseMessage());
        this.deleteTestDataTableIfExists(tableName);
        this.catalogRepository.deleteByTableName(tableName);
        Assertions.assertEquals((Object)ResponseType.ERROR, (Object)responseMessage.getType());
        Assertions.assertEquals((Object)"Column with name \"Assignment 123\" was not found!", (Object)responseMessage.getContent());
    }

    @Test
    public void atpAddInfoToTestData_onlyProjectSelected_addedSuccessfully() {
        String tableName = "tdm_api_test_add_info_under_project";
        TestDataTableCatalog catalog = this.createTestDataTableCatalog(projectId, null, null, "TDM API Test Add info Under Project", tableName);
        this.createTestDataTable(catalog.getTableName());
        AddInfoToRowRequest addInfoToRowRequest = new AddInfoToRowRequest();
        this.verifyChangingTableRow(catalog, (ChangeRowRequest)addInfoToRowRequest);
        this.deleteTestDataTableIfExists(tableName);
        this.catalogRepository.deleteByTableName(tableName);
    }

    @Test
    public void atpAddInfoToTestData_systemAndProjectSelected_addedSuccessfully() {
        String tableName = "tdm_api_test_add_info_under_system";
        TestDataTableCatalog catalog = this.createTestDataTableCatalog(projectId, systemId, environmentId, "TDM API Test Add info Under System", tableName);
        this.createTestDataTable(catalog.getTableName());
        AddInfoToRowRequest addInfoToRowRequest = new AddInfoToRowRequest();
        this.verifyChangingTableRow(catalog, (ChangeRowRequest)addInfoToRowRequest);
        this.deleteTestDataTableIfExists(tableName);
        this.catalogRepository.deleteByTableName(tableName);
    }

    @Test
    public void atpAddInfoToTestData_wrongFilters_noTestDataAvailableErrorMessage() {
        String tableTitle = "TDM API Test Add info Wrong Filters";
        String tableName = "tdm_api_test_add_info_wrong_filters";
        this.createTestDataTableCatalog(projectId, systemId, environmentId, tableTitle, tableName);
        this.createTestDataTable(tableName);
        List<ApiDataFilter> wrongFilters = Collections.singletonList(new ApiDataFilter("Assignment", "equals", "Test Automation 194", false));
        HashMap<String, String> recordWithDataForUpdate = new HashMap<String, String>();
        recordWithDataForUpdate.put("environment", "ZLAB109");
        ArrayList<AddInfoToRowRequest> addInfoToRowRequests = new ArrayList<AddInfoToRowRequest>();
        AddInfoToRowRequest addInfoToRowRequest = new AddInfoToRowRequest();
        addInfoToRowRequest.setFilters(wrongFilters);
        addInfoToRowRequest.setRecordWithDataForUpdate(recordWithDataForUpdate);
        addInfoToRowRequests.add(addInfoToRowRequest);
        List responseMessages = this.atpActionService.addInfoToRow(lazyProject.getName(), lazyEnvironment.getName(), system.getName(), tableTitle, addInfoToRowRequests);
        ResponseMessage responseMessage = responseMessages.stream().findFirst().orElse(new ResponseMessage());
        this.deleteTestDataTableIfExists(tableName);
        this.catalogRepository.deleteByTableName(tableName);
        Assertions.assertEquals((Object)ResponseType.ERROR, (Object)responseMessage.getType());
        Assertions.assertEquals((Object)"No test data available for requested criteria!", (Object)responseMessage.getContent());
    }

    @Test
    public void atpAddInfoToTestData_wrongTable_tableWasNotFoundErrorMessage() {
        String tableName = "tdm_api_test_add_info_wrong_table";
        TestDataTableCatalog catalog = this.createTestDataTableCatalog(UUID.randomUUID(), UUID.randomUUID(), UUID.randomUUID(), "TDM API Test Add info Wrong Table", tableName);
        this.createTestDataTable(catalog.getTableName());
        String wrongTableTitle = "Wrong Table Title";
        List responseMessages = this.atpActionService.addInfoToRow(lazyProject.getName(), lazyEnvironment.getName(), system.getName(), wrongTableTitle, Collections.emptyList());
        ResponseMessage responseMessage = responseMessages.stream().findFirst().orElse(new ResponseMessage());
        this.deleteTestDataTableIfExists(tableName);
        this.catalogRepository.deleteByTableName(tableName);
        Assertions.assertEquals((Object)ResponseType.ERROR, (Object)responseMessage.getType());
        Assertions.assertEquals((Object)String.format("Table with title \"%s\" was not found!", wrongTableTitle), (Object)responseMessage.getContent());
    }

    @Test
    public void atpTruncateTable_truncateTable_tableTruncated() {
        String tableTitle = "tableTitleForTruncateTable";
        String tableName = "tdm_api_test_truncate_table";
        TestDataTableCatalog catalog = this.createTestDataTableCatalog(lazyProject.getId(), system.getId(), lazyEnvironment.getId(), tableTitle, tableName);
        TestDataTable testDataTable = this.createTestDataTable(catalog.getTableName());
        testDataTable.setTitle(tableTitle);
        this.atpActionService.truncateTable(lazyProject.getId().toString(), lazyEnvironment.getName(), system.getName(), tableTitle);
        boolean isDataRemoved = this.testDataTableRepository.getFullTestData(tableName).getData().isEmpty();
        this.deleteTestDataTableIfExists(tableName);
        this.catalogRepository.deleteByTableName(tableName);
        Assertions.assertTrue((boolean)isDataRemoved);
    }

    @Test
    public void atpTruncateTable_truncateTable_correctMessageHasBeenGot() {
        String tableTitle = "tableTitleForTruncateTableCorrectMessage";
        String tableName = "tdm_api_test_truncate_table_correct_message";
        TestDataTableCatalog catalog = this.createTestDataTableCatalog(lazyProject.getId(), system.getId(), lazyEnvironment.getId(), tableTitle, tableName);
        TestDataTable testDataTable = this.createTestDataTable(catalog.getTableName());
        testDataTable.setTitle(tableTitle);
        List responseMessages = this.atpActionService.truncateTable(lazyProject.getId().toString(), lazyEnvironment.getName(), system.getName(), tableTitle);
        ResponseMessage responseMessage = responseMessages.stream().findFirst().orElse(new ResponseMessage());
        this.deleteTestDataTableIfExists(tableName);
        this.catalogRepository.deleteByTableName(tableName);
        Assertions.assertEquals((Object)String.format("Table %s has been truncated.", tableName), (Object)responseMessage.getContent());
    }

    @Test
    public void atpTruncateTable_truncateTable_tableWasNotFound() {
        String wrongTableTitle = "Wrong table title";
        List responseMessages = this.atpActionService.truncateTable(lazyProject.getId().toString(), lazyEnvironment.getName(), system.getName(), wrongTableTitle);
        ResponseMessage responseMessage = responseMessages.stream().findFirst().orElse(new ResponseMessage());
        Assertions.assertEquals((Object)String.format("Tables with title: %s was not found under project with id: %s", wrongTableTitle, lazyProject.getId()), (Object)responseMessage.getContent());
    }

    @Test
    public void atpRunCleanupForTable_runCleanup_cleanupCompletedWithSuccessMessage() throws Exception {
        String tableTitle = "tableTitleForRunCleanupTableCorrectMessage";
        String tableName = "tdm_api_test_run_cleanup_table_correct_message";
        TestDataTableCatalog catalog = this.createTestDataTableCatalog(lazyProject.getId(), system.getId(), lazyEnvironment.getId(), tableTitle, tableName);
        TestDataTable testDataTable = this.createTestDataTable(catalog.getTableName());
        testDataTable.setTitle(tableTitle);
        this.mockEnvironmentService(Collections.singletonList(lazyEnvironment.getId()), systemId, systemId);
        TestDataCleanupConfig cleanupConfig = this.createDateCleanupConfig(catalog);
        catalog.setCleanupConfigId(cleanupConfig.getId());
        List responseMessages = this.atpActionService.runCleanupForTable(lazyProject.getId().toString(), lazyEnvironment.getName(), system.getName(), tableTitle);
        ResponseMessage responseMessage = responseMessages.stream().findFirst().orElse(new ResponseMessage());
        this.deleteTestDataTableIfExists(tableName);
        this.catalogRepository.deleteByTableName(tableName);
        Assertions.assertEquals((Object)String.format("For table \"%s\" with total records %s has been removed %s records.", tableName, 6, 0), (Object)responseMessage.getContent());
    }

    @Test
    public void atpRunCleanupForTable_runCleanup_cleanupCompletedWithErrorMessage() throws Exception {
        String tableTitle = "tableTitleForRunCleanupTableBySql";
        String tableName = "tdm_api_test_run_cleanup_table_by_sql";
        TestDataTableCatalog catalog = this.createTestDataTableCatalog(lazyProject.getId(), system.getId(), lazyEnvironment.getId(), tableTitle, tableName);
        TestDataTable testDataTable = this.createTestDataTable(catalog.getTableName());
        testDataTable.setTitle(tableTitle);
        this.mockEnvironmentService(Collections.singletonList(lazyEnvironment.getId()), systemId, systemId);
        TestDataCleanupConfig cleanupConfig = this.createErrorSqlCleanupConfig(catalog, false);
        catalog.setCleanupConfigId(cleanupConfig.getId());
        List responseMessages = this.atpActionService.runCleanupForTable(lazyProject.getId().toString(), lazyEnvironment.getName(), system.getName(), tableTitle);
        ResponseMessage responseMessage = responseMessages.stream().findFirst().orElse(new ResponseMessage());
        this.deleteTestDataTableIfExists(tableName);
        this.catalogRepository.deleteByTableName(tableName);
        Assertions.assertEquals((Object)String.format("Cleanup %s for table %s failed.\nError while run cleanup. Column 'PartnerR' doesn't exist", cleanupConfig, tableName), (Object)responseMessage.getContent());
    }

    @Test
    public void atpRunCleanupForTable_prepareDataWithoutCleanupConfRunCleanup_cleanupNotFound() {
        String tableTitle = "tableTitleForRunCleanupTableErrorMessage";
        String tableName = "tdm_api_test_run_cleanup_table_error_message";
        TestDataTableCatalog catalog = this.createTestDataTableCatalog(lazyProject.getId(), system.getId(), lazyEnvironment.getId(), tableTitle, tableName);
        TestDataTable testDataTable = this.createTestDataTable(catalog.getTableName());
        testDataTable.setTitle(tableTitle);
        List responseMessages = this.atpActionService.runCleanupForTable(lazyProject.getId().toString(), lazyEnvironment.getName(), system.getName(), tableTitle);
        ResponseMessage responseMessage = responseMessages.stream().findFirst().orElse(new ResponseMessage());
        this.deleteTestDataTableIfExists(tableName);
        this.catalogRepository.deleteByTableName(tableName);
        Assertions.assertEquals((Object)String.format("Cleanup hasn't been configured for table \"%s\".", tableTitle), (Object)responseMessage.getContent());
    }

    @Test
    public void atpRunCleanupForTable_runCleanupWithoutPreparation_tableNotFound() {
        String tableTitle = "tableTitleForNotExistTable";
        List responseMessages = this.atpActionService.runCleanupForTable(lazyProject.getId().toString(), lazyEnvironment.getName(), system.getName(), tableTitle);
        ResponseMessage responseMessage = responseMessages.stream().findFirst().orElse(new ResponseMessage());
        Assertions.assertEquals((Object)String.format("Table \"%s\" hasn't been found. Could you please check provided data.", tableTitle), (Object)responseMessage.getContent());
    }

    protected OccupyRowRequest buildOccupyRowRequest(String nameColumnResponse, String columnName, String searchType, String searchValue) {
        OccupyRowRequest occupyRowRequest = new OccupyRowRequest();
        occupyRowRequest.setNameColumnResponse(nameColumnResponse);
        ApiDataFilter filter = new ApiDataFilter(columnName, searchType, searchValue, false);
        occupyRowRequest.setFilters(Collections.singletonList(filter));
        return occupyRowRequest;
    }

    protected OccupyFullRowRequest buildOccupyFullRowRequest(List<String> nameColumnResponse, String columnName, String searchType, String searchValue) {
        OccupyFullRowRequest occupyFullRowRequest = new OccupyFullRowRequest();
        occupyFullRowRequest.setResponseColumnNames(nameColumnResponse);
        ApiDataFilter filter = new ApiDataFilter(columnName, searchType, searchValue, false);
        occupyFullRowRequest.setFilters(Collections.singletonList(filter));
        return occupyFullRowRequest;
    }

    private ReleaseRowRequest buildReleaseRowRequest(String nameColumnResponse, String columnName, String searchType, String searchValue) {
        ReleaseRowRequest releaseRowRequest = new ReleaseRowRequest();
        releaseRowRequest.setNameColumnResponse(nameColumnResponse);
        ApiDataFilter filter = new ApiDataFilter(columnName, searchType, searchValue, false);
        releaseRowRequest.setFilters(Collections.singletonList(filter));
        return releaseRowRequest;
    }

    protected GetRowRequest buildGetRowRequest(String nameColumnResponse, String columnName, String searchType, String searchValue) {
        GetRowRequest getRowRequest = new GetRowRequest();
        getRowRequest.setNameColumnResponse(nameColumnResponse);
        ApiDataFilter filter = new ApiDataFilter(columnName, searchType, searchValue, false);
        getRowRequest.setFilters(Collections.singletonList(filter));
        return getRowRequest;
    }

    private void verifyCreationNewTableWithRecords(String tableTitle, UUID projectId, UUID systemId, String expectedResponseMessage) {
        String linkFull = "localhost:8080/project/%s/tdm/TEST%%20DATA/%s/%s/";
        String linkNullSystem = "localhost:8080/project/%s/";
        if (Objects.nonNull(systemId)) {
            UUID lazyEnvironmentId = lazyEnvironment.getId();
            this.verifyCreationTableWithRecords(tableTitle, projectId, systemId, String.format(linkFull, AtpActionServiceTest.projectId, lazyEnvironmentId, systemId), expectedResponseMessage);
        } else {
            this.verifyCreationTableWithRecords(tableTitle, projectId, systemId, String.format(linkNullSystem, AtpActionServiceTest.projectId), expectedResponseMessage);
        }
    }

    private void verifyCreationPreCreatedTableWithRecords(String tableTitle, UUID projectId, UUID systemId, String expectedResponseMessage) {
        String link = "localhost:8080/project/%s/tdm/TEST%%20DATA/%s/%s/";
        this.verifyCreationTableWithRecords(tableTitle, projectId, systemId, String.format(link, AtpActionServiceTest.projectId, lazyEnvironment.getId(), systemId), expectedResponseMessage);
    }

    private void verifyCreationTableWithRecords(String tableTitle, UUID projectId, UUID systemId, String link, String expectedResponseMessage) {
        String systemName = Objects.nonNull(systemId) ? system.getName() : null;
        this.verifyCreationTableWithRecords(tableTitle, projectId, lazyProject.getName(), lazyEnvironment.getName(), systemId, systemName, link, expectedResponseMessage);
    }

    private void verifyCreationTableWithRecords(String tableTitle, UUID projectId, String projectName, String envName, UUID systemId, String systemName, String link, String expectedResponseMessage) {
        List records = this.buildTestDataTable().getData();
        ResponseMessage responseMessage = this.atpActionService.insertTestData(projectName, envName, systemName, tableTitle, records);
        TestDataTableCatalog tableCatalog = this.catalogRepository.findByProjectIdAndSystemIdAndTableTitle(projectId, systemId, tableTitle);
        Assertions.assertEquals((Object)ResponseType.SUCCESS, (Object)responseMessage.getType());
        Assertions.assertEquals((Object)expectedResponseMessage, (Object)responseMessage.getContent());
        Assertions.assertEquals((Object)(link + tableCatalog.getTableName()), (Object)responseMessage.getLink());
        TestDataTable testDataTable = this.testDataService.getTestData(tableCatalog.getTableName());
        for (int i = 0; i < records.size(); ++i) {
            Map erRecord = (Map)records.get(i);
            Map arRecord = (Map)testDataTable.getData().get(i);
            for (String key : erRecord.keySet()) {
                Object erValue = erRecord.get(key);
                Object arValue = arRecord.get(key);
                Assertions.assertEquals(erValue, arValue);
            }
        }
    }

    private void verifyOccupationTableRow(String tableTitle, String tableName, UUID projectId, UUID systemId, UUID envId) {
        TestDataTableCatalog catalog = this.createTestDataTableCatalog(projectId, systemId, envId, tableTitle, tableName);
        this.createTestDataTable(catalog.getTableName());
        OccupyRowRequest occupyRowRequest = this.buildOccupyRowRequest("Assignment", "sim", "Contains", "12607200401410");
        String systemName = Objects.nonNull(systemId) ? system.getName() : null;
        List responseMessages = this.atpActionService.occupyTestData(lazyProject.getName(), lazyEnvironment.getName(), systemName, catalog.getTableTitle(), Collections.singletonList(occupyRowRequest));
        ResponseMessage responseMessage = responseMessages.stream().findFirst().orElse(new ResponseMessage());
        Assertions.assertEquals((Object)ResponseType.SUCCESS, (Object)responseMessage.getType());
        UUID lazyEnvironmentId = Objects.nonNull(systemId) ? lazyEnvironment.getId() : null;
        String expectedResponseMessage = "Test Automation 4";
        String linkFull = "localhost:8080/project/%s/tdm/TEST%%20DATA/%s/%s/%s";
        String linkNullSystem = "localhost:8080/project/%s/%s";
        Assertions.assertEquals((Object)expectedResponseMessage, (Object)responseMessage.getContent());
        if (Objects.nonNull(systemId)) {
            Assertions.assertEquals((Object)String.format(linkFull, AtpActionServiceTest.projectId, lazyEnvironmentId, systemId, catalog.getTableName()), (Object)responseMessage.getLink());
        } else {
            Assertions.assertEquals((Object)String.format(linkNullSystem, AtpActionServiceTest.projectId, catalog.getTableName()), (Object)responseMessage.getLink());
        }
        this.deleteTestDataTableIfExists(tableName);
        this.catalogRepository.deleteByTableName(tableName);
    }

    private void verifyOccupationTableFullRow(String tableTitle, String tableName, UUID projectId, UUID systemId, UUID envId) {
        TestDataTableCatalog catalog = this.createTestDataTableCatalog(projectId, systemId, envId, tableTitle, tableName);
        this.createTestDataTable(catalog.getTableName());
        OccupyFullRowRequest occupyRowRequest = this.buildOccupyFullRowRequest(Collections.singletonList("Assignment"), "sim", "Contains", "12607200401410");
        String systemName = Objects.nonNull(systemId) ? system.getName() : null;
        List responseMessages = this.atpActionService.occupyTestDataFullRow(lazyProject.getName(), lazyEnvironment.getName(), systemName, catalog.getTableTitle(), Collections.singletonList(occupyRowRequest));
        ResponseMessage responseMessage = responseMessages.stream().findFirst().orElse(new ResponseMessage());
        Assertions.assertEquals((Object)ResponseType.SUCCESS, (Object)responseMessage.getType());
        UUID lazyEnvironmentId = Objects.nonNull(systemId) ? lazyEnvironment.getId() : null;
        HashMap<String, String> expectedResponseValues = new HashMap<String, String>();
        expectedResponseValues.put("Assignment", "Test Automation 4");
        Object actualResponseMap = responseMessage.getContentObject();
        Assertions.assertEquals(expectedResponseValues, (Object)actualResponseMap);
        if (Objects.nonNull(systemId)) {
            String linkFull = "localhost:8080/project/%s/tdm/TEST%%20DATA/%s/%s/%s";
            Assertions.assertEquals((Object)String.format(linkFull, AtpActionServiceTest.projectId, lazyEnvironmentId, systemId, catalog.getTableName()), (Object)responseMessage.getLink());
        } else {
            String linkNullSystem = "localhost:8080/project/%s/%s";
            Assertions.assertEquals((Object)String.format(linkNullSystem, AtpActionServiceTest.projectId, catalog.getTableName()), (Object)responseMessage.getLink());
        }
        this.deleteTestDataTableIfExists(tableName);
        this.catalogRepository.deleteByTableName(tableName);
    }

    private void verifyChangingTableRow(TestDataTableCatalog catalog, ChangeRowRequest changeRowRequest) {
        List responseMessages;
        List<ApiDataFilter> apiDataFilters = Collections.singletonList(new ApiDataFilter("Assignment", "contains", "Test Automation 4", false));
        changeRowRequest.setFilters(apiDataFilters);
        HashMap<String, String> recordWithDataForUpdate = new HashMap<String, String>();
        recordWithDataForUpdate.put("environment", "ZLAB109");
        changeRowRequest.setRecordWithDataForUpdate(recordWithDataForUpdate);
        String systemName = Objects.nonNull(catalog.getSystemId()) ? system.getName() : null;
        List<TestDataTableFilter> filters = Collections.singletonList(new TestDataTableFilter("Assignment", "contains", Collections.singletonList("Test Automation 4"), false));
        if (changeRowRequest instanceof AddInfoToRowRequest) {
            AddInfoToRowRequest addInfoToRow = (AddInfoToRowRequest)changeRowRequest;
            responseMessages = this.atpActionService.addInfoToRow(lazyProject.getName(), lazyEnvironment.getName(), systemName, catalog.getTableTitle(), Collections.singletonList(addInfoToRow));
            TestDataTable table = this.testDataService.getTestData(catalog.getTableName(), null, null, filters, null, Boolean.valueOf(false));
            Assertions.assertEquals((Object)"ZLAB04\r\nZLAB109", ((Map)table.getData().get(0)).get("environment"));
        } else {
            UpdateRowRequest updateRow = (UpdateRowRequest)changeRowRequest;
            responseMessages = this.atpActionService.updateTestData(lazyProject.getName(), lazyEnvironment.getName(), systemName, catalog.getTableTitle(), Collections.singletonList(updateRow));
            TestDataTable table = this.testDataService.getTestData(catalog.getTableName(), null, null, filters, null, Boolean.valueOf(false));
            Assertions.assertEquals((Object)"ZLAB109", ((Map)table.getData().get(0)).get("environment"));
        }
        ResponseMessage responseMessage = responseMessages.stream().findFirst().orElse(new ResponseMessage());
        Assertions.assertEquals((Object)ResponseType.SUCCESS, (Object)responseMessage.getType());
    }

    private void verifyGettingTableRecord(String tableTitle, String tableName, UUID projectId, UUID systemId, UUID envId) {
        TestDataTableCatalog catalog = this.createTestDataTableCatalog(projectId, systemId, envId, tableTitle, tableName);
        this.createTestDataTable(catalog.getTableName());
        GetRowRequest getRowRequest = this.buildGetRowRequest("Assignment", "sim", "Contains", "12607200401410");
        String systemName = Objects.nonNull(systemId) ? system.getName() : null;
        List responseMessages = this.atpActionService.getTestData(lazyProject.getName(), lazyEnvironment.getName(), systemName, catalog.getTableTitle(), Collections.singletonList(getRowRequest));
        ResponseMessage responseMessage = responseMessages.stream().findFirst().orElse(new ResponseMessage());
        Assertions.assertEquals((Object)ResponseType.SUCCESS, (Object)responseMessage.getType());
        Assertions.assertEquals((Object)"Test Automation 4", (Object)responseMessage.getContent());
        this.deleteTestDataTableIfExists(tableName);
        this.catalogRepository.deleteByTableName(tableName);
    }

    @Test
    public void atpReleaseAllTestData_rightTableName_successfullyRelease() {
        String tableName = "tdm_api_test_release_all_success";
        TestDataTableCatalog catalog = this.createTestDataTableCatalog(projectId, systemId, environmentId, "TDM API Test Full Release", tableName);
        this.createTestDataTable(catalog.getTableName());
        OccupyRowRequest occupyRowRequest = this.buildOccupyRowRequest("Assignment", "sim", "Contains", "12607200401410");
        List responseMessages = this.atpActionService.occupyTestData(lazyProject.getName(), lazyEnvironment.getName(), system.getName(), catalog.getTableTitle(), Collections.singletonList(occupyRowRequest));
        ResponseMessage responseMessage = responseMessages.stream().findFirst().orElse(new ResponseMessage());
        Assertions.assertEquals((Object)ResponseType.SUCCESS, (Object)responseMessage.getType());
        List releaseResponseMessages = this.atpActionService.releaseFullTestData(lazyProject.getName(), lazyEnvironment.getName(), system.getName(), catalog.getTableTitle());
        ResponseMessage releaseResponseMessage = releaseResponseMessages.stream().findFirst().orElse(new ResponseMessage());
        String expectedResponseMessage = "All occupied data in table with title \"TDM API Test Full Release\" released.";
        this.deleteTestDataTableIfExists(tableName);
        this.catalogRepository.deleteByTableName(tableName);
        Assertions.assertEquals((Object)expectedResponseMessage, (Object)releaseResponseMessage.getContent());
        Assertions.assertEquals((Object)ResponseType.SUCCESS, (Object)responseMessage.getType());
    }

    @Test
    public void atpReleaseAllTestData_wrongTableName_failRelease() {
        String tableName = "tdm_api_test_release_all_wrong";
        TestDataTableCatalog catalog = this.createTestDataTableCatalog(projectId, systemId, environmentId, "TDM API Test Full Release Wrong", tableName);
        this.createTestDataTable(catalog.getTableName());
        OccupyRowRequest occupyRowRequest = this.buildOccupyRowRequest("Assignment", "sim", "Contains", "12607200401410");
        List responseMessages = this.atpActionService.occupyTestData(lazyProject.getName(), lazyEnvironment.getName(), system.getName(), catalog.getTableTitle(), Collections.singletonList(occupyRowRequest));
        ResponseMessage responseMessage = responseMessages.stream().findFirst().orElse(new ResponseMessage());
        Assertions.assertEquals((Object)ResponseType.SUCCESS, (Object)responseMessage.getType());
        List releaseResponseMessages = this.atpActionService.releaseFullTestData(lazyProject.getName(), lazyEnvironment.getName(), system.getName(), "wrong");
        ResponseMessage releaseResponseMessage = releaseResponseMessages.stream().findFirst().orElse(new ResponseMessage());
        String expectedResponseMessage = "Table with title \"wrong\" was not found!";
        this.deleteTestDataTableIfExists(tableName);
        this.catalogRepository.deleteByTableName(tableName);
        Assertions.assertEquals((Object)expectedResponseMessage, (Object)releaseResponseMessage.getContent());
        Assertions.assertEquals((Object)ResponseType.SUCCESS, (Object)responseMessage.getType());
    }
}

