/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.utils;

import org.junit.Assert;
import org.junit.Test;
import org.qubership.atp.tdm.utils.ValidateCronExpression;

public class ValidateCronExpressionTest {
    @Test
    public void validateCronExpression_saveCronEverySecondUseStar_returnException() {
        String incorrectCron = "* 0 9 ? * *";
        try {
            ValidateCronExpression.validate((String)incorrectCron);
        }
        catch (Exception e) {
            String errorMessage = String.format("Check Cron Expression: %s. First and second value cannot be '*'", incorrectCron);
            Assert.assertEquals((Object)errorMessage, (Object)e.getMessage());
        }
    }

    @Test
    public void validateCronExpression_saveCronEverySecondUseSlash_returnException() {
        String incorrectCron = "0/1 5 9 ? * *";
        try {
            ValidateCronExpression.validate((String)incorrectCron);
        }
        catch (Exception e) {
            String errorMessage = String.format("Check Cron Expression: %s. First and second value cannot be '*'", incorrectCron);
            Assert.assertEquals((Object)errorMessage, (Object)e.getMessage());
        }
    }

    @Test
    public void validateCronExpression_saveCronEveryMinute_returnException() {
        String incorrectCron = "0 * 9 ? * *";
        try {
            ValidateCronExpression.validate((String)incorrectCron);
        }
        catch (Exception e) {
            String errorMessage = String.format("Check Cron Expression: %s. First and second value cannot be '*'", incorrectCron);
            Assert.assertEquals((Object)errorMessage, (Object)e.getMessage());
        }
    }
}

