/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.websocket.bulkaction.dataload;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.qubership.atp.tdm.AbstractTestDataTest;
import org.qubership.atp.tdm.model.CommonResults;
import org.qubership.atp.tdm.model.bulkaction.BulkActionConfig;
import org.qubership.atp.tdm.model.bulkaction.BulkActionResult;
import org.qubership.atp.tdm.model.mail.bulkaction.BulkCleanupMailSender;
import org.qubership.atp.tdm.model.refresh.RefreshResults;
import org.qubership.atp.tdm.model.table.TestDataTable;
import org.qubership.atp.tdm.service.DataRefreshService;
import org.qubership.atp.tdm.websocket.bulkaction.dataload.BulkDataImportHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.socket.WebSocketSession;

public class BulkDataImportHandlerTest
extends AbstractTestDataTest {
    @Autowired
    ExecutorService executorService;
    @Autowired
    BulkCleanupMailSender bulkCleanupMailSender;
    @Autowired
    DataRefreshService dataRefreshService;
    WebSocketSession session;
    BulkDataImportHandler bulkDataImportHandler;

    @BeforeEach
    public void setUp() throws Exception {
        this.bulkDataImportHandler = new BulkDataImportHandler(this.executorService, this.catalogRepository, this.environmentsService, this.bulkCleanupMailSender, this.dataRefreshService, this.importInfoRepository, this.currentTime, this.lockManager, this.tdmMdcHelper);
        Mockito.when((Object)this.environmentsService.getConnectionsSystemById((UUID)ArgumentMatchers.any())).thenReturn(Collections.singletonList(dbConnection));
    }

    @Test
    public void runBulkAction_saveQueryAndUpdateTable_bulkActionIsCorrect() throws Exception {
        final UUID projectId = UUID.randomUUID();
        long processId = System.currentTimeMillis();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        String tableName = "tdm_run_balk_import_refresh_results";
        final String tableTitle = "TDM Run Balk Import Refresh Result";
        BulkActionConfig bulkActionConfig = new BulkActionConfig(){
            {
                this.setProjectId(projectId);
                this.setSystemId(systemId);
                this.setSaveOccupiedData(false);
                this.setExecuteInParallel(false);
                this.setSendResult(false);
                this.setRecipients("example@example.com");
                this.setTableTitle(tableTitle);
            }
        };
        this.createTestDataTable(tableName);
        String importQuery = "select SIM from " + tableName;
        this.createTestDataTableCatalog(projectId, systemId, environmentId, tableTitle, tableName, importQuery);
        BulkActionResult expectedBulkActionResult = new BulkActionResult(tableTitle, tableName, "Test Environment", (CommonResults)new RefreshResults(6));
        List futures = this.bulkDataImportHandler.runBulkAction(this.session, executor, this.lazyEnvironments, bulkActionConfig, processId);
        BulkActionResult actualBulkActionResult = (BulkActionResult)((Future)futures.get(0)).get();
        Assertions.assertEquals((Object)expectedBulkActionResult, (Object)actualBulkActionResult);
        this.deleteTestDataTableIfExists(tableName);
        this.catalogRepository.deleteByTableName(tableName);
    }

    @Test
    public void runBulkAction_saveQueryAndUpdateTable_testDataTableUpdated() throws Exception {
        final UUID projectId = UUID.randomUUID();
        long processId = System.currentTimeMillis();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        String tableName = "tdm_run_balk_import_refresh_table";
        final String tableTitle = "TDM Run Balk Import Refresh Table";
        BulkActionConfig bulkActionConfig = new BulkActionConfig(){
            {
                this.setProjectId(projectId);
                this.setSystemId(systemId);
                this.setSaveOccupiedData(false);
                this.setExecuteInParallel(false);
                this.setSendResult(false);
                this.setRecipients("example@example.com");
                this.setTableTitle(tableTitle);
            }
        };
        this.createTestDataTable(tableName);
        String importQuery = "select SIM from " + tableName;
        this.createTestDataTableCatalog(projectId, systemId, environmentId, tableTitle, tableName, importQuery);
        TestDataTable expected = this.testDataService.getTestData(tableName);
        List futures = this.bulkDataImportHandler.runBulkAction(this.session, executor, this.lazyEnvironments, bulkActionConfig, processId);
        BulkActionResult actualBulkActionResult = (BulkActionResult)((Future)futures.get(0)).get();
        TestDataTable actual = this.testDataService.getTestData(tableName);
        Assertions.assertNotEquals((Object)expected, (Object)actual);
        this.deleteTestDataTableIfExists(tableName);
        this.catalogRepository.deleteByTableName(tableName);
    }
}

