/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.websocket.bulkaction.links;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.qubership.atp.tdm.AbstractTestDataTest;
import org.qubership.atp.tdm.model.CommonResults;
import org.qubership.atp.tdm.model.LinkSetupResult;
import org.qubership.atp.tdm.model.bulkaction.BulkActionConfig;
import org.qubership.atp.tdm.model.bulkaction.BulkActionResult;
import org.qubership.atp.tdm.model.mail.bulkaction.BulkLinksRefreshMailSender;
import org.qubership.atp.tdm.model.table.TestDataTable;
import org.qubership.atp.tdm.model.table.column.TestDataTableColumn;
import org.qubership.atp.tdm.service.ColumnService;
import org.qubership.atp.tdm.websocket.bulkaction.links.BulkDataLinksRefreshHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.socket.WebSocketSession;

public class BulkDataLinksRefreshHandlerTest
extends AbstractTestDataTest {
    @Autowired
    ExecutorService executorService;
    @Autowired
    ColumnService columnService;
    @Autowired
    BulkLinksRefreshMailSender bulkLinksRefreshMailSender;
    WebSocketSession session;
    BulkDataLinksRefreshHandler bulkDataLinksRefreshHandler;

    @BeforeEach
    public void setUp() throws Exception {
        this.bulkDataLinksRefreshHandler = new BulkDataLinksRefreshHandler(this.executorService, this.catalogRepository, this.environmentsService, this.columnService, this.bulkLinksRefreshMailSender, this.currentTime, this.lockManager, this.tdmMdcHelper);
        Mockito.when((Object)this.environmentsService.getConnectionsSystemById((UUID)ArgumentMatchers.any())).thenReturn(Collections.singletonList(httpConnection));
    }

    @AfterEach
    public void after() {
        this.deleteTestDataTableIfExists("tdm_run_balk_link_setup");
        this.catalogRepository.deleteAll();
    }

    @Test
    public void runBulkAction_saveRowNameInColumnRepository_bulkActionIsCorrect() throws Exception {
        final UUID projectId = UUID.randomUUID();
        long processId = System.currentTimeMillis();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        String tableName = "tdm_run_balk_link_setup";
        final String tableTitle = "TDM Run Balk Link Setup";
        BulkActionConfig bulkActionConfig = new BulkActionConfig(){
            {
                this.setProjectId(projectId);
                this.setSystemId(systemId);
                this.setSaveOccupiedData(false);
                this.setExecuteInParallel(false);
                this.setSendResult(false);
                this.setRecipients("example@example.com");
                this.setTableTitle(tableTitle);
            }
        };
        this.createTestDataTable(tableName);
        this.createTestDataTableCatalog(projectId, systemId, environmentId, tableTitle, tableName);
        TestDataTable testDataTable = this.testDataService.getTestData(tableName);
        List columns = testDataTable.getColumns();
        for (TestDataTableColumn column : columns) {
            if (!column.getIdentity().getColumnName().equals("sim")) continue;
            this.columnService.setupColumnLinks(Boolean.valueOf(false), projectId, systemId, tableName, column.getIdentity().getColumnName(), "?objectId=", Boolean.valueOf(false));
        }
        String row = "sim";
        BulkActionResult expectedBulkActionResult = new BulkActionResult(tableTitle, tableName, "Test Environment", (CommonResults)new LinkSetupResult(row));
        List futures = this.bulkDataLinksRefreshHandler.runBulkAction(this.session, executor, this.lazyEnvironments, bulkActionConfig, processId);
        BulkActionResult actualBulkActionResult = (BulkActionResult)((Future)futures.get(0)).get();
        Assertions.assertEquals((Object)expectedBulkActionResult, (Object)actualBulkActionResult);
        this.deleteTestDataTableIfExists(tableName);
        this.catalogRepository.deleteByTableName(tableName);
    }
}

