/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.configuration;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.spi.JobFactory;
import org.qubership.atp.tdm.utils.scheduler.AutowiringSpringBeanJobFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;

@Configuration
public class QuartzConfig {
    private static final Logger log = LoggerFactory.getLogger(QuartzConfig.class);
    private final ApplicationContext applicationContext;
    private final Properties props = new Properties();

    @Autowired
    public QuartzConfig(@Qualifier(value="application.properties") Properties props, ApplicationContext applicationContext) {
        this.props.putAll(props.entrySet().stream().filter(e -> e.getKey().toString().startsWith("org.quartz")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        this.applicationContext = applicationContext;
    }

    @Bean
    public JobFactory jobFactory() {
        AutowiringSpringBeanJobFactory jobFactory = new AutowiringSpringBeanJobFactory();
        jobFactory.setApplicationContext(this.applicationContext);
        return jobFactory;
    }

    @Nullable
    @Bean
    public Scheduler scheduler(SchedulerFactoryBean schedulerFactoryBean) {
        Scheduler scheduler;
        Scheduler scheduler2 = scheduler = schedulerFactoryBean != null ? schedulerFactoryBean.getScheduler() : null;
        if (scheduler != null) {
            try {
                scheduler.start();
            }
            catch (SchedulerException e) {
                log.error("Error while occurred starting scheduler", (Throwable)e);
            }
        }
        return scheduler;
    }

    @Bean
    public SchedulerFactoryBean schedulerFactoryBean(DataSource dataSource, JobFactory jobFactory) throws IOException {
        SchedulerFactoryBean factory = new SchedulerFactoryBean();
        factory.setDataSource(dataSource);
        factory.setJobFactory(jobFactory);
        factory.setQuartzProperties(this.props);
        return factory;
    }
}

