/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.ei;

import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.collections4.CollectionUtils;
import org.qubership.atp.ei.node.ExportExecutor;
import org.qubership.atp.ei.node.dto.ExportImportData;
import org.qubership.atp.ei.node.services.ObjectSaverToDiskService;
import org.qubership.atp.tdm.ei.ServiceScopeEntities;
import org.qubership.atp.tdm.model.TestDataTableCatalog;
import org.qubership.atp.tdm.model.cleanup.TestDataCleanupConfig;
import org.qubership.atp.tdm.model.ei.ExportImportObject;
import org.qubership.atp.tdm.model.ei.ExportTable;
import org.qubership.atp.tdm.model.refresh.TestDataRefreshConfig;
import org.qubership.atp.tdm.model.table.TestDataTable;
import org.qubership.atp.tdm.repo.CatalogRepository;
import org.qubership.atp.tdm.repo.CleanupConfigRepository;
import org.qubership.atp.tdm.repo.ColumnRepository;
import org.qubership.atp.tdm.repo.ImportInfoRepository;
import org.qubership.atp.tdm.repo.RefreshConfigRepository;
import org.qubership.atp.tdm.repo.TestDataColumnFlagsRepository;
import org.qubership.atp.tdm.repo.TestDataMonitoringRepository;
import org.qubership.atp.tdm.repo.TestDataTableRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class TdmExportExecutor
implements ExportExecutor {
    private static final Logger log = LoggerFactory.getLogger(TdmExportExecutor.class);
    @Value(value="${spring.application.name}")
    private String implementationName;
    private final ObjectSaverToDiskService objectSaverToDiskService;
    private final TestDataTableRepository testDataTableRepository;
    private final CatalogRepository catalogRepository;
    private final CleanupConfigRepository cleanupConfigRepository;
    private final ColumnRepository columnRepository;
    private final ImportInfoRepository importInfoRepository;
    private final RefreshConfigRepository refreshConfigRepository;
    private final TestDataMonitoringRepository testDataMonitoringRepository;
    private final TestDataColumnFlagsRepository testDataColumnFlagsRepository;

    public void exportToFolder(ExportImportData exportData, Path path) throws Exception {
        Set exportScopeAtpTdmTables = exportData.getExportScope().getEntities().getOrDefault(ServiceScopeEntities.ENTITY_ATP_TDM_TABLES.getValue(), new HashSet());
        if (CollectionUtils.isNotEmpty((Collection)exportScopeAtpTdmTables)) {
            log.info("Start export for project {}", (Object)exportData.getProjectId());
            this.saveData(exportData.getProjectId(), path);
            log.info("Finish export for project {}", (Object)exportData.getProjectId());
        } else {
            log.error("Data hasn't been found, for project: [{}]", (Object)exportData.getProjectId());
        }
    }

    public String getExportImplementationName() {
        return this.implementationName;
    }

    private void saveData(@Nonnull UUID projectId, @Nonnull Path workDir) {
        ExportImportObject exportImportObject = this.exportData(projectId);
        this.objectSaverToDiskService.exportAtpEntity(projectId, (Object)exportImportObject, workDir);
    }

    private ExportImportObject exportData(@Nonnull UUID projectId) {
        log.info("Export data for project id:[{}] started...", (Object)projectId);
        List<TestDataTableCatalog> tableCatalogs = this.catalogRepository.findAllByProjectId(projectId);
        List<ExportTable> exportTables = this.createExportTable(tableCatalogs);
        ExportImportObject exportResponse = new ExportImportObject();
        exportResponse.setProjectId(projectId);
        exportResponse.setTables(exportTables);
        this.testDataMonitoringRepository.findById(projectId).ifPresent(exportResponse::setTestDataMonitoring);
        log.info("Export finished.");
        return exportResponse;
    }

    private List<ExportTable> createExportTable(List<TestDataTableCatalog> tableCatalogs) {
        return tableCatalogs.stream().map(tableCatalog -> this.fillExportTableByData(this.createExportTable((TestDataTableCatalog)tableCatalog), (TestDataTableCatalog)tableCatalog)).collect(Collectors.toList());
    }

    private ExportTable createExportTable(TestDataTableCatalog tableCatalog) {
        UUID environmentId = tableCatalog.getEnvironmentId();
        UUID systemId = tableCatalog.getSystemId();
        return new ExportTable(systemId, environmentId, tableCatalog.getTableName(), tableCatalog.getTableTitle());
    }

    private ExportTable fillExportTableByData(ExportTable exportTable, TestDataTableCatalog tableCatalog) {
        UUID cleanupConfigId = tableCatalog.getCleanupConfigId();
        if (Objects.nonNull(cleanupConfigId)) {
            exportTable.setCleanupConfig(this.cleanupConfigRepository.findById(cleanupConfigId).orElseGet(() -> {
                log.warn("Cleanup config with id:[{}] was not found.", (Object)cleanupConfigId);
                TestDataCleanupConfig testDataCleanupConfig = new TestDataCleanupConfig();
                testDataCleanupConfig.setId(cleanupConfigId);
                return testDataCleanupConfig;
            }));
        }
        exportTable.setColumns(this.columnRepository.findAllByIdentityTableName(tableCatalog.getTableName()));
        exportTable.setImportInfo(this.importInfoRepository.findByTableName(tableCatalog.getTableName()));
        UUID refreshConfigId = tableCatalog.getRefreshConfigId();
        if (Objects.nonNull(refreshConfigId)) {
            exportTable.setRefreshConfig(this.refreshConfigRepository.findById(refreshConfigId).orElseGet(() -> {
                log.warn("Refresh config with id:[{}] was not found.", (Object)refreshConfigId);
                TestDataRefreshConfig refreshConfig = new TestDataRefreshConfig();
                refreshConfig.setId(cleanupConfigId);
                return refreshConfig;
            }));
        }
        exportTable.setFlagsTable(this.testDataColumnFlagsRepository.findRowByTableName(tableCatalog.getTableName()));
        TestDataTable testDataTable = this.testDataTableRepository.getFullTestData(tableCatalog.getTableName());
        exportTable.setData(testDataTable.getData());
        return exportTable;
    }

    public TdmExportExecutor(ObjectSaverToDiskService objectSaverToDiskService, TestDataTableRepository testDataTableRepository, CatalogRepository catalogRepository, CleanupConfigRepository cleanupConfigRepository, ColumnRepository columnRepository, ImportInfoRepository importInfoRepository, RefreshConfigRepository refreshConfigRepository, TestDataMonitoringRepository testDataMonitoringRepository, TestDataColumnFlagsRepository testDataColumnFlagsRepository) {
        this.objectSaverToDiskService = objectSaverToDiskService;
        this.testDataTableRepository = testDataTableRepository;
        this.catalogRepository = catalogRepository;
        this.cleanupConfigRepository = cleanupConfigRepository;
        this.columnRepository = columnRepository;
        this.importInfoRepository = importInfoRepository;
        this.refreshConfigRepository = refreshConfigRepository;
        this.testDataMonitoringRepository = testDataMonitoringRepository;
        this.testDataColumnFlagsRepository = testDataColumnFlagsRepository;
    }
}

