/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.model.scheduler;

import java.util.List;
import java.util.UUID;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.qubership.atp.tdm.model.cleanup.CleanupResults;
import org.qubership.atp.tdm.service.CleanupService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@DisallowConcurrentExecution
public class DataCleanupJob
implements Job {
    private static final Logger log = LoggerFactory.getLogger(DataCleanupJob.class);
    @Autowired
    private CleanupService service;

    public void execute(JobExecutionContext context) throws JobExecutionException {
        MDC.clear();
        UUID id = UUID.fromString(context.getJobDetail().getKey().getName());
        try {
            log.info("Running scheduled cleanup for job with id: {}", (Object)id);
            List<CleanupResults> results = this.service.runCleanup(id);
            log.info("Cleanup results for job with id: {} results: {}", (Object)id, results);
        }
        catch (Exception e) {
            log.error("An error occurred while running scheduled cleanup with id: {}", (Object)id, (Object)e);
        }
    }
}

