/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.model.table.conditions.factories;

import org.qubership.atp.tdm.model.table.conditions.search.SearchCondition;
import org.qubership.atp.tdm.model.table.conditions.search.SearchConditionType;
import org.qubership.atp.tdm.model.table.conditions.search.impl.ContainsCondition;
import org.qubership.atp.tdm.model.table.conditions.search.impl.DateCondition;
import org.qubership.atp.tdm.model.table.conditions.search.impl.EqualsCondition;
import org.qubership.atp.tdm.model.table.conditions.search.impl.StartWithCondition;

public class SearchConditionFactory {
    public static SearchCondition getCondition(String conditionType, boolean caseSensitive) {
        switch (SearchConditionType.find(conditionType)) {
            case CONTAINS: {
                return new ContainsCondition(caseSensitive);
            }
            case START_WITH: {
                return new StartWithCondition(caseSensitive);
            }
            case EQUALS: {
                return new EqualsCondition();
            }
            case FROM: {
                return new DateCondition("FROM");
            }
            case TO: {
                return new DateCondition("TO");
            }
        }
        throw new IllegalArgumentException("Unknown search condition type: " + conditionType);
    }
}

