/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.engio.mbassy.bus.MBassador;
import org.docx4j.Docx4jProperties;
import org.docx4j.TraversalUtil;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.FOSettings;
import org.docx4j.convert.out.HTMLSettings;
import org.docx4j.convert.out.common.Exporter;
import org.docx4j.convert.out.common.preprocess.PartialDeepCopy;
import org.docx4j.convert.out.html.HTMLExporterVisitor;
import org.docx4j.convert.out.html.HTMLExporterXslt;
import org.docx4j.events.Docx4jEvent;
import org.docx4j.events.EventFinished;
import org.docx4j.events.PackageIdentifier;
import org.docx4j.events.StartEvent;
import org.docx4j.events.WellKnownJobTypes;
import org.docx4j.events.WellKnownProcessSteps;
import org.docx4j.model.datastorage.BindingHandler;
import org.docx4j.model.datastorage.CustomXmlDataStoragePartSelector;
import org.docx4j.model.datastorage.DocxFetcher;
import org.docx4j.model.datastorage.DomToXPathMap;
import org.docx4j.model.datastorage.OpenDoPEHandler;
import org.docx4j.model.datastorage.OpenDoPEHandlerComponents;
import org.docx4j.model.datastorage.OpenDoPEIntegrity;
import org.docx4j.model.datastorage.OpenDoPEIntegrityAfterBinding;
import org.docx4j.model.datastorage.RemovalHandler;
import org.docx4j.model.datastorage.XsltFinisher;
import org.docx4j.model.datastorage.XsltProvider;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.io3.Load3;
import org.docx4j.openpackaging.io3.stores.ZipPartStore;
import org.docx4j.openpackaging.packages.Filetype;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.CustomXmlPart;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.opendope.ConditionsPart;
import org.docx4j.openpackaging.parts.opendope.XPathsPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.services.client.ConverterHttp;
import org.docx4j.services.client.Format;
import org.docx4j.utils.TraversalUtilVisitor;
import org.docx4j.wml.SdtElement;
import org.docx4j.wml.SdtPr;
import org.opendope.answers.Answers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class Docx4J {
    private static Logger log = LoggerFactory.getLogger(Docx4J.class);
    public static final String MIME_PDF = "application/pdf";
    public static final String MIME_FO = "application/xml-fo";
    public static final int FLAG_NONE = 0;
    public static final int FLAG_EXPORT_PREFER_XSL = 1;
    public static final int FLAG_EXPORT_PREFER_NONXSL = 2;
    public static Boolean EXPORT_FO_DETECTED = null;
    public static final int FLAG_SAVE_ZIP_FILE = 1;
    public static final int FLAG_SAVE_FLAT_XML = 2;
    public static final int FLAG_SAVE_ENCRYPTED_BINARYRC4 = 3;
    public static final int FLAG_SAVE_ENCRYPTED_STANDARD = 4;
    public static final int FLAG_SAVE_ENCRYPTED_AGILE = 5;
    public static final int FLAG_BIND_INSERT_XML = 1;
    public static final int FLAG_BIND_BIND_XML = 2;
    public static final int FLAG_BIND_REMOVE_SDT = 4;
    public static final int FLAG_BIND_REMOVE_XML = 8;
    private static MBassador<Docx4jEvent> bus;
    protected static final String NS_CONDITIONS = "http://opendope.org/conditions";
    protected static final String NS_XPATHS = "http://opendope.org/xpaths";
    protected static final String NS_QUESTIONS = "http://opendope.org/questions";
    protected static final String NS_COMPONENTS = "http://opendope.org/components";
    protected static final Set<String> PART_TO_REMOVE_SCHEMA_TYPES;

    public static boolean pdfViaFO() {
        if (EXPORT_FO_DETECTED == null) {
            try {
                Exporter<FOSettings> o = Docx4J.FOExporterVisitorGetInstance();
                EXPORT_FO_DETECTED = Boolean.TRUE;
            }
            catch (Docx4JException e) {
                EXPORT_FO_DETECTED = Boolean.FALSE;
            }
        }
        return EXPORT_FO_DETECTED;
    }

    public static void setEventNotifier(MBassador<Docx4jEvent> eventbus) {
        bus = eventbus;
    }

    public static OpcPackage load(File inFile, Filetype type) throws Docx4JException {
        return OpcPackage.load(inFile);
    }

    public static WordprocessingMLPackage load(File inFile) throws Docx4JException {
        return WordprocessingMLPackage.load(inFile);
    }

    public static WordprocessingMLPackage load(PackageIdentifier pkgIdentifier, File inFile) throws Docx4JException {
        return (WordprocessingMLPackage)OpcPackage.load(pkgIdentifier, inFile);
    }

    public static WordprocessingMLPackage load(InputStream inStream) throws Docx4JException {
        return WordprocessingMLPackage.load(inStream);
    }

    public static WordprocessingMLPackage load(PackageIdentifier pkgIdentifier, InputStream inStream) throws Docx4JException {
        return (WordprocessingMLPackage)OpcPackage.load(pkgIdentifier, inStream);
    }

    public static void save(WordprocessingMLPackage wmlPackage, File outFile) throws Docx4JException {
        wmlPackage.save(outFile, 1);
    }

    public static void save(WordprocessingMLPackage wmlPackage, File outFile, int flags) throws Docx4JException {
        wmlPackage.save(outFile, flags);
    }

    public static void save(WordprocessingMLPackage wmlPackage, OutputStream outStream) throws Docx4JException {
        wmlPackage.save(outStream, 1);
    }

    public static void save(WordprocessingMLPackage wmlPackage, OutputStream outStream, int flags) throws Docx4JException {
        wmlPackage.save(outStream, flags);
    }

    public static void save(WordprocessingMLPackage wmlPackage, File outFile, int flags, String password) throws Docx4JException {
        wmlPackage.save(outFile, flags, password);
    }

    public static void save(WordprocessingMLPackage wmlPackage, OutputStream outStream, int flags, String password) throws Docx4JException {
        wmlPackage.save(outStream, flags, password);
    }

    public static void bind(WordprocessingMLPackage wmlPackage, String xmlDocument, int flags) throws Docx4JException {
        ByteArrayInputStream xmlStream = null;
        if (flags == 0) {
            flags = 15;
        }
        if ((flags & 1) == 1) {
            try {
                xmlStream = new ByteArrayInputStream(xmlDocument.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e1) {
                xmlStream = new ByteArrayInputStream(xmlDocument.getBytes());
            }
        }
        Docx4J.bind(wmlPackage, xmlStream, flags);
    }

    public static void bind(WordprocessingMLPackage wmlPackage, InputStream xmlDocument, int flags) throws Docx4JException {
        if (flags == 0) {
            flags = 15;
        }
        Document xmlDoc = null;
        if ((flags & 1) == 1) {
            try {
                xmlDoc = XmlUtils.getNewDocumentBuilder().parse(xmlDocument);
            }
            catch (Exception e) {
                throw new Docx4JException("Problems creating a org.w3c.dom.Document for the passed input stream.", e);
            }
        }
        Docx4J.bind(wmlPackage, xmlDoc, flags);
    }

    public static void bind(WordprocessingMLPackage wmlPackage, Answers answers, int flags) throws Docx4JException {
        if (flags == 0) {
            flags = 15;
        }
        Document xmlDoc = null;
        if ((flags & 1) == 1) {
            try {
                xmlDoc = XmlUtils.marshaltoW3CDomDocument(answers);
            }
            catch (Exception e) {
                throw new Docx4JException("Problems creating a org.w3c.dom.Document from Answers", e);
            }
        }
        Docx4J.bind(wmlPackage, xmlDoc, flags);
    }

    public static void bind(WordprocessingMLPackage wmlPackage, Document xmlDocument, int flags) throws Docx4JException {
        Docx4J.bind(wmlPackage, xmlDocument, flags, null);
    }

    public static void bind(WordprocessingMLPackage wmlPackage, Document xmlDocument, int flags, DocxFetcher docxFetcher) throws Docx4JException {
        Docx4J.bind(wmlPackage, xmlDocument, flags, docxFetcher, null, null, null);
    }

    public static void bind(WordprocessingMLPackage wmlPackage, Document xmlDocument, int flags, DocxFetcher docxFetcher, XsltProvider xsltProvider, String xsltFinisherfilename, Map<String, Map<String, Object>> finisherParams) throws Docx4JException {
        StartEvent startEvent;
        StartEvent bindJobStartEvent = new StartEvent(WellKnownJobTypes.BIND, wmlPackage);
        bindJobStartEvent.publish();
        OpenDoPEHandler openDoPEHandler = null;
        CustomXmlPart customXmlPart = null;
        Object removalHandler = null;
        Object bookmarkId = null;
        if (flags == 0) {
            flags = 15;
        }
        if ((customXmlPart = CustomXmlDataStoragePartSelector.getCustomXmlDataStoragePart(wmlPackage)) == null && flags != 4) {
            throw new Docx4JException("Couldn't find CustomXmlDataStoragePart! exiting..");
        }
        if ((flags & 1) == 1) {
            log.debug("insertXMLData");
            StartEvent startEvent2 = new StartEvent(WellKnownJobTypes.BIND, wmlPackage, WellKnownProcessSteps.BIND_INSERT_XML);
            startEvent2.publish();
            Docx4J.insertXMLData(customXmlPart, xmlDocument);
            new EventFinished(startEvent2).publish();
        }
        BindingHandler bh = null;
        if ((flags & 2) == 2) {
            log.debug("openDoPEHandler");
            startEvent = new StartEvent(WellKnownJobTypes.BIND, wmlPackage, WellKnownProcessSteps.BIND_BIND_XML_OpenDoPEHandler);
            startEvent.publish();
            WordprocessingMLPackage tmpMergeResult = wmlPackage;
            if (Docx4jProperties.getProperty("docx4j.model.datastorage.OpenDoPEHandlerComponents.enabled", false)) {
                OpenDoPEHandlerComponents componentsHandler = new OpenDoPEHandlerComponents(wmlPackage);
                if (docxFetcher != null) {
                    OpenDoPEHandlerComponents.setDocxFetcher(docxFetcher);
                }
                tmpMergeResult = componentsHandler.fetchComponents();
            }
            openDoPEHandler = new OpenDoPEHandler(tmpMergeResult);
            tmpMergeResult = openDoPEHandler.preprocess();
            DomToXPathMap domToXPathMap = openDoPEHandler.getDomToXPathMap();
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            Docx4J.save(tmpMergeResult, outStream);
            ZipPartStore partLoader = new ZipPartStore(new ByteArrayInputStream(outStream.toByteArray()));
            Load3 loader = new Load3(partLoader);
            loader.reuseExistingOpcPackage(wmlPackage);
            loader.get();
            new EventFinished(startEvent).publish();
            startEvent = new StartEvent(WellKnownJobTypes.BIND, wmlPackage, WellKnownProcessSteps.BIND_BIND_XML_OpenDoPEIntegrity);
            startEvent.publish();
            log.debug("OpenDoPEIntegrity");
            OpenDoPEIntegrity odi = new OpenDoPEIntegrity();
            odi.process(wmlPackage);
            new EventFinished(startEvent).publish();
            startEvent = new StartEvent(WellKnownJobTypes.BIND, wmlPackage, WellKnownProcessSteps.BIND_BIND_XML_BindingHandler);
            startEvent.publish();
            bh = new BindingHandler(wmlPackage);
            bh.setStartingIdForNewBookmarks(openDoPEHandler.getNextBookmarkId());
            bh.setDomToXPathMap(domToXPathMap);
            bh.applyBindings();
            new EventFinished(startEvent).publish();
            startEvent = new StartEvent(WellKnownJobTypes.BIND, wmlPackage, WellKnownProcessSteps.BIND_BIND_XML_OpenDoPEIntegrityAfterBinding);
            startEvent.publish();
            log.debug("OpenDoPEIntegrityAfterBinding");
            OpenDoPEIntegrityAfterBinding odiab = new OpenDoPEIntegrityAfterBinding();
            odiab.process(wmlPackage);
            new EventFinished(startEvent).publish();
        }
        if (xsltProvider != null) {
            startEvent = new StartEvent(WellKnownJobTypes.BIND, wmlPackage, WellKnownProcessSteps.BIND_BIND_XML_XsltFinisher);
            startEvent.publish();
            XsltFinisher finisher = new XsltFinisher(wmlPackage);
            XsltFinisher.setXsltProvider(xsltProvider);
            finisher.apply(wmlPackage.getMainDocumentPart(), bh.getXpathsMap(), xsltFinisherfilename, finisherParams);
            new EventFinished(startEvent).publish();
        }
        if ((flags & 4) == 4) {
            startEvent = new StartEvent(WellKnownJobTypes.BIND, wmlPackage, WellKnownProcessSteps.BIND_REMOVE_SDT);
            startEvent.publish();
            log.debug("removeSDTs");
            Docx4J.removeSDTs(wmlPackage);
            new EventFinished(startEvent).publish();
        }
        if ((flags & 8) == 8) {
            startEvent = new StartEvent(WellKnownJobTypes.BIND, wmlPackage, WellKnownProcessSteps.BIND_REMOVE_XML);
            startEvent.publish();
            log.debug("removeDefinedCustomXmlParts");
            Docx4J.removeDefinedCustomXmlParts(wmlPackage, customXmlPart.getItemId());
            new EventFinished(startEvent).publish();
        }
        new EventFinished(bindJobStartEvent).publish();
    }

    protected static void insertXMLData(CustomXmlPart customXmlDataStoragePart, Document xmlDocument) throws Docx4JException {
        customXmlDataStoragePart.setXML(xmlDocument);
    }

    protected static String findXPathStorageItemIdInContentControls(WordprocessingMLPackage wmlPackage) {
        FindContentControlsVisitor visitor = null;
        if (wmlPackage.getCustomXmlDataStorageParts() != null && !wmlPackage.getCustomXmlDataStorageParts().isEmpty()) {
            try {
                visitor = new FindContentControlsVisitor(wmlPackage.getCustomXmlDataStorageParts().keySet());
                TraversalUtil.visit(wmlPackage, false, visitor);
            }
            catch (FindContentControlsVisitor.BreakException breakException) {
                // empty catch block
            }
        }
        return visitor != null ? visitor.getdefinedStoreItemId() : null;
    }

    protected static void removeSDTs(WordprocessingMLPackage wmlPackage) throws Docx4JException {
        RemovalHandler removalHandler = new RemovalHandler();
        removalHandler.removeSDTs(wmlPackage);
    }

    protected static void removeDefinedCustomXmlParts(WordprocessingMLPackage wmlPackage, String itemId) {
        ArrayList<PartName> partsToRemove = new ArrayList<PartName>();
        RelationshipsPart relationshipsPart = wmlPackage.getMainDocumentPart().getRelationshipsPart();
        List<Relationship> relationshipsList = relationshipsPart != null && relationshipsPart.getRelationships() != null ? relationshipsPart.getRelationships().getRelationship() : null;
        Part part = null;
        if (relationshipsList != null) {
            for (Relationship relationship : relationshipsList) {
                if (!"http://schemas.openxmlformats.org/officeDocument/2006/relationships/customXml".equals(relationship.getType())) continue;
                part = relationshipsPart.getPart(relationship);
                if (itemId != null && itemId.equals(((CustomXmlPart)((Object)part)).getItemId())) {
                    partsToRemove.add(part.getPartName());
                    continue;
                }
                if (part instanceof XPathsPart) {
                    partsToRemove.add(part.getPartName());
                    continue;
                }
                if (part instanceof ConditionsPart) {
                    partsToRemove.add(part.getPartName());
                    continue;
                }
                log.warn("Keeping " + part.getPartName() + " of type " + part.getClass().getName());
            }
        }
        if (!partsToRemove.isEmpty()) {
            for (int i = 0; i < partsToRemove.size(); ++i) {
                relationshipsPart.removePart((PartName)partsToRemove.get(i));
            }
        }
    }

    public static WordprocessingMLPackage clone(WordprocessingMLPackage wmlPackage) throws Docx4JException {
        return (WordprocessingMLPackage)PartialDeepCopy.process(wmlPackage, null);
    }

    public static FOSettings createFOSettings() {
        return new FOSettings();
    }

    public static void toFO(FOSettings settings, OutputStream outputStream, int flags) throws Docx4JException {
        Exporter<FOSettings> exporter = Docx4J.getFOExporter(flags);
        exporter.export(settings, outputStream);
    }

    public static void toPDF(WordprocessingMLPackage wmlPackage, OutputStream outputStream) throws Docx4JException {
        StartEvent startEvent = new StartEvent(wmlPackage, WellKnownProcessSteps.PDF);
        startEvent.publish();
        if (Docx4J.pdfViaFO()) {
            FOSettings settings = Docx4J.createFOSettings();
            settings.setWmlPackage(wmlPackage);
            settings.setApacheFopMime(MIME_PDF);
            Docx4J.toFO(settings, outputStream, 0);
            new EventFinished(startEvent).publish();
        } else {
            String URL2 = Docx4jProperties.getProperty("com.plutext.converter.URL", "http://localhost:9016/v1/00000000-0000-0000-0000-000000000000/convert");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Docx4J.save(wmlPackage, baos);
            ConverterHttp converter = new ConverterHttp(URL2);
            try {
                converter.convert(baos.toByteArray(), Format.DOCX, Format.PDF, outputStream);
                baos.close();
            }
            catch (Exception e) {
                throw new Docx4JException(e.getMessage(), e);
            }
            finally {
                new EventFinished(startEvent).publish();
            }
        }
    }

    protected static Exporter<FOSettings> getFOExporter(int flags) throws Docx4JException {
        switch (flags) {
            case 2: {
                return Docx4J.FOExporterVisitorGetInstance();
            }
        }
        return Docx4J.FOExporterXsltGetInstance();
    }

    private static Exporter<FOSettings> FOExporterVisitorGetInstance() throws Docx4JException {
        try {
            Class<?> clazz = Class.forName("org.docx4j.convert.out.fo.FOExporterVisitor");
            Method method = clazz.getMethod("getInstance", null);
            return (Exporter)method.invoke(null, null);
        }
        catch (Exception e) {
            throw new Docx4JException("org.docx4j.convert.out.fo.FOExporterVisitor not found; if you want it, add docx4j-export-FO to your path.  Doing so will disable Plutext's PDF Converter./n" + e.getMessage(), e);
        }
    }

    private static Exporter<FOSettings> FOExporterXsltGetInstance() throws Docx4JException {
        try {
            Class<?> clazz = Class.forName("org.docx4j.convert.out.fo.FOExporterXslt");
            Method method = clazz.getMethod("getInstance", null);
            return (Exporter)method.invoke(null, null);
        }
        catch (Exception e) {
            throw new Docx4JException("org.docx4j.convert.out.fo.FOExporterXslt not found; if you want it, add docx4j-export-FO to your path.  /n" + e.getMessage(), e);
        }
    }

    public static HTMLSettings createHTMLSettings() {
        return new HTMLSettings();
    }

    public static void toHTML(HTMLSettings settings, OutputStream outputStream, int flags) throws Docx4JException {
        StartEvent startEvent = new StartEvent(settings.getWmlPackage(), WellKnownProcessSteps.HTML_OUT);
        startEvent.publish();
        Exporter<HTMLSettings> exporter = Docx4J.getHTMLExporter(flags);
        exporter.export(settings, outputStream);
        new EventFinished(startEvent).publish();
    }

    public static void toHTML(WordprocessingMLPackage wmlPackage, String imageDirPath, String imageTargetUri, OutputStream outputStream) throws Docx4JException {
        StartEvent startEvent = new StartEvent(wmlPackage, WellKnownProcessSteps.HTML_OUT);
        startEvent.publish();
        HTMLSettings settings = Docx4J.createHTMLSettings();
        settings.setWmlPackage(wmlPackage);
        if (imageDirPath != null) {
            settings.setImageDirPath(imageDirPath);
        }
        if (imageTargetUri != null) {
            settings.setImageTargetUri(imageTargetUri);
        }
        Docx4J.toHTML(settings, outputStream, 0);
        new EventFinished(startEvent).publish();
    }

    protected static Exporter<HTMLSettings> getHTMLExporter(int flags) {
        switch (flags) {
            case 2: {
                return HTMLExporterVisitor.getInstance();
            }
        }
        return HTMLExporterXslt.getInstance();
    }

    static {
        PART_TO_REMOVE_SCHEMA_TYPES = new TreeSet<String>();
        PART_TO_REMOVE_SCHEMA_TYPES.add(NS_CONDITIONS);
        PART_TO_REMOVE_SCHEMA_TYPES.add(NS_XPATHS);
        PART_TO_REMOVE_SCHEMA_TYPES.add(NS_QUESTIONS);
        PART_TO_REMOVE_SCHEMA_TYPES.add(NS_COMPONENTS);
    }

    protected static class FindContentControlsVisitor
    extends TraversalUtilVisitor<SdtElement> {
        protected Set<String> definedStoreItemIds = null;
        protected String storeItemId = null;

        public FindContentControlsVisitor(Set<String> definedStoreItemIds) {
            this.definedStoreItemIds = definedStoreItemIds;
        }

        @Override
        public void apply(SdtElement element) {
            String tmp;
            SdtPr sdtPr = element.getSdtPr();
            if (sdtPr.getDataBinding() != null && sdtPr.getDataBinding().getStoreItemID() != null && this.definedStoreItemIds.contains(tmp = sdtPr.getDataBinding().getStoreItemID().toLowerCase())) {
                this.storeItemId = tmp;
                throw new BreakException();
            }
        }

        public String getdefinedStoreItemId() {
            return this.storeItemId;
        }

        public static class BreakException
        extends RuntimeException {
        }
    }
}

