/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.datastorage;

import java.io.IOException;
import java.util.HashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.util.JAXBResult;
import javax.xml.transform.Result;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.jaxb.JaxbValidationEventHandler;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.openpackaging.parts.WordprocessingML.FooterPart;
import org.docx4j.openpackaging.parts.WordprocessingML.HeaderPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.utils.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class OpenDoPEIntegrityAfterBinding {
    private static Logger log = LoggerFactory.getLogger(OpenDoPEIntegrityAfterBinding.class);
    static Templates xslt;

    public static void log(String message) {
        log.info(message);
    }

    public void process(WordprocessingMLPackage wordMLPackage) throws Docx4JException {
        this.process(wordMLPackage.getMainDocumentPart());
        RelationshipsPart rp = wordMLPackage.getMainDocumentPart().getRelationshipsPart();
        for (Relationship r : rp.getRelationships().getRelationship()) {
            if (r.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/header")) {
                this.process((HeaderPart)rp.getPart(r));
                continue;
            }
            if (!r.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/footer")) continue;
            this.process((FooterPart)rp.getPart(r));
        }
    }

    private void process(JaxbXmlPart part) throws Docx4JException {
        block5: {
            log.info("/n Processing " + part.getPartName().getName());
            OpcPackage pkg = part.getPackage();
            Document doc = XmlUtils.marshaltoW3CDomDocument(part.getJaxbElement());
            JAXBContext jc = Context.jc;
            try {
                Unmarshaller u = jc.createUnmarshaller();
                JaxbValidationEventHandler eventHandler = new JaxbValidationEventHandler();
                u.setEventHandler((ValidationEventHandler)eventHandler);
                HashMap<String, Object> transformParameters = new HashMap<String, Object>();
                transformParameters.put("OpenDoPEIntegrityAfterBinding", this);
                try {
                    JAXBResult result = new JAXBResult(u);
                    XmlUtils.transform(doc, xslt, transformParameters, (Result)result);
                    part.setJaxbElement(result);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    log.error("Input in question:" + XmlUtils.w3CDomNodeToString(doc));
                    log.error("Now trying DOMResult..");
                    DOMResult result = new DOMResult();
                    XmlUtils.transform(doc, xslt, transformParameters, (Result)result);
                    if (log.isDebugEnabled()) {
                        Document docResult = (Document)result.getNode();
                        Object o = XmlUtils.unmarshal((Document)result.getNode());
                        part.setJaxbElement(o);
                        break block5;
                    }
                    Object o = XmlUtils.unmarshal((Document)result.getNode());
                    part.setJaxbElement(o);
                }
            }
            catch (Exception e) {
                throw new Docx4JException("Problems ensuring integrity", e);
            }
        }
    }

    static {
        try {
            StreamSource xsltSource = new StreamSource(ResourceUtils.getResource("org/docx4j/model/datastorage/OpenDoPEIntegrityAfterBinding.xslt"));
            xslt = XmlUtils.getTransformerTemplate(xsltSource);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
    }
}

