/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ei.node;

import com.google.common.base.Stopwatch;
import java.nio.file.Path;
import java.util.Map;
import java.util.UUID;
import org.qubership.atp.ei.node.CancellableExportImportTask;
import org.qubership.atp.ei.node.ImportExecutor;
import org.qubership.atp.ei.node.dto.ExportImportData;
import org.qubership.atp.ei.node.dto.RunNodeRequest;
import org.qubership.atp.ei.node.dto.ValidationResult;
import org.qubership.atp.ei.node.dto.validation.ValidationType;
import org.qubership.atp.ei.node.exceptions.ExportException;
import org.qubership.atp.ei.node.services.ExportImportFilesService;
import org.qubership.atp.ei.node.services.FileService;
import org.qubership.atp.ei.node.services.MetricsExportImportService;
import org.qubership.atp.ei.node.services.impl.NotifyService;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class ImportExecutorWrapper
implements CancellableExportImportTask,
ImportExecutor {
    private static final Logger log = LoggerFactory.getLogger(ImportExecutorWrapper.class);
    private final ValidationType validationType;
    private final RunNodeRequest request;
    private final Path defaultWorkDir;
    private final ImportExecutor executor;
    private final NotifyService notifyService;
    private final SecurityContext securityContext;
    private boolean isCancelled;
    private final ExportImportFilesService exportImportFilesService;
    private final FileService fileService;
    private Map<String, String> mdcContext;
    private final MetricsExportImportService metricsExportImportService;

    public ImportExecutorWrapper(RunNodeRequest request, Path defaultWorkDir, ValidationType validationType, ImportExecutor importExecutor, NotifyService notifyService, ExportImportFilesService exportImportFilesService, FileService fileService, MetricsExportImportService metricsExportImportService) {
        this.validationType = validationType;
        this.request = request;
        this.defaultWorkDir = defaultWorkDir;
        this.executor = importExecutor;
        this.notifyService = notifyService;
        this.securityContext = SecurityContextHolder.getContext();
        this.exportImportFilesService = exportImportFilesService;
        this.fileService = fileService;
        this.mdcContext = MDC.getCopyOfContextMap();
        this.metricsExportImportService = metricsExportImportService;
    }

    @Override
    public void importData(ExportImportData importData, Path workDir) throws Exception {
        log.info("Start import data for project {} and task {}", (Object)this.request.getProjectId(), (Object)this.request.getTaskId());
        try {
            this.executor.importData(importData, workDir);
            this.fileService.deletePath(workDir);
        }
        catch (Exception e) {
            log.error("Error occurred while importing data", (Throwable)e);
            throw e;
        }
        log.info("Finish import data for project {} and task {}", (Object)this.request.getProjectId(), (Object)this.request.getTaskId());
    }

    @Override
    public ValidationResult preValidateData(ExportImportData importData, Path workDir) throws Exception {
        log.info("Start validate data for project {} and task {}", (Object)this.request.getProjectId(), (Object)this.request.getTaskId());
        try {
            ValidationResult result = this.executor.preValidateData(importData, workDir);
            log.info("Finish Validate data for project {} and task {}", (Object)this.request.getProjectId(), (Object)this.request.getTaskId());
            return result;
        }
        catch (Exception e) {
            log.error("Error occurred while validate data", (Throwable)e);
            throw e;
        }
    }

    @Override
    public ValidationResult validateData(ExportImportData importData, Path workDir) throws Exception {
        log.info("Start validate data for project {} and task {}", (Object)this.request.getProjectId(), (Object)this.request.getTaskId());
        try {
            ValidationResult result = this.executor.validateData(importData, workDir);
            log.info("Finish Validate data for project {} and task {}", (Object)this.request.getProjectId(), (Object)this.request.getTaskId());
            return result;
        }
        catch (Exception e) {
            log.error("Error occurred while validate data", (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object call() throws Exception {
        log.debug("Export wrapper, mdcContext = {}", this.mdcContext);
        Stopwatch timer = Stopwatch.createStarted();
        this.metricsExportImportService.registerProcess(this.request.getProjectId().toString(), this.request.getProcessId(), "active.import.process.count");
        MdcUtils.setContextMap(this.mdcContext);
        SecurityContextHolder.setContext((SecurityContext)this.securityContext);
        try {
            Path pathToImportArchive = this.exportImportFilesService.downloadFileInDir(this.request.getFileDescriptor(), this.defaultWorkDir);
            this.fileService.unpackZipFile(pathToImportArchive, this.defaultWorkDir);
            this.fileService.deletePath(pathToImportArchive);
            if (this.validationType != null) {
                ExportImportData exportImportData = this.request.toExportImportData();
                ValidationResult validationResult = this.validationType == ValidationType.PRE_VALIDATE ? this.preValidateData(exportImportData, this.defaultWorkDir) : this.validateData(exportImportData, this.defaultWorkDir);
                if (validationResult == null) {
                    validationResult = new ValidationResult();
                }
                if (validationResult.getReplacementMap() == null) {
                    validationResult.setReplacementMap(exportImportData.getReplacementMap());
                } else {
                    validationResult.getReplacementMap().putAll(exportImportData.getReplacementMap());
                }
                log.info("Validation result {}", (Object)validationResult);
                this.notifyService.notifyAfterValidation(this.request, validationResult);
            } else {
                this.importData(this.request.toExportImportData(false), this.defaultWorkDir);
                this.notifyService.notifyImportFlow(this.request);
            }
        }
        catch (Exception e) {
            log.info("Exception during import", (Throwable)e);
            if (!this.isCancelled()) {
                this.notifyService.notifyImportFlow(e, this.request);
            }
        }
        finally {
            try {
                this.metricsExportImportService.addTimeMetric(this.request.getProjectId(), timer, "total.time.import.processes");
                this.metricsExportImportService.unregisterProcess(UUID.fromString(this.request.getProcessId()));
            }
            catch (Throwable e) {
                log.error("Unable unregister metric for processId {}", (Object)this.request.getProcessId(), (Object)e);
                throw new ExportException("Unable unregister metric for processId " + this.request.getProcessId());
            }
        }
        return null;
    }

    @Override
    public boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public void setCancelled() {
        this.isCancelled = true;
    }
}

