/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ei.node.config;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import org.apache.commons.lang.StringUtils;
import org.bson.UuidRepresentation;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.core.SimpleMongoClientDatabaseFactory;
import org.springframework.data.mongodb.core.convert.DbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultDbRefResolver;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;
import org.springframework.data.mongodb.gridfs.GridFsTemplate;

@Configuration
public class GridFsConfiguration {
    @Value(value="${ei.gridfs.host}")
    private String host;
    @Value(value="${ei.gridfs.port}")
    private String port;
    @Value(value="${ei.gridfs.database}")
    private String database;
    @Value(value="${ei.gridfs.user}")
    private String user;
    @Value(value="${ei.gridfs.password}")
    private String password;

    @Bean
    public GridFsProvider eiGridFsTemplate() throws ClassNotFoundException {
        if (StringUtils.isEmpty((String)this.host)) {
            return new GridFsProvider(null);
        }
        String mongoClientUri = "mongodb://" + this.user + ":" + this.password + "@" + this.host + ":" + Integer.parseInt(this.port) + "/?authSource=" + this.database;
        MongoClient mongoClient = MongoClients.create((MongoClientSettings)MongoClientSettings.builder().applyConnectionString(new ConnectionString(mongoClientUri)).uuidRepresentation(UuidRepresentation.JAVA_LEGACY).build());
        SimpleMongoClientDatabaseFactory factory = new SimpleMongoClientDatabaseFactory(mongoClient, this.database);
        DefaultDbRefResolver dbRefResolver = new DefaultDbRefResolver((MongoDatabaseFactory)factory);
        MongoMappingContext mappingContext = new MongoMappingContext();
        mappingContext.setSimpleTypeHolder(SimpleTypeHolder.DEFAULT);
        mappingContext.afterPropertiesSet();
        MappingMongoConverter mappingConverter = new MappingMongoConverter((DbRefResolver)dbRefResolver, (MappingContext)mappingContext);
        return new GridFsProvider(new GridFsTemplate((MongoDatabaseFactory)factory, (MongoConverter)mappingConverter));
    }

    public static class GridFsProvider {
        private final GridFsTemplate gridFsTemplate;

        public GridFsTemplate getTemplate() {
            return this.gridFsTemplate;
        }

        public GridFsTemplate getGridFsTemplate() {
            return this.gridFsTemplate;
        }

        public GridFsProvider(GridFsTemplate gridFsTemplate) {
            this.gridFsTemplate = gridFsTemplate;
        }
    }
}

