/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ei.node.controllers;

import java.util.UUID;
import org.qubership.atp.ei.node.dto.RunNodeRequest;
import org.qubership.atp.ei.node.services.ImportNodeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ei/api/v1/node/import"})
public class ImportNodeController {
    private static final Logger log = LoggerFactory.getLogger(ImportNodeController.class);
    private final ImportNodeService importService;

    @PostMapping(value={"/run"}, consumes={"application/json"})
    public ResponseEntity run(@RequestBody RunNodeRequest request) {
        this.importService.runImport(request);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/validate"}, consumes={"application/json"})
    public ResponseEntity validate(@RequestBody RunNodeRequest request) {
        this.importService.validateImport(request);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/prevalidate"}, consumes={"application/json"})
    public ResponseEntity prevalidate(@RequestBody RunNodeRequest request) {
        this.importService.preValidateImport(request);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/cancel"})
    public ResponseEntity cancel(@RequestParam(value="projectId") UUID projectId, @RequestParam(value="taskId") String taskId, @RequestParam(value="processId") String processId) {
        this.importService.cancel(projectId, taskId, processId);
        return ResponseEntity.ok().build();
    }

    public ImportNodeController(ImportNodeService importService) {
        this.importService = importService;
    }
}

