/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ei.node.services;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.std.CollectionDeserializer;
import com.fasterxml.jackson.databind.deser.std.StringDeserializer;
import com.fasterxml.jackson.databind.deser.std.UUIDDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ObjectLoaderFromDiskService {
    private static final Logger log = LoggerFactory.getLogger(ObjectLoaderFromDiskService.class);
    protected final ObjectMapper objectMapper;
    private Map<Class, KeyDeserializer> additionalKeyDeserializer = Maps.newHashMap();

    private Map<Class, KeyDeserializer> getAdditionalKeyDeserializer() {
        return this.additionalKeyDeserializer;
    }

    public void setAdditionalKeyDeserializer(Map<Class, KeyDeserializer> additionalKeyDeserializer) {
        this.additionalKeyDeserializer = additionalKeyDeserializer;
    }

    public ObjectLoaderFromDiskService() {
        this.objectMapper = new ObjectMapper();
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public <T> T loadObject(UUID id, Class<T> clazz, Path workDir) {
        log.debug("start loadObject(id: {}, clazz: {})", (Object)id, clazz);
        Path dirWithObjects = workDir.resolve(clazz.getSimpleName());
        Path res = this.findFileOnDisk(dirWithObjects, id);
        return this.loadFileAsObject(res, clazz);
    }

    public <T> T findObjectOnDisk(Path workDir, UUID id, Class<T> clazz) {
        log.debug("start findFileOnDisk(workDir: {}, id: {}, clazz: {})", new Object[]{workDir, id, clazz});
        Path dirWithObjects = workDir.resolve(clazz.getSimpleName());
        Path path = this.findFileOnDisk(dirWithObjects, id);
        return this.loadFileAsObject(path, clazz);
    }

    public Path findFileOnDisk(Path workDir, UUID id) {
        log.debug("start findFileOnDisk(workDir: {}, id: {})", (Object)workDir, (Object)id);
        String fileName = id.toString();
        Path res = null;
        try (Stream<Path> result = Files.find(workDir, 10, (path, basicFileAttributes) -> path.getFileName().toString().contains(fileName), new FileVisitOption[0]);){
            Optional<Path> file = result.findFirst();
            if (!file.isPresent()) {
                log.info("Cannot find file with id {}", (Object)fileName);
            } else {
                res = file.get();
            }
        }
        catch (IOException e) {
            log.error("Cannot read directory {}", (Object)workDir, (Object)e);
        }
        log.debug("end findFileOnDisk(.., ..): {}", res);
        return res;
    }

    public <T> T loadFileAsObject(Path file, Class<T> clazz) {
        return this.loadFileAsObjectWithReplacementMap(file, clazz, new HashMap<UUID, UUID>(), true, false);
    }

    public <T> T loadFileAsObjectWithReplacementMap(Path file, Class<T> clazz, Map<UUID, UUID> replacementMap) {
        return this.loadFileAsObjectWithReplacementMap(file, clazz, replacementMap, false, false);
    }

    public <T> T loadFileAsObjectWithReplacementMap(Path file, Class<T> clazz, Map<UUID, UUID> replacementMap, boolean checkStringForId) {
        return this.loadFileAsObjectWithReplacementMap(file, clazz, replacementMap, false, checkStringForId);
    }

    public <T> T loadFileAsObjectWithReplacementMap(Path file, Class<T> clazz, Map<UUID, UUID> replacementMap, boolean saveOriginalValue, boolean checkStringForId) {
        try {
            return this.loadFileAsObjectWithReplacementMap(file, clazz, replacementMap, saveOriginalValue, checkStringForId, false);
        }
        catch (Exception e) {
            log.error("Cannot read file {}. class {}", new Object[]{file, clazz, e});
            return null;
        }
    }

    public <T> T loadFileAsObjectWithReplacementMap(Path file, Class<T> clazz, Map<UUID, UUID> replacementMap, boolean saveOriginalValue, boolean checkStringForId, boolean throwException) throws Exception {
        Object result;
        block9: {
            log.debug("start loadFileAsObject(id: {}, clazz: {})", (Object)file, clazz);
            ObjectMapper localObjectMapper = this.objectMapper;
            if (MapUtils.isNotEmpty(replacementMap)) {
                localObjectMapper = new ObjectMapperWithReplacementMap(this.objectMapper, replacementMap, saveOriginalValue, checkStringForId, this.additionalKeyDeserializer);
            }
            result = null;
            try (InputStream in = Files.newInputStream(file, new OpenOption[0]);){
                result = localObjectMapper.readValue(in, clazz);
            }
            catch (Exception e) {
                log.error("Cannot read file {}. class {}", new Object[]{file, clazz, e});
                if (!throwException) break block9;
                throw e;
            }
        }
        log.debug("end (loadFileAsObject: {}, clazz: {})", (Object)file, clazz);
        return (T)result;
    }

    public <T> T loadFileAsObjectWithReplacementMapThrowException(Path file, Class<T> clazz, Map<UUID, UUID> replacementMap, boolean checkStringForId) throws Exception {
        return this.loadFileAsObjectWithReplacementMap(file, clazz, replacementMap, false, checkStringForId, true);
    }

    public Map<UUID, Path> getListOfObjects(Path workDir, Class clazz) {
        return this.getListOfObjects(workDir, clazz, (UUID)null);
    }

    public Map<UUID, Path> getListOfObjects(Path workDir, Class clazz, UUID parentId) {
        return this.getListOfObjects(workDir, clazz.getSimpleName(), parentId);
    }

    public Map<UUID, Path> getListOfObjects(Path workDir, String folderName) {
        return this.getListOfObjects(workDir, folderName, null);
    }

    public Map<UUID, Path> getListOfObjects(Path workDir, String folderName, UUID parentId) {
        Path dirWithObjects = workDir.resolve(folderName);
        if (parentId != null) {
            dirWithObjects = dirWithObjects.resolve(parentId.toString());
        }
        return this.getListOfObjectIdByFolder(dirWithObjects);
    }

    public Map<UUID, Path> getListOfObjects(Path workDir, Class clazz, List<UUID> parentIds) {
        log.debug("start getListOfObjects(workDir: {}, clazz: {}, parentIds: {})", new Object[]{workDir, clazz, parentIds});
        LinkedHashMap<UUID, Path> result = new LinkedHashMap<UUID, Path>();
        if (CollectionUtils.isNotEmpty(parentIds)) {
            result.putAll(parentIds.stream().flatMap(parentId -> this.getListOfObjects(workDir, clazz, (UUID)parentId).entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        } else {
            result.putAll(this.getListOfObjects(workDir, clazz));
        }
        log.debug("end getListOfObjects(workDir: {}, clazz: {}, parentIds: {}) return {}", new Object[]{workDir, clazz, parentIds, result});
        return result;
    }

    private Map<UUID, Path> getListOfObjectIdByFolder(Path dirWithObjects) {
        log.debug("start getListOfObjectIdByFolder(dirWithObjects: {})", (Object)dirWithObjects);
        LinkedHashMap<UUID, Path> res = new LinkedHashMap<UUID, Path>();
        try (Stream<Path> result = Files.find(dirWithObjects, 5, (path, basicFileAttributes) -> basicFileAttributes.isRegularFile(), new FileVisitOption[0]);){
            result.forEach(pathToFile -> {
                UUID objectId;
                log.debug("Path to file: {}", pathToFile);
                try {
                    objectId = UUID.fromString(pathToFile.getFileName().toString().split("\\.")[0]);
                }
                catch (IllegalArgumentException e) {
                    log.warn("Can't get uuid from filename.", (Throwable)e);
                    return;
                }
                res.put(objectId, (Path)pathToFile);
            });
        }
        catch (Exception e) {
            log.error("Cannot find dir {}", (Object)dirWithObjects, (Object)e);
        }
        log.debug("end getListOfObjectIdByFolder(): {}", res);
        return res;
    }

    private static class ObjectMapperWithReplacementMap
    extends ObjectMapper {
        public ObjectMapperWithReplacementMap(ObjectMapper src, final Map<UUID, UUID> replacementMap, final boolean saveOriginalValue, boolean checkStringForId, Map<Class, KeyDeserializer> additionalKeyDeserializer) {
            super(src);
            SimpleModule module = new SimpleModule(){

                public void setupModule(Module.SetupContext context) {
                    super.setupModule(context);
                    context.addBeanDeserializerModifier((BeanDeserializerModifier)new CustomizedBeanDeserializerModifier());
                }
            };
            if (!additionalKeyDeserializer.isEmpty()) {
                for (Class clazz : additionalKeyDeserializer.keySet()) {
                    module.addKeyDeserializer(clazz, additionalKeyDeserializer.get(clazz));
                }
            }
            final UUIDDeserializer uuidDeserializer = new UUIDDeserializer(){

                public UUID deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
                    UUID id = (UUID)super.deserialize(p, ctxt);
                    return replacementMap.getOrDefault(id, saveOriginalValue ? id : null);
                }
            };
            module.addDeserializer(UUID.class, (JsonDeserializer)uuidDeserializer);
            if (checkStringForId) {
                module.addDeserializer(String.class, (JsonDeserializer)new StringDeserializer(){

                    public String deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
                        Object id;
                        if (p.getValueAsString().length() == 36) {
                            try {
                                id = uuidDeserializer.deserialize(p, ctxt);
                            }
                            catch (Exception e) {
                                id = super.deserialize(p, ctxt);
                            }
                        } else {
                            id = super.deserialize(p, ctxt);
                        }
                        return id == null ? null : id.toString();
                    }
                });
            }
            this.registerModule((Module)module);
        }
    }

    private static class CustomizedBeanDeserializerModifier
    extends BeanDeserializerModifier {
        private CustomizedBeanDeserializerModifier() {
        }

        public JsonDeserializer<?> modifyCollectionDeserializer(DeserializationConfig config, CollectionType type, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
            if (deserializer instanceof CollectionDeserializer) {
                return new CustomizedCollectionDeserializer((CollectionDeserializer)deserializer);
            }
            return super.modifyCollectionDeserializer(config, type, beanDesc, deserializer);
        }
    }

    private static class CustomizedCollectionDeserializer
    extends CollectionDeserializer {
        private static final long serialVersionUID = 1L;

        public CustomizedCollectionDeserializer(CollectionDeserializer src) {
            super(src);
        }

        public Collection<Object> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            Collection col = super.deserialize(jp, ctxt);
            if (CollectionUtils.isNotEmpty((Collection)col)) {
                col.removeIf(Objects::isNull);
            }
            return col;
        }

        public CollectionDeserializer createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
            return new CustomizedCollectionDeserializer(super.createContextual(ctxt, property));
        }
    }
}

