/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ei.node.services.impl;

import java.nio.file.Path;
import java.util.Map;
import java.util.UUID;
import org.qubership.atp.ei.node.ImportExecutor;
import org.qubership.atp.ei.node.ImportExecutorWrapper;
import org.qubership.atp.ei.node.dto.RunNodeRequest;
import org.qubership.atp.ei.node.dto.validation.ValidationType;
import org.qubership.atp.ei.node.exceptions.ExportException;
import org.qubership.atp.ei.node.services.ExportImportFilesService;
import org.qubership.atp.ei.node.services.FileService;
import org.qubership.atp.ei.node.services.ImportNodeService;
import org.qubership.atp.ei.node.services.MetricsExportImportService;
import org.qubership.atp.ei.node.services.impl.NotifyService;
import org.qubership.atp.ei.node.services.impl.TasksService;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class ImportNodeServiceImpl
implements ImportNodeService {
    private static final Logger log = LoggerFactory.getLogger(ImportNodeServiceImpl.class);
    private final ImportExecutor importExecutor;
    private final TasksService tasksService;
    private final NotifyService notifyService;
    private final ThreadPoolTaskExecutor threadPoolTaskExecutor;
    private final ExportImportFilesService exportImportFilesService;
    private final FileService fileService;
    private Map<String, String> mdcContext;
    private final MetricsExportImportService metricsExportImportService;

    @Autowired
    public ImportNodeServiceImpl(@Qualifier(value="atpImportThreadExecutor") ThreadPoolTaskExecutor threadPoolTaskExecutor, ImportExecutor importExecutor, TasksService tasksService, NotifyService notifyService, ExportImportFilesService exportImportFilesService, FileService fileService, MetricsExportImportService metricsExportImportService) {
        this.threadPoolTaskExecutor = threadPoolTaskExecutor;
        this.importExecutor = importExecutor;
        this.tasksService = tasksService;
        this.notifyService = notifyService;
        this.exportImportFilesService = exportImportFilesService;
        this.fileService = fileService;
        this.mdcContext = MDC.getCopyOfContextMap();
        this.metricsExportImportService = metricsExportImportService;
    }

    @Override
    public void validateImport(RunNodeRequest request) {
        log.info("Validate import request for project {} and task {}", (Object)request.getProjectId(), (Object)request.getTaskId());
        try {
            Path importDirectory = this.preparePathForValidation(request);
            ImportExecutorWrapper executor = new ImportExecutorWrapper(request, importDirectory, ValidationType.VALIDATE, this.importExecutor, this.notifyService, this.exportImportFilesService, this.fileService, this.metricsExportImportService);
            this.tasksService.submitTask(request.getTaskId(), executor, this.threadPoolTaskExecutor);
        }
        catch (Exception e) {
            String msg = "Error while start validation";
            log.error(msg, (Throwable)e);
            ExportException.throwException(msg, e);
        }
    }

    @Override
    public void preValidateImport(RunNodeRequest request) {
        log.info("Validate import request for project {} and task {}", (Object)request.getProjectId(), (Object)request.getTaskId());
        try {
            Path importDirectory = this.preparePathForValidation(request);
            ImportExecutorWrapper executor = new ImportExecutorWrapper(request, importDirectory, ValidationType.PRE_VALIDATE, this.importExecutor, this.notifyService, this.exportImportFilesService, this.fileService, this.metricsExportImportService);
            this.tasksService.submitTask(request.getTaskId(), executor, this.threadPoolTaskExecutor);
        }
        catch (Exception e) {
            String msg = "Error while start validation";
            log.error(msg, (Throwable)e);
            ExportException.throwException(msg, e);
        }
    }

    private Path preparePathForValidation(RunNodeRequest request) throws ExportException {
        Path importDirectory = this.fileService.getFolderPath(request.getProjectId(), request.getProcessId(), "import");
        this.fileService.deletePath(importDirectory);
        this.fileService.createDirectory(importDirectory);
        return importDirectory;
    }

    @Override
    public void cancel(UUID projectId, String taskId, String processId) {
        log.debug("Export wrapper, mdcContext = {}", this.mdcContext);
        MdcUtils.setContextMap(this.mdcContext);
        log.info("Cancel Import request for project {} and task {}", (Object)projectId, (Object)taskId);
        this.tasksService.cancelTask(taskId);
        this.fileService.deleteFolder(projectId, processId, "import");
    }

    @Override
    public void runImport(RunNodeRequest request) {
        log.info("Run import request for project {} and task {}", (Object)request.getProjectId(), (Object)request.getTaskId());
        try {
            Path importDirectory = this.preparePathForValidation(request);
            ImportExecutorWrapper executor = new ImportExecutorWrapper(request, importDirectory, null, this.importExecutor, this.notifyService, this.exportImportFilesService, this.fileService, this.metricsExportImportService);
            this.tasksService.submitTask(request.getTaskId(), executor, this.threadPoolTaskExecutor);
        }
        catch (Exception e) {
            String msg = "Error while start import";
            log.error(msg, (Throwable)e);
            ExportException.throwException(msg, e);
        }
    }
}

