/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.configuration;

import java.io.IOException;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.resource.PathResourceResolver;
import org.springframework.web.servlet.resource.ResourceResolver;

@Configuration
public class AtpWebConfig
implements WebMvcConfigurer {
    static final String APP_PROPERTIES = "application.properties";
    @Value(value="${spring.resources.static-locations}")
    private String webLocation;
    @Value(value="${atp-tdm.web.root-page}")
    private String rootPage;

    @ConfigurationProperties
    @Bean(name={"application.properties"})
    public Properties getProperties() {
        return new Properties();
    }

    @Bean
    public static PropertySourcesPlaceholderConfigurer propertyConfigInDev() {
        return new PropertySourcesPlaceholderConfigurer();
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/**/*"}).addResourceLocations(new String[]{this.webLocation}).resourceChain(true).addResolver((ResourceResolver)new PathResourceResolver(){

            protected Resource getResource(@Nonnull String resourcePath, Resource location) throws IOException {
                Resource requestedResource = location.createRelative(resourcePath);
                if (requestedResource.exists() && requestedResource.isReadable()) {
                    return requestedResource;
                }
                return new FileSystemResource(AtpWebConfig.this.rootPage);
            }
        });
        registry.addResourceHandler(new String[]{"/swagger-ui/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/springfox-swagger-ui/"});
    }

    public void addViewControllers(ViewControllerRegistry registry) {
        registry.addViewController("/notFound").setViewName("forward:/index.html");
        registry.addViewController("/").setViewName("forward:/index.html");
    }
}

