/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.configuration;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DbConfiguration {
    @Bean
    public DataSource dataSource(@Value(value="${jdbc.Url}") String url, @Value(value="${jdbc.User}") String user, @Value(value="${jdbc.Password}") String password, @Value(value="${jdbc.MinIdle:1}") int minIdle, @Value(value="${jdbc.MaxPoolSize:4}") int maxPoolSize, @Value(value="${jdbc.Debug:false}") boolean debug) {
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl(url);
        config.setUsername(user);
        config.setPassword(password);
        config.addDataSourceProperty("cachePrepStmts", (Object)"true");
        config.addDataSourceProperty("prepStmtCacheSize", (Object)"250");
        config.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)"2048");
        config.setMinimumIdle(minIdle);
        config.setMaximumPoolSize(maxPoolSize);
        config.setRegisterMbeans(debug);
        return new HikariDataSource(config);
    }
}

