/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.controllers;

import com.google.gson.Gson;
import io.swagger.v3.oas.annotations.Operation;
import java.text.ParseException;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.atp.tdm.model.cleanup.CleanupResults;
import org.qubership.atp.tdm.model.cleanup.CleanupSettings;
import org.qubership.atp.tdm.service.CleanupService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/tdm/cleanup"})
@RestController
public class DataCleanupController {
    private final CleanupService cleanupService;

    @Autowired
    public DataCleanupController(@Nonnull CleanupService cleanupService) {
        this.cleanupService = cleanupService;
    }

    @Operation(description="Get cleanup configuration for specified dataset / table ID.")
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.tdm.utils.UsersManagementEntities).TEST_DATA.getName(),@catalogRepository.findAllByCleanupConfigId(#id).get(0).getProjectId(), 'READ')")
    @AuditAction(auditAction="Get cleanup configuration by id {{#id}}")
    @GetMapping(path={"/config/{id}"})
    public ResponseEntity<CleanupSettings> getCleanupConfig(@PathVariable UUID id) {
        return ResponseEntity.ok().contentType(MediaType.APPLICATION_JSON).body((Object)this.cleanupService.getCleanupSettings(id));
    }

    @Operation(description="Save / update data cleanup settings.")
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.tdm.utils.UsersManagementEntities).TEST_DATA.getName(),@catalogRepository.findByTableName(#cleanupConfig.tableName).getProjectId(), 'CREATE')")
    @AuditAction(auditAction="Save / update data cleanup settings. Table {{#cleanupConfig.tableName}}")
    @PostMapping(value={"/config"})
    public CleanupSettings saveCleanupConfig(@RequestBody CleanupSettings cleanupConfig) throws Exception {
        return this.cleanupService.saveCleanupConfig(cleanupConfig);
    }

    @Operation(description="Force run data cleanup.")
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.tdm.utils.UsersManagementEntities).TEST_DATA.getName(),@catalogRepository.findByTableName(#cleanupConfig.tableName).getProjectId(), 'CREATE')")
    @AuditAction(auditAction="Force run data cleanup. Table {{#cleanupConfig.tableName}}")
    @PostMapping(value={"/run"})
    public List<CleanupResults> runDataCleanup(@RequestBody CleanupSettings cleanupConfig) throws Exception {
        return this.cleanupService.runCleanup(cleanupConfig);
    }

    @Operation(description="Get next run's date / time details.")
    @AuditAction(auditAction="Get next run's date. cron {{#cronExpression}}")
    @GetMapping(value={"/next/run"})
    public ResponseEntity<String> getNextScheduledRun(@RequestParam(value="cronExpression") String cronExpression) throws ParseException {
        return ResponseEntity.ok((Object)new Gson().toJson((Object)this.cleanupService.getNextScheduledRun(cronExpression)));
    }

    @Operation(description="Old update.")
    @AuditAction(auditAction="Old update.")
    @GetMapping(path={"/fill/cleanup/type"})
    public void fillCleanupTypeColumn() {
        this.cleanupService.fillCleanupTypeColumn();
    }
}

