/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.controllers;

import com.google.gson.Gson;
import io.swagger.v3.oas.annotations.Operation;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.qubership.atp.tdm.mdc.MdcField;
import org.qubership.atp.tdm.model.ChangeTitleRequest;
import org.qubership.atp.tdm.model.ColumnValues;
import org.qubership.atp.tdm.model.EnvsList;
import org.qubership.atp.tdm.model.ImportTestDataStatistic;
import org.qubership.atp.tdm.model.TestDataRequest;
import org.qubership.atp.tdm.model.TestDataTableCatalog;
import org.qubership.atp.tdm.model.TestDataTableUpdateByQuery;
import org.qubership.atp.tdm.model.ei.TdmDataToExport;
import org.qubership.atp.tdm.model.rest.ResponseMessage;
import org.qubership.atp.tdm.model.rest.ResponseType;
import org.qubership.atp.tdm.model.table.TableColumnValues;
import org.qubership.atp.tdm.model.table.TestDataFlagsTable;
import org.qubership.atp.tdm.model.table.TestDataTable;
import org.qubership.atp.tdm.service.TestDataService;
import org.qubership.atp.tdm.service.impl.MetricService;
import org.qubership.atp.tdm.utils.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RequestMapping(value={"/api/tdm"})
@RestController
public class TestDataController {
    private static final Logger log = LoggerFactory.getLogger(TestDataController.class);
    private final TestDataService testDataService;
    private final MetricService metricService;

    @Autowired
    public TestDataController(@Nonnull TestDataService testDataService, @Nonnull MetricService metricService) {
        this.testDataService = testDataService;
        this.metricService = metricService;
    }

    @Operation(description="Get test data tables catalog.")
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.tdm.utils.UsersManagementEntities).TEST_DATA.getName(),#projectId, 'READ')")
    @AuditAction(auditAction="Get test data tables catalog. ProjectId {{#projectId}}")
    @GetMapping(value={"/tables/catalog"})
    public List<TestDataTableCatalog> getTestDataTablesCatalog(@RequestParam UUID projectId, @RequestParam(required=false) UUID systemId) {
        return this.testDataService.getTestDataTablesCatalog(projectId, systemId);
    }

    @Operation(description="Get tables under project.")
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.tdm.utils.UsersManagementEntities).TEST_DATA.getName(),#projectId, 'READ')")
    @AuditAction(auditAction="Get tables under projectId {{#projectId}}")
    @GetMapping(value={"/tables/list"})
    public TdmDataToExport getTestDataTablesList(@RequestParam UUID projectId) {
        return this.testDataService.tablesToExport(projectId);
    }

    @Operation(description="Get tables id and name under project and environment.")
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.tdm.utils.UsersManagementEntities).TEST_DATA.getName(),#projectId, 'READ')")
    @AuditAction(auditAction="Get tables id and name under project {{#projectId}} and environment {{#envId}}")
    @GetMapping(value={"/environment/tables/list"})
    public Map<String, String> getTestDataTablesListByEnvironment(@RequestParam UUID projectId, @RequestParam UUID envId) {
        MdcUtils.put((String)MdcField.ENVIRONMENT_ID.toString(), (UUID)envId);
        return this.testDataService.tablesToExportByEnvironment(projectId, envId);
    }

    @Operation(description="Import excel to TDM.")
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.tdm.utils.UsersManagementEntities).TEST_DATA.getName(),#projectId, 'CREATE')")
    @AuditAction(auditAction="Import excel to TDM. ProjectId {{#projectId}}, TableTitle {{#tableTitle}}")
    @PostMapping(value={"/import/excel"})
    public List<ImportTestDataStatistic> importExcelTestData(@RequestParam UUID projectId, @RequestParam(required=false) UUID environmentId, @RequestParam(required=false) UUID systemId, @RequestParam String tableTitle, @RequestParam Boolean runSqlScript, @RequestParam MultipartFile file) {
        this.metricService.incrementInsertAction(projectId);
        return this.testDataService.importExcelTestData(projectId, environmentId, systemId, tableTitle, runSqlScript, file);
    }

    @Operation(description="Import sql to TDM.")
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.tdm.utils.UsersManagementEntities).TEST_DATA.getName(),#projectId, 'CREATE')")
    @AuditAction(auditAction="Import sql to TDM. ProjectId {{#projectId}}, TableTitle {{#tableTitle}}")
    @PostMapping(value={"/import/sql"})
    public List<ImportTestDataStatistic> importSqlTestData(@RequestParam UUID projectId, @RequestParam List<UUID> environmentsIds, @RequestParam String systemName, @RequestParam String tableTitle, @RequestParam String query, @RequestParam Integer queryTimeout) {
        this.metricService.incrementInsertAction(projectId);
        return this.testDataService.importSqlTestData(projectId, environmentsIds, systemName, tableTitle, query, queryTimeout);
    }

    @Operation(description="Get test data table.")
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.tdm.utils.UsersManagementEntities).TEST_DATA.getName(),@catalogRepository.findByTableName(#testDataRequest.tableName).getProjectId(), 'READ')")
    @AuditAction(auditAction="Get test data table {{#testDataRequest.tableName}}")
    @PostMapping(value={"/table"})
    public TestDataTable getTestData(@RequestBody TestDataRequest testDataRequest) {
        this.metricService.incrementGetAction(MDC.get((String)MdcField.PROJECT_ID.toString()));
        return this.testDataService.getTestData(testDataRequest.getTableName(), testDataRequest.getOffset(), testDataRequest.getLimit(), testDataRequest.getFilters(), testDataRequest.getDataTableOrder(), testDataRequest.isOccupied());
    }

    @Operation(description="Occupy test data.")
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.tdm.utils.UsersManagementEntities).TEST_DATA.getName(),@catalogRepository.findByTableName(#tableName).getProjectId(), 'UPDATE')")
    @AuditAction(auditAction="Occupy test data. Table Name {{#tableName}}")
    @PutMapping(value={"/occupy"})
    public void occupyTestData(@RequestParam String tableName, @RequestParam String occupiedBy, @RequestBody List<UUID> rows) {
        this.metricService.incrementOccupyAction(MDC.get((String)MdcField.PROJECT_ID.toString()));
        this.testDataService.occupyTestData(tableName, occupiedBy, rows);
    }

    @Operation(description="Release test data.")
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.tdm.utils.UsersManagementEntities).TEST_DATA.getName(),@catalogRepository.findByTableName(#tableName).getProjectId(), 'UPDATE')")
    @AuditAction(auditAction="Release test data. Table Name {{#tableName}}")
    @PutMapping(value={"/release"})
    public void releaseTestData(@RequestParam String tableName, @RequestBody List<UUID> rows) {
        this.metricService.incrementReleaseAction(MDC.get((String)MdcField.PROJECT_ID.toString()));
        this.testDataService.releaseTestData(tableName, rows);
    }

    @Operation(description="Delete selected rows from table.")
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.tdm.utils.UsersManagementEntities).TEST_DATA.getName(),@catalogRepository.findByTableName(#tableName).getProjectId(), 'UPDATE')")
    @AuditAction(auditAction="Delete selected rows from table {{#tableName}}")
    @PutMapping(value={"/delete/rows"})
    public void deleteTestDataTableRows(@RequestParam String tableName, @RequestBody List<UUID> rows) {
        this.metricService.incrementDeleteAction(MDC.get((String)MdcField.PROJECT_ID.toString()));
        this.testDataService.deleteTestDataTableRows(tableName, rows);
    }

    @Operation(description="Drop selected table.")
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.tdm.utils.UsersManagementEntities).TEST_DATA.getName(),@catalogRepository.findByTableName(#tableName).getProjectId(), 'DELETE')")
    @AuditAction(auditAction="Drop selected table {{#tableName}}")
    @DeleteMapping(value={"/table"})
    public void deleteTestData(@RequestParam String tableName) {
        this.metricService.incrementDeleteAction(MDC.get((String)MdcField.PROJECT_ID.toString()));
        this.testDataService.deleteTestData(tableName);
    }

    @Operation(description="Truncate data in table.")
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.tdm.utils.UsersManagementEntities).TEST_DATA.getName(),#projectId, 'DELETE')")
    @AuditAction(auditAction="Truncate data in table {{#tableName}} in projectId {{#projectId}}")
    @DeleteMapping(value={"/truncate/table"})
    public ResponseMessage truncateDataInTable(@RequestParam String tableName, @RequestParam UUID projectId, @RequestParam(required=false) UUID systemId) {
        this.metricService.incrementDeleteAction(projectId.toString());
        this.testDataService.truncateDataInTable(tableName, projectId, systemId);
        return new ResponseMessage(ResponseType.SUCCESS, String.format("Data has been cleaned in table with tableName = \"%s\".", tableName));
    }

    @Operation(description="Download table as excel file.")
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.tdm.utils.UsersManagementEntities).TEST_DATA.getName(),@catalogRepository.findByTableName(#tableName).getProjectId(), 'READ')")
    @AuditAction(auditAction="Download table {{#tableName}} as excel file.")
    @GetMapping(path={"/download/excel"})
    public ResponseEntity<InputStreamResource> getTestDataTableAsExcelFile(@RequestParam String tableName) throws IOException {
        this.metricService.incrementGetAction(MDC.get((String)MdcField.PROJECT_ID.toString()));
        File testDataTableAsExcelFile = this.testDataService.getTestDataTableAsExcelFile(tableName);
        return HttpUtils.buildFileResponseEntity(testDataTableAsExcelFile, "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
    }

    @Operation(description="Download table as csv file.")
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.tdm.utils.UsersManagementEntities).TEST_DATA.getName(),@catalogRepository.findByTableName(#tableName).getProjectId(), 'READ')")
    @AuditAction(auditAction="Download table {{#tableName}} as csv file.")
    @GetMapping(path={"/download/csv"})
    public ResponseEntity<InputStreamResource> getTestDataTableAsCsvFile(@RequestParam String tableName) throws IOException {
        this.metricService.incrementGetAction(MDC.get((String)MdcField.PROJECT_ID.toString()));
        File testDataTableAsCsvFile = this.testDataService.getTestDataTableAsCsvFile(tableName);
        return HttpUtils.buildFileResponseEntity(testDataTableAsCsvFile, "text/csv");
    }

    @Operation(description="Old update.")
    @AuditAction(auditAction="Old update.")
    @GetMapping(path={"/fix/occupied/by/column"})
    public void alterOccupiedByColumn() {
        this.testDataService.alterOccupiedByColumn();
    }

    @Operation(description="Get preview for linker.")
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.tdm.utils.UsersManagementEntities).TEST_DATA.getName(),#projectId, 'CREATE')")
    @AuditAction(auditAction="Get preview for linker. ProjectId {{#projectId}}, TableName {{#tableName}}")
    @PostMapping(path={"/link/preview"})
    public ResponseEntity<String> getPreviewLink(@RequestParam UUID projectId, @RequestParam(required=false) UUID systemId, @RequestParam String columnName, @RequestParam(required=false) String tableName, @RequestParam boolean pickUpFullLinkFromTableCell, @RequestBody(required=false) String endpoint) {
        String link = this.testDataService.getPreviewLink(projectId, systemId, endpoint, columnName, tableName, pickUpFullLinkFromTableCell);
        return ResponseEntity.ok((Object)new Gson().toJson((Object)link));
    }

    @Operation(description="Setup links.")
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.tdm.utils.UsersManagementEntities).TEST_DATA.getName(),#projectId, 'CREATE')")
    @AuditAction(auditAction="Setup links. ProjectId {{#projectId}}, TableName {{#tableName}}")
    @PostMapping(path={"/link/setup"})
    public void setupColumnLinks(@RequestParam Boolean isAll, @RequestParam UUID projectId, @RequestParam(required=false) UUID systemId, @RequestParam(required=false) String tableName, @RequestParam String columnName, @RequestParam Boolean validateUnoccupiedResources, @RequestParam boolean pickUpFullLinkFromTableCell, @RequestBody(required=false) String endpoint) {
        this.testDataService.setupColumnLinks(isAll, projectId, systemId, tableName, columnName, endpoint, validateUnoccupiedResources, pickUpFullLinkFromTableCell);
    }

    @Operation(description="Check flag 'is unoccupied validation'.")
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.tdm.utils.UsersManagementEntities).TEST_DATA.getName(),@catalogRepository.findByTableName(#tableName).getProjectId(), 'READ')")
    @AuditAction(auditAction="Check flag: is unoccupied validation for table {{#tableName}}.")
    @GetMapping(value={"/validation/unoccupied"})
    public TestDataFlagsTable isUnoccupiedValidation(@RequestParam(value="tableName") String tableName) {
        return this.testDataService.getUnoccupiedValidationFlagStatus(tableName);
    }

    @Operation(description="Returns a list of environment IDs that have tables with the requested table title for the specified project.")
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.tdm.utils.UsersManagementEntities).TEST_DATA.getName(),#projectId, 'READ')")
    @AuditAction(auditAction="Get Table Environments by projectId {{#projectId}} and tableTitle {{#tableTitle}}")
    @GetMapping(path={"/table/environments"})
    public EnvsList getTableEnvironments(@RequestParam(value="projectId") UUID projectId, @RequestParam(value="tableTitle") String tableTitle) {
        return this.testDataService.getTableEnvironments(projectId, tableTitle);
    }

    @Operation(description="Evaluate query.")
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.tdm.utils.UsersManagementEntities).TEST_DATA.getName(),@catalogRepository.findByTableName(#tableName).getProjectId(), 'UPDATE')")
    @AuditAction(auditAction="Evaluate Query for table {{#tableName}}")
    @PutMapping(value={"/evaluate/query"})
    public Map<String, String> evaluateQuery(@RequestParam(value="tableName") String tableName, @RequestBody String query) {
        this.metricService.incrementUpdateAction(MDC.get((String)MdcField.PROJECT_ID.toString()));
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("query", this.testDataService.evaluateQuery(tableName, query));
        return result;
    }

    @Operation(description="Get column distinct values.")
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.tdm.utils.UsersManagementEntities).TEST_DATA.getName(),@catalogRepository.findByTableName(#tableName).getProjectId(), 'READ')")
    @AuditAction(auditAction="Get column distinct values. TableName {{#tableName}}")
    @GetMapping(path={"/table/column/distinct/values"})
    public ColumnValues getColumnDistinctValues(@RequestParam(value="tableName") String tableName, @RequestParam(value="columnName") String columnName, @RequestParam(value="occupied") Boolean occupied) {
        return this.testDataService.getColumnDistinctValues(tableName, columnName, occupied);
    }

    @Operation(description="Get row value.")
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.tdm.utils.UsersManagementEntities).TEST_DATA.getName(),#projectId, 'READ')")
    @AuditAction(auditAction="Get row value. projectId {{#projectId}}, tableTitle {{#tableTitle}}")
    @GetMapping(path={"/table/row"})
    public Map<String, Object> getTableRow(@RequestParam UUID projectId, @RequestParam(required=false) UUID systemId, @RequestParam String tableTitle, @RequestParam String columnName, @RequestParam String searchValue, @RequestParam(required=false) boolean occupied) {
        return this.testDataService.getTableRow(projectId, systemId, tableTitle, columnName, searchValue, occupied);
    }

    @Operation(description="Changes table title.")
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.tdm.utils.UsersManagementEntities).TEST_DATA.getName(),@catalogRepository.findByTableName(#changeTitleRequest.tableName).getProjectId(), 'UPDATE')")
    @AuditAction(auditAction="Changes table title. tableTitle{{#changeTitleRequest.tableTitle}} tableName{{#changeTitleRequest.tableName}}")
    @PutMapping(value={"/change/title"})
    public boolean changeTestDataTitle(@RequestBody ChangeTitleRequest changeTitleRequest) {
        return this.testDataService.changeTestDataTitle(changeTitleRequest.getTableName(), changeTitleRequest.getTableTitle());
    }

    @Operation(description="Update existing table by sql.")
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.tdm.utils.UsersManagementEntities).TEST_DATA.getName(),#updateByQuery.projectId, 'UPDATE')")
    @AuditAction(auditAction="Update existing table {{#tableName}}, projectId {{#projectId}} by sql.")
    @PostMapping(value={"/update/sql"})
    public ImportTestDataStatistic updateTableBySql(@RequestBody TestDataTableUpdateByQuery updateByQuery) {
        this.metricService.incrementUpdateAction(updateByQuery.getProjectId().toString());
        return this.testDataService.updateTestDataBySql(updateByQuery.getProjectId(), updateByQuery.getEnvironmentId(), updateByQuery.getSystemId(), updateByQuery.getTableName(), updateByQuery.getQuery(), updateByQuery.getQueryTimeout());
    }

    @Operation(description="Old update.")
    @AuditAction(auditAction="Old update.")
    @GetMapping(path={"/alter/created/when"})
    public void alterCreatedWhenColumn() {
        this.testDataService.alterCreatedWhenColumn();
    }

    @Operation(description="Old update.")
    @AuditAction(auditAction="Old update.")
    @GetMapping(path={"/fill/envId"})
    public void fillEnvIdColumn() {
        this.testDataService.fillEnvIdColumn();
    }

    @Operation(description="Old update.")
    @AuditAction(auditAction="Old update.")
    @GetMapping(path={"/alter/occupy/statistic"})
    public void alterOccupyStatistic() {
        this.testDataService.alterOccupyStatistic();
    }

    @Operation(description="Resolve discrepancy TestDataFlagsTable and TestDataTableCatalog.")
    @AuditAction(auditAction="Resolve discrepancy TestDataFlagsTable and TestDataTableCatalog.")
    @GetMapping(path={"/resolve/discrepancy/testDataFlagsTableAndTestDataTableCatalog"})
    public void resolveDiscrepancyTestDataFlagsTableAndTestDataTableCatalog() {
        this.testDataService.resolveDiscrepancyTestDataFlagsTableAndTestDataTableCatalog();
    }

    @Operation(description="Get all distinct values by system_id and column_name")
    @GetMapping(value={"/data/available/recalculate"})
    public List<TableColumnValues> getDistinctColumnValues(@RequestParam UUID systemId, @RequestParam String columnName, @RequestParam UUID environmentId) {
        return this.testDataService.getDistinctTablesColumnValues(systemId, environmentId, columnName);
    }
}

