/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.controllers;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.annotation.Nonnull;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.atp.tdm.model.ImportSqlTestDataRequest;
import org.qubership.atp.tdm.model.ImportTestDataStatistic;
import org.qubership.atp.tdm.service.TestDataService;
import org.qubership.atp.tdm.service.impl.MetricService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/tdm/v2"})
@RestController
@Tag(name="test-data-controller-v2", description="Test Data Controller V2")
public class TestDataControllerV2 {
    private static final Logger log = LoggerFactory.getLogger(TestDataControllerV2.class);
    private final TestDataService testDataService;
    private final MetricService metricService;

    @Autowired
    public TestDataControllerV2(@Nonnull TestDataService testDataService, @Nonnull MetricService metricService) {
        this.testDataService = testDataService;
        this.metricService = metricService;
    }

    @Operation(description="Import sql to TDM v2 - with request body.")
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.tdm.utils.UsersManagementEntities).TEST_DATA.getName(),#request.projectId, 'CREATE')")
    @AuditAction(auditAction="Import sql to TDM v2. ProjectId {{#request.projectId}}, TableTitle {{#request.tableTitle}}")
    @PostMapping(value={"/import/sql"})
    public List<ImportTestDataStatistic> importSqlTestData(@RequestBody ImportSqlTestDataRequest request) {
        this.metricService.incrementInsertAction(request.getProjectId());
        return this.testDataService.importSqlTestData(request.getProjectId(), request.getEnvironmentsIds(), request.getSystemName(), request.getTableTitle(), request.getQuery(), request.getQueryTimeout());
    }
}

