/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.controllers.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.qubership.atp.tdm.controllers.api.dto.cleanup.CleanupResultsDto;
import org.qubership.atp.tdm.controllers.api.dto.cleanup.TestDataCleanupConfigDto;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
@Tag(name="DataCleanupController", description="Data Cleanup Controller")
public interface DataCleanupControllerApi {
    @Operation(operationId="fillCleanupTypeColumn", summary="Old update.", tags={"data-cleanup-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/tdm/cleanup/fill/cleanup/type"})
    public ResponseEntity<Void> fillCleanupTypeColumn();

    @Operation(operationId="getCleanupConfig", summary="Get cleanup configuration for specified dataset / table ID.", tags={"data-cleanup-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestDataCleanupConfigDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/tdm/cleanup/config/{id}"}, produces={"application/json"})
    public ResponseEntity<TestDataCleanupConfigDto> getCleanupConfig(@Parameter(name="id", description="id", required=true) @PathVariable(value="id") UUID var1);

    @Operation(operationId="getNextScheduledRun", summary="Get next run's date / time details.", tags={"data-cleanup-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/tdm/cleanup/next/run"}, produces={"application/json"})
    public ResponseEntity<String> getNextScheduledRun(@NotNull @Parameter(name="cronExpression", description="cronExpression", required=true) @Valid @RequestParam(value="cronExpression", required=true) String var1);

    @Operation(operationId="runDataCleanup", summary="Force run data cleanup.", tags={"data-cleanup-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=CleanupResultsDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/tdm/cleanup/run"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<CleanupResultsDto> runDataCleanup(@NotNull @Parameter(name="tableName", description="tableName", required=true) @Valid @RequestParam(value="tableName", required=true) String var1, @Parameter(name="TestDataCleanupConfigDto", description="") @Valid @RequestBody(required=false) TestDataCleanupConfigDto var2);

    @Operation(operationId="saveCleanupConfig", summary="Save / update data cleanup settings.", tags={"data-cleanup-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestDataCleanupConfigDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/tdm/cleanup/config"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<TestDataCleanupConfigDto> saveCleanupConfig(@NotNull @Parameter(name="tableName", description="tableName", required=true) @Valid @RequestParam(value="tableName", required=true) String var1, @Parameter(name="TestDataCleanupConfigDto", description="") @Valid @RequestBody(required=false) TestDataCleanupConfigDto var2);
}

