/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.listeners;

import org.qubership.atp.tdm.service.impl.CleanupServiceImpl;
import org.qubership.atp.tdm.service.impl.DataRefreshServiceImpl;
import org.qubership.atp.tdm.service.impl.StatisticsServiceImpl;
import org.qubership.atp.tdm.service.impl.TestDataServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class JobsInitListener {
    private static final Logger log = LoggerFactory.getLogger(JobsInitListener.class);
    private final StatisticsServiceImpl statisticsService;
    private final DataRefreshServiceImpl dataRefreshService;
    private final CleanupServiceImpl cleanupService;
    private final TestDataServiceImpl testDataService;

    @EventListener(value={ApplicationReadyEvent.class})
    public void runJobsInit() {
        this.statisticsService.startUsersStatisticsMonitoring();
        this.statisticsService.startStatisticsMonitoring();
        this.dataRefreshService.initSchedules();
        this.cleanupService.initSchedules();
        this.statisticsService.startAvailableDataStatsMonitoring();
        this.testDataService.schedule();
    }

    public JobsInitListener(StatisticsServiceImpl statisticsService, DataRefreshServiceImpl dataRefreshService, CleanupServiceImpl cleanupService, TestDataServiceImpl testDataService) {
        this.statisticsService = statisticsService;
        this.dataRefreshService = dataRefreshService;
        this.cleanupService = cleanupService;
        this.testDataService = testDataService;
    }
}

