/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.model;

import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.ComboCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.CustomSql;
import com.healthmarketscience.sqlbuilder.FunctionCall;
import com.healthmarketscience.sqlbuilder.OrderObject;
import com.healthmarketscience.sqlbuilder.SelectQuery;
import com.healthmarketscience.sqlbuilder.dbspec.Column;
import com.healthmarketscience.sqlbuilder.dbspec.Table;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbColumn;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbSchema;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbSpec;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbTable;
import java.util.ArrayList;
import java.util.List;
import org.qubership.atp.tdm.model.table.OrderType;
import org.qubership.atp.tdm.model.table.TestDataTableFilter;
import org.qubership.atp.tdm.model.table.TestDataTableOrder;
import org.qubership.atp.tdm.model.table.TestDataType;
import org.qubership.atp.tdm.model.table.conditions.factories.SearchConditionFactory;
import org.qubership.atp.tdm.model.table.conditions.factories.TestDataTypeConditionFactory;
import org.qubership.atp.tdm.model.table.conditions.search.SearchCondition;
import org.qubership.atp.tdm.utils.TestDataUtils;

public class QueryInfo {
    private static final String DB_COLUMN_DEFAULT_TYPE = "varchar";
    private SelectQuery query;
    private SelectQuery countQuery;

    public static Builder newBuilder(String tableName, TestDataType testDataType) {
        return new QueryInfo().new Builder().init(tableName).setTestDataType(testDataType);
    }

    public static Builder newBuilder(String tableName, List<String> columnNames, TestDataType testDataType) {
        return new QueryInfo().new Builder().init(tableName, columnNames).setTestDataType(testDataType);
    }

    public SelectQuery getQuery() {
        return this.query;
    }

    public SelectQuery getCountQuery() {
        return this.countQuery;
    }

    public void setQuery(SelectQuery query) {
        this.query = query;
    }

    public void setCountQuery(SelectQuery countQuery) {
        this.countQuery = countQuery;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryInfo)) {
            return false;
        }
        QueryInfo other = (QueryInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SelectQuery this$query = this.getQuery();
        SelectQuery other$query = other.getQuery();
        if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
            return false;
        }
        SelectQuery this$countQuery = this.getCountQuery();
        SelectQuery other$countQuery = other.getCountQuery();
        return !(this$countQuery == null ? other$countQuery != null : !this$countQuery.equals(other$countQuery));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QueryInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SelectQuery $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        SelectQuery $countQuery = this.getCountQuery();
        result = result * 59 + ($countQuery == null ? 43 : $countQuery.hashCode());
        return result;
    }

    public String toString() {
        return "QueryInfo(query=" + this.getQuery() + ", countQuery=" + this.getCountQuery() + ")";
    }

    public class Builder {
        private Builder() {
        }

        private Builder init(String tableName) {
            QueryInfo.this.query = new SelectQuery().addAllColumns().addCustomFromTable((Object)tableName);
            this.initCountQuery(tableName);
            return this;
        }

        private Builder init(String tableName, List<String> columnNames) {
            DbSpec spec = new DbSpec();
            DbSchema schema = spec.addDefaultSchema();
            DbTable dbTable = schema.addTable(tableName);
            Column[] columns = (Column[])columnNames.stream().map(columnName -> new DbColumn(dbTable, "\"" + columnName + "\"", QueryInfo.DB_COLUMN_DEFAULT_TYPE, new Object[0])).toArray(Column[]::new);
            QueryInfo.this.query = new SelectQuery().addFromTable((Table)dbTable);
            QueryInfo.this.query.addColumns(columns);
            this.initCountQuery(tableName);
            return this;
        }

        private void initCountQuery(String tableName) {
            QueryInfo.this.countQuery = new SelectQuery().addCustomColumns(new Object[]{FunctionCall.countAll()}).addCustomFromTable((Object)tableName);
        }

        private Builder setTestDataType(TestDataType testDataType) {
            if (!TestDataType.ALL.equals((Object)testDataType)) {
                BinaryCondition binaryCondition = TestDataTypeConditionFactory.getCondition(testDataType);
                QueryInfo.this.query.addCondition((Condition)binaryCondition);
                QueryInfo.this.countQuery.addCondition((Condition)binaryCondition);
            }
            return this;
        }

        public Builder setOffset(Integer offset) {
            QueryInfo.this.query.setOffset((Object)offset);
            return this;
        }

        public Builder setLimit(Integer limit) {
            QueryInfo.this.query.setFetchNext((Object)limit);
            return this;
        }

        public Builder setFilters(List<TestDataTableFilter> filters) {
            ArrayList<ComboCondition> conditions = new ArrayList<ComboCondition>();
            for (TestDataTableFilter filter : filters) {
                List<String> filterValues = filter.getValues();
                for (String filterValue : filterValues) {
                    filterValue = TestDataUtils.escapeCharacters(filterValue);
                    SearchCondition searchCondition = SearchConditionFactory.getCondition(filter.getSearchCondition(), filter.isCaseSensitive());
                    CustomSql column = new CustomSql((Object)("\"" + filter.getColumn() + "\""));
                    BinaryCondition binaryCondition = searchCondition.create(column, filterValue);
                    conditions.add(ComboCondition.or((Condition[])new Condition[]{binaryCondition}));
                }
                QueryInfo.this.query.addCondition((Condition)ComboCondition.or((Object[])conditions.toArray()));
                QueryInfo.this.countQuery.addCondition((Condition)ComboCondition.or((Object[])conditions.toArray()));
                conditions.clear();
            }
            return this;
        }

        public Builder setOrder(TestDataTableOrder testDataTableOrder) {
            CustomSql column = new CustomSql((Object)("\"" + testDataTableOrder.getColumnName() + "\""));
            OrderObject.Dir dir = OrderObject.Dir.ASCENDING;
            if (OrderType.DESC.equals((Object)testDataTableOrder.getOrderType())) {
                dir = OrderObject.Dir.DESCENDING;
            }
            QueryInfo.this.query.addCustomOrdering((Object)column, dir);
            return this;
        }

        public QueryInfo build() {
            return QueryInfo.this;
        }
    }
}

