/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.model.scheduler;

import java.util.UUID;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.qubership.atp.tdm.service.mailsender.AvailableDataStatisticsMailSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@DisallowConcurrentExecution
public class AvailableDataStatisticsMailJob
implements Job {
    private static final Logger log = LoggerFactory.getLogger(AvailableDataStatisticsMailJob.class);
    @Autowired
    private AvailableDataStatisticsMailSender mailSender;

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        String[] key = jobExecutionContext.getJobDetail().getKey().getName().split(";", 2);
        try {
            log.info("Sending available data statistic for system: {}.", (Object)key[0]);
            this.mailSender.send(UUID.fromString(key[0]), UUID.fromString(key[1]));
        }
        catch (Exception e) {
            log.error("An error occurred while running available data monitoring statistics job for system: {}", (Object)key[0], (Object)e);
        }
    }
}

