/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.model.statistics;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.qubership.atp.tdm.model.statistics.DateStatisticsItem;

public class DateStatistics {
    private List<String> dates;
    private List<DateStatisticsItem> items;

    public static DateStatistics concatDateStatistics(@Nonnull DateStatistics firstDateStatistics, @Nonnull DateStatistics secondDateStatistics) {
        DateStatistics statistics = firstDateStatistics.items.size() > secondDateStatistics.items.size() ? DateStatistics.updateDateStatistics(firstDateStatistics, secondDateStatistics) : DateStatistics.updateDateStatistics(secondDateStatistics, firstDateStatistics);
        return statistics;
    }

    private static DateStatistics updateDateStatistics(@Nonnull DateStatistics firstDateStatistics, @Nonnull DateStatistics secondDateStatistics) {
        firstDateStatistics.items.forEach(itemFirst -> secondDateStatistics.items.forEach(itemSecond -> {
            if (itemSecond.getContext().equals(itemFirst.getContext()) && itemSecond.getEnvironment().equals(itemFirst.getEnvironment()) && itemSecond.getSystem().equals(itemFirst.getSystem())) {
                ArrayList<Long> createdList = new ArrayList<Long>();
                for (int i = 0; i < itemFirst.getCreated().size(); ++i) {
                    createdList.add(i, itemFirst.getCreated().get(i) + itemSecond.getCreated().get(i));
                }
                itemFirst.setCreated(createdList);
            }
        }));
        return firstDateStatistics;
    }

    public List<String> getDates() {
        return this.dates;
    }

    public List<DateStatisticsItem> getItems() {
        return this.items;
    }

    public void setDates(List<String> dates) {
        this.dates = dates;
    }

    public void setItems(List<DateStatisticsItem> items) {
        this.items = items;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DateStatistics)) {
            return false;
        }
        DateStatistics other = (DateStatistics)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$dates = this.getDates();
        List<String> other$dates = other.getDates();
        if (this$dates == null ? other$dates != null : !((Object)this$dates).equals(other$dates)) {
            return false;
        }
        List<DateStatisticsItem> this$items = this.getItems();
        List<DateStatisticsItem> other$items = other.getItems();
        return !(this$items == null ? other$items != null : !((Object)this$items).equals(other$items));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DateStatistics;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $dates = this.getDates();
        result = result * 59 + ($dates == null ? 43 : ((Object)$dates).hashCode());
        List<DateStatisticsItem> $items = this.getItems();
        result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
        return result;
    }

    public String toString() {
        return "DateStatistics(dates=" + this.getDates() + ", items=" + this.getItems() + ")";
    }

    public DateStatistics() {
    }

    public DateStatistics(List<String> dates, List<DateStatisticsItem> items) {
        this.dates = dates;
        this.items = items;
    }
}

