/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.model.statistics;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Objects;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.hibernate.proxy.HibernateProxy;
import org.qubership.atp.tdm.model.statistics.SystemEnvironmentModel;
import org.qubership.atp.tdm.utils.scheduler.ScheduleConfig;

@Entity
@IdClass(value=SystemEnvironmentModel.class)
public class TestAvailableDataMonitoring
implements ScheduleConfig,
Serializable {
    private static final long serialVersionUID = 3055608819732633976L;
    @Id
    @Column(name="system_id")
    private UUID systemId;
    @Id
    @Column(name="environment_id")
    private UUID environmentId;
    @Column(name="scheduled")
    private boolean scheduled;
    @Column(name="schedule")
    private String schedule;
    @Column(name="recipients")
    private String recipients;
    @Column(name="threshold")
    private int threshold;
    @Column(name="description")
    private String description;
    @Column(name="active_column")
    private String activeColumn;
    @Transient
    @JsonIgnore
    private UUID id;

    public TestAvailableDataMonitoring(UUID systemId, UUID environmentId) {
        this.systemId = systemId;
        this.environmentId = environmentId;
    }

    @Override
    public UUID getId() {
        return this.systemId;
    }

    @Override
    public boolean isScheduled() {
        return this.scheduled && StringUtils.isNotEmpty((String)this.schedule);
    }

    public final boolean equals(Object obj) {
        Class thisEffectiveClass;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        Class objectEffectiveClass = obj instanceof HibernateProxy ? ((HibernateProxy)obj).getHibernateLazyInitializer().getPersistentClass() : obj.getClass();
        Class clazz = thisEffectiveClass = this instanceof HibernateProxy ? ((HibernateProxy)this).getHibernateLazyInitializer().getPersistentClass() : this.getClass();
        if (thisEffectiveClass != objectEffectiveClass) {
            return false;
        }
        TestAvailableDataMonitoring that = (TestAvailableDataMonitoring)obj;
        return this.getSystemId() != null && Objects.equals(this.getSystemId(), that.getSystemId()) && this.getEnvironmentId() != null && Objects.equals(this.getEnvironmentId(), that.getEnvironmentId());
    }

    public final int hashCode() {
        return Objects.hash(this.systemId, this.environmentId);
    }

    public UUID getSystemId() {
        return this.systemId;
    }

    public UUID getEnvironmentId() {
        return this.environmentId;
    }

    @Override
    public String getSchedule() {
        return this.schedule;
    }

    public String getRecipients() {
        return this.recipients;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public String getDescription() {
        return this.description;
    }

    public String getActiveColumn() {
        return this.activeColumn;
    }

    public void setSystemId(UUID systemId) {
        this.systemId = systemId;
    }

    public void setEnvironmentId(UUID environmentId) {
        this.environmentId = environmentId;
    }

    public void setScheduled(boolean scheduled) {
        this.scheduled = scheduled;
    }

    public void setSchedule(String schedule) {
        this.schedule = schedule;
    }

    public void setRecipients(String recipients) {
        this.recipients = recipients;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setActiveColumn(String activeColumn) {
        this.activeColumn = activeColumn;
    }

    @JsonIgnore
    public void setId(UUID id) {
        this.id = id;
    }

    public String toString() {
        return "TestAvailableDataMonitoring(systemId=" + this.getSystemId() + ", environmentId=" + this.getEnvironmentId() + ", scheduled=" + this.isScheduled() + ", schedule=" + this.getSchedule() + ", recipients=" + this.getRecipients() + ", threshold=" + this.getThreshold() + ", description=" + this.getDescription() + ", activeColumn=" + this.getActiveColumn() + ", id=" + this.getId() + ")";
    }

    public TestAvailableDataMonitoring(UUID systemId, UUID environmentId, boolean scheduled, String schedule, String recipients, int threshold, String description, String activeColumn, UUID id) {
        this.systemId = systemId;
        this.environmentId = environmentId;
        this.scheduled = scheduled;
        this.schedule = schedule;
        this.recipients = recipients;
        this.threshold = threshold;
        this.description = description;
        this.activeColumn = activeColumn;
        this.id = id;
    }

    public TestAvailableDataMonitoring() {
    }
}

