/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.repo;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.atp.tdm.model.TestDataTableCatalog;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public interface CatalogRepository
extends JpaRepository<TestDataTableCatalog, String> {
    public List<TestDataTableCatalog> findAllByProjectIdAndSystemId(@Nonnull UUID var1, @Nullable UUID var2);

    public List<TestDataTableCatalog> findAllByProjectIdAndEnvironmentId(@Nonnull UUID var1, @Nullable UUID var2);

    public List<TestDataTableCatalog> findByProjectIdAndLastUsageBefore(UUID var1, Date var2);

    public List<TestDataTableCatalog> findByProjectIdNotInAndLastUsageBefore(Collection<UUID> var1, Date var2);

    public List<TestDataTableCatalog> findByLastUsageBefore(Date var1);

    @Transactional
    public void deleteByTableName(@Nonnull String var1);

    public TestDataTableCatalog findByRefreshConfigId(@Nonnull UUID var1);

    public TestDataTableCatalog findByProjectIdAndSystemIdAndTableTitle(@Nonnull UUID var1, @Nonnull UUID var2, @Nonnull String var3);

    public TestDataTableCatalog findByTableName(@Nonnull String var1);

    public TestDataTableCatalog findTableByProjectIdAndTableName(@Nonnull UUID var1, @Nonnull String var2);

    public Optional<TestDataTableCatalog> findFirstByProjectIdAndTableTitle(@Nonnull UUID var1, @Nonnull String var2);

    public List<TestDataTableCatalog> findAllByProjectIdAndTableTitle(@Nonnull UUID var1, @Nonnull String var2);

    public List<TestDataTableCatalog> findAllByCleanupConfigId(@Nonnull UUID var1);

    public List<TestDataTableCatalog> findAllByProjectIdAndTableTitleAndCleanupConfigIdIsNotNull(@Nonnull UUID var1, @Nonnull String var2);

    public List<TestDataTableCatalog> findAllByProjectIdAndSystemIdAndCleanupConfigIdIsNotNull(@Nonnull UUID var1, @Nonnull UUID var2);

    public List<TestDataTableCatalog> findAllByProjectId(@Nonnull UUID var1);

    public List<TestDataTableCatalog> findByEnvironmentId(@Nonnull UUID var1);

    public List<TestDataTableCatalog> findBySystemId(@Nonnull UUID var1);

    public List<TestDataTableCatalog> findAllByProjectIdAndTableTitleAndSystemIdIn(@Nonnull UUID var1, @Nonnull String var2, @Nonnull List<UUID> var3);

    public List<TestDataTableCatalog> findAllByEnvironmentIdAndSystemId(@Nonnull UUID var1, @Nonnull UUID var2);

    @Transactional
    @Modifying(flushAutomatically=true)
    @Query(value="update TestDataTableCatalog c set c.lastUsage = :date where c.tableName = :tableName")
    public void updateLastUsageByTableName(@Param(value="date") Date var1, @Param(value="tableName") String var2);
}

