/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.repo.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.atp.common.lock.LockManager;
import org.qubership.atp.tdm.exceptions.internal.TdmOccupyDataIncorrectlyException;
import org.qubership.atp.tdm.exceptions.internal.TdmOccupyDataResponseMessageException;
import org.qubership.atp.tdm.exceptions.internal.TdmSearchCleanupConfigException;
import org.qubership.atp.tdm.model.TestDataTableCatalog;
import org.qubership.atp.tdm.model.cleanup.CleanupResults;
import org.qubership.atp.tdm.model.cleanup.TestDataCleanupConfig;
import org.qubership.atp.tdm.model.refresh.RefreshResults;
import org.qubership.atp.tdm.model.rest.ResponseMessage;
import org.qubership.atp.tdm.model.rest.ResponseType;
import org.qubership.atp.tdm.model.rest.requests.AddInfoToRowRequest;
import org.qubership.atp.tdm.model.rest.requests.GetRowRequest;
import org.qubership.atp.tdm.model.rest.requests.OccupyFullRowRequest;
import org.qubership.atp.tdm.model.rest.requests.OccupyRowRequest;
import org.qubership.atp.tdm.model.rest.requests.ReleaseRowRequest;
import org.qubership.atp.tdm.model.rest.requests.UpdateRowRequest;
import org.qubership.atp.tdm.model.table.TableDetails;
import org.qubership.atp.tdm.model.table.TestDataTable;
import org.qubership.atp.tdm.repo.AtpActionRepository;
import org.qubership.atp.tdm.repo.CatalogRepository;
import org.qubership.atp.tdm.repo.CleanupConfigRepository;
import org.qubership.atp.tdm.repo.TestDataTableRepository;
import org.qubership.atp.tdm.service.ColumnService;
import org.qubership.atp.tdm.service.DataRefreshService;
import org.qubership.atp.tdm.service.TestDataFlagsService;
import org.qubership.atp.tdm.service.impl.CleanupServiceImpl;
import org.qubership.atp.tdm.utils.TestDataTableConvertor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class AtpActionRepositoryImpl
implements AtpActionRepository {
    private static final Logger log = LoggerFactory.getLogger(AtpActionRepositoryImpl.class);
    private static final String DATA_REFRESH_LINK = "%s/project/%s/tdm/TEST%%20DATA/%s/%s";
    private static final Integer UPDATE_TEST_DATA_LIMIT = 100;
    private final CatalogRepository catalogRepository;
    private final TestDataTableRepository testDataTableRepository;
    private final CleanupConfigRepository cleanupConfigRepository;
    private final ColumnService columnService;
    private final DataRefreshService dataRefreshService;
    private final TestDataFlagsService testDataFlagsService;
    private final CleanupServiceImpl cleanupService;
    private final LockManager lockManager;

    @Autowired
    public AtpActionRepositoryImpl(@Nonnull CatalogRepository catalogRepository, @Nonnull TestDataTableRepository testDataTableRepository, @Nonnull CleanupConfigRepository cleanupConfigRepository, @Nonnull ColumnService columnService, @Nonnull DataRefreshService dataRefreshService, @Nonnull TestDataFlagsService testDataFlagsService, @Nonnull CleanupServiceImpl cleanupService, @Nonnull LockManager lockManager) {
        this.catalogRepository = catalogRepository;
        this.testDataTableRepository = testDataTableRepository;
        this.cleanupConfigRepository = cleanupConfigRepository;
        this.columnService = columnService;
        this.dataRefreshService = dataRefreshService;
        this.testDataFlagsService = testDataFlagsService;
        this.cleanupService = cleanupService;
        this.lockManager = lockManager;
    }

    @Override
    public ResponseMessage insertTestData(@Nonnull UUID projectId, @Nullable UUID systemId, @Nullable UUID environmentId, @Nonnull String tableTitle, List<Map<String, Object>> records, @Nonnull String resultLink) {
        ResponseMessage responseMessage = new ResponseMessage();
        this.lockManager.executeWithLockWithUniqueLockKey("Insert. sys:" + systemId, () -> {
            TableDetails tableDetails = this.getTableDetails(projectId, systemId, tableTitle);
            String finalResultLink = resultLink + "/" + tableDetails.getTableName();
            if (tableDetails.isExists()) {
                responseMessage.setContent("Test data table with specified name already exists. Test data was inserted.");
                responseMessage.setLink(finalResultLink);
                this.testDataTableRepository.insertRows(tableDetails.getTableName(), true, records, false);
                this.testDataTableRepository.updateLastUsage(tableDetails.getTableName());
            } else {
                responseMessage.setContent("A new test data table has been created. Test data was inserted.");
                responseMessage.setLink(finalResultLink);
                this.testDataTableRepository.insertRows(tableDetails.getTableName(), false, records, false);
                this.testDataTableRepository.saveTestDataTableCatalog(tableDetails.getTableName(), tableTitle, projectId, systemId, environmentId);
                this.testDataFlagsService.setValidateUnoccupiedResourcesFlag(tableDetails.getTableName(), false, false);
                if (Objects.nonNull(systemId)) {
                    this.columnService.setUpLinks(projectId, systemId, tableTitle, tableDetails.getTableName());
                }
            }
            responseMessage.setType(ResponseType.SUCCESS);
        });
        return responseMessage;
    }

    @Override
    public List<ResponseMessage> occupyTestData(@Nonnull UUID projectId, @Nullable UUID systemId, @Nonnull String tableTitle, @Nonnull String occupiedBy, @Nonnull List<OccupyRowRequest> occupyRowRequests, @Nonnull String resultLink) {
        ArrayList<ResponseMessage> responseMessages = new ArrayList<ResponseMessage>();
        TableDetails tableDetails = this.getTableDetails(projectId, systemId, tableTitle);
        String finalResultLink = resultLink + "/" + tableDetails.getTableName();
        if (!tableDetails.isExists()) {
            log.warn("Occupation test data. Table with title:  [{}] was not found.", (Object)tableTitle);
            responseMessages.add(new ResponseMessage(ResponseType.ERROR, String.format("Table with title \"%s\" was not found!", tableTitle)));
            return responseMessages;
        }
        this.lockManager.executeWithLockWithUniqueLockKey("occupyTestData: " + projectId + " " + tableTitle, () -> {
            for (OccupyRowRequest occupyRowRequest : occupyRowRequests) {
                TestDataTable table = this.testDataTableRepository.getTestData(false, tableDetails.getTableName(), null, 1, occupyRowRequest.getFilters(), null, false);
                Optional row = table.getData().stream().findFirst();
                if (row.isPresent()) {
                    String nameColumnResponse = occupyRowRequest.getNameColumnResponse();
                    if (((Map)row.get()).containsKey(nameColumnResponse)) {
                        UUID rowId = table.getData().stream().map(r -> UUID.fromString(String.valueOf(r.get("ROW_ID")))).findFirst().orElseThrow(() -> new TdmOccupyDataIncorrectlyException(tableTitle));
                        this.testDataTableRepository.occupyTestData(tableDetails.getTableName(), occupiedBy, Collections.singletonList(rowId));
                        this.testDataTableRepository.updateLastUsage(tableDetails.getTableName());
                        String value = ((Map)row.get()).get(nameColumnResponse).toString();
                        responseMessages.add(new ResponseMessage(ResponseType.SUCCESS, value, finalResultLink));
                        continue;
                    }
                    log.warn("Occupation test data. Response column with name: [{}] was not found.", (Object)nameColumnResponse);
                    responseMessages.add(new ResponseMessage(ResponseType.ERROR, String.format("Column with name \"%s\" was not found!", nameColumnResponse)));
                    continue;
                }
                log.warn("Occupation test data. Rows were not found. Filters: {}", occupyRowRequest.getFilters());
                responseMessages.add(new ResponseMessage(ResponseType.ERROR, "No test data available for requested criteria!"));
            }
        });
        return responseMessages;
    }

    @Override
    @Transactional
    public List<ResponseMessage> occupyTestDataFullRow(@Nonnull UUID projectId, @Nullable UUID systemId, @Nonnull String tableTitle, @Nonnull String occupiedBy, List<OccupyFullRowRequest> occupyRowRequests, @Nonnull String resultLink) {
        ArrayList<ResponseMessage> responseMessages = new ArrayList<ResponseMessage>();
        TableDetails tableDetails = this.getTableDetails(projectId, systemId, tableTitle);
        String finalResultLink = resultLink + "/" + tableDetails.getTableName();
        if (!tableDetails.isExists()) {
            log.warn("Occupation test data to return several rows. Table with title:  [{}] was not found.", (Object)tableTitle);
            responseMessages.add(new ResponseMessage(ResponseType.ERROR, String.format("Table with title \"%s\" was not found!", tableTitle)));
            return responseMessages;
        }
        this.lockManager.executeWithLockWithUniqueLockKey("Occupy data in table: " + tableDetails.getTableName(), () -> {
            for (OccupyFullRowRequest occupyRowRequest : occupyRowRequests) {
                TestDataTable table = this.testDataTableRepository.getTestData(false, tableDetails.getTableName(), null, 1, occupyRowRequest.getFilters(), null, true);
                Optional row = table.getData().stream().findFirst();
                if (row.isPresent()) {
                    UUID rowId = table.getData().stream().map(r -> UUID.fromString(String.valueOf(r.get("ROW_ID")))).findFirst().orElseThrow(() -> new TdmOccupyDataIncorrectlyException(tableTitle));
                    boolean columnsExists = true;
                    HashMap<String, String> responseValues = new HashMap<String, String>();
                    for (String responseColumnName : occupyRowRequest.getResponseColumnNames()) {
                        if (((Map)row.get()).containsKey(responseColumnName)) {
                            String columnValue = String.valueOf(((Map)row.get()).get(responseColumnName));
                            responseValues.put(responseColumnName, columnValue);
                            continue;
                        }
                        columnsExists = false;
                        log.warn("Occupation test data to return several rows. Response column with name: [{}] was not found.", (Object)responseColumnName);
                        responseMessages.add(new ResponseMessage(ResponseType.ERROR, String.format("Column with name \"%s\" was not found!", responseColumnName)));
                    }
                    if (!columnsExists) continue;
                    this.testDataTableRepository.occupyTestData(tableDetails.getTableName(), occupiedBy, Collections.singletonList(rowId));
                    this.testDataTableRepository.updateLastUsage(tableDetails.getTableName());
                    try {
                        responseMessages.add(new ResponseMessage(ResponseType.SUCCESS, new ObjectMapper().writeValueAsString(responseValues), responseValues, finalResultLink));
                        continue;
                    }
                    catch (Exception e) {
                        log.error("Error while build occupy to return several rows response message.", (Throwable)e);
                        throw new TdmOccupyDataResponseMessageException();
                    }
                }
                log.warn("Occupation test data to return several rows. Rows were not found. Filters: {}", occupyRowRequest.getFilters());
                responseMessages.add(new ResponseMessage(ResponseType.ERROR, "No test data available for requested criteria!"));
            }
        });
        return responseMessages;
    }

    @Override
    public List<ResponseMessage> releaseTestData(@Nonnull UUID projectId, @Nullable UUID systemId, @Nonnull String tableTitle, @Nonnull List<ReleaseRowRequest> releaseRowRequests) {
        ArrayList<ResponseMessage> responseMessages = new ArrayList<ResponseMessage>();
        TableDetails tableDetails = this.getTableDetails(projectId, systemId, tableTitle);
        if (tableDetails.isExists()) {
            for (ReleaseRowRequest releaseRowRequest : releaseRowRequests) {
                TestDataTable table = this.testDataTableRepository.getTestData(true, tableDetails.getTableName(), null, null, releaseRowRequest.getFilters(), null, false);
                List<Map<String, Object>> data = table.getData();
                if (data.size() == 1) {
                    String nameColumnResponse;
                    Map row = (Map)data.stream().findFirst().get();
                    if (row.containsKey(nameColumnResponse = releaseRowRequest.getNameColumnResponse())) {
                        UUID rowId = UUID.fromString(String.valueOf(row.get("ROW_ID")));
                        this.testDataTableRepository.releaseTestData(tableDetails.getTableName(), Collections.singletonList(rowId));
                        this.testDataTableRepository.updateLastUsage(tableDetails.getTableName());
                        String value = row.get(nameColumnResponse).toString();
                        responseMessages.add(new ResponseMessage(ResponseType.SUCCESS, value));
                        continue;
                    }
                    log.warn("Release test data. Response column with name: [{}] was not found.", (Object)nameColumnResponse);
                    responseMessages.add(new ResponseMessage(ResponseType.ERROR, String.format("Column with name \"%s\" was not found!", nameColumnResponse)));
                    continue;
                }
                if (data.size() > 1) {
                    log.warn("Release test data. More then one row were found. Filters: {}", releaseRowRequest.getFilters());
                    responseMessages.add(new ResponseMessage(ResponseType.ERROR, "More than one value was found using the specified search criteria!"));
                    continue;
                }
                log.warn("Release test data. Rows were not found. Filters: {}", releaseRowRequest.getFilters());
                responseMessages.add(new ResponseMessage(ResponseType.ERROR, "No test data available for requested criteria!"));
            }
        } else {
            log.warn("Release test data. Table with title:  [{}] was not found.", (Object)tableTitle);
            responseMessages.add(new ResponseMessage(ResponseType.ERROR, String.format("Table with title \"%s\" was not found!", tableTitle)));
            return responseMessages;
        }
        return responseMessages;
    }

    @Override
    public List<ResponseMessage> releaseFullTestData(@Nonnull UUID projectId, @Nullable UUID systemId, @Nonnull String tableTitle) {
        ArrayList<ResponseMessage> responseMessages = new ArrayList<ResponseMessage>();
        TableDetails tableDetails = this.getTableDetails(projectId, systemId, tableTitle);
        if (!tableDetails.isExists()) {
            log.warn("Release test data. Table with title: [{}] was not found.", (Object)tableTitle);
            responseMessages.add(new ResponseMessage(ResponseType.ERROR, String.format("Table with title \"%s\" was not found!", tableTitle)));
            return responseMessages;
        }
        int offset = 0;
        ArrayList<UUID> allRowIds = new ArrayList<UUID>();
        try {
            List<Map<String, Object>> testDataTable;
            while (!(testDataTable = this.testDataTableRepository.getTestData(true, tableDetails.getTableName(), offset, UPDATE_TEST_DATA_LIMIT, null, null, false).getData()).isEmpty()) {
                List rowIds = testDataTable.stream().map(row -> UUID.fromString(String.valueOf(row.get("ROW_ID")))).collect(Collectors.toList());
                allRowIds.addAll(rowIds);
                offset += UPDATE_TEST_DATA_LIMIT.intValue();
            }
            if (!allRowIds.isEmpty()) {
                this.testDataTableRepository.releaseTestData(tableDetails.getTableName(), allRowIds);
                this.testDataTableRepository.updateLastUsage(tableDetails.getTableName());
            }
            responseMessages.add(new ResponseMessage(ResponseType.SUCCESS, String.format("All occupied data in table with title \"%s\" released.", tableTitle)));
        }
        catch (Exception e) {
            this.logAndAddErrorResponse(tableTitle, e, responseMessages);
        }
        return responseMessages;
    }

    private void logAndAddErrorResponse(String tableTitle, Exception e, List<ResponseMessage> responseMessages) {
        log.error("Failed to release test data for table [{}]: {}", new Object[]{tableTitle, e.getMessage(), e});
        responseMessages.add(new ResponseMessage(ResponseType.ERROR, String.format("An error occurred while releasing data for table \"%s\": %s", tableTitle, e.getMessage())));
    }

    @Override
    public List<ResponseMessage> updateTestData(@Nonnull UUID projectId, @Nullable UUID systemId, @Nonnull String tableTitle, @Nonnull List<UpdateRowRequest> updateRowRequests) {
        ArrayList<ResponseMessage> responseMessages = new ArrayList<ResponseMessage>();
        TableDetails table = this.getTableDetails(projectId, systemId, tableTitle);
        if (table.isExists()) {
            for (UpdateRowRequest updateRowRequest : updateRowRequests) {
                int updatedRowsCount = this.testDataTableRepository.updateRows(table.getTableName(), updateRowRequest.getFilters(), updateRowRequest.getRecordWithDataForUpdate());
                this.testDataTableRepository.updateLastUsage(table.getTableName());
                if (updatedRowsCount > 0) {
                    String msg = String.format("\"%s\" rows were successfully updated", updatedRowsCount);
                    responseMessages.add(new ResponseMessage(ResponseType.SUCCESS, msg));
                    continue;
                }
                responseMessages.add(new ResponseMessage(ResponseType.ERROR, "No test data available for requested criteria!"));
            }
        } else {
            String msg = String.format("Table with title \"%s\" was not found!", tableTitle);
            log.warn("Updating test data. {}", (Object)msg);
            responseMessages.add(new ResponseMessage(ResponseType.ERROR, msg));
            return responseMessages;
        }
        return responseMessages;
    }

    @Override
    public List<ResponseMessage> getMultipleColumnTestData(@Nonnull UUID projectId, @Nullable UUID systemId, @Nonnull String tableTitle, List<GetRowRequest> getRowRequests, @Nonnull String resultLink) {
        ArrayList<ResponseMessage> responseMessages = new ArrayList<ResponseMessage>();
        TableDetails tableDetails = this.getTableDetails(projectId, systemId, tableTitle);
        String finalResultLink = resultLink + "/" + tableDetails.getTableName();
        if (tableDetails.isExists()) {
            for (GetRowRequest getRowRequest : getRowRequests) {
                TestDataTable table = this.testDataTableRepository.getTestDataMultiple(tableDetails.getTableName(), getRowRequest.getFilters());
                this.testDataTableRepository.updateLastUsage(tableDetails.getTableName());
                Optional row = table.getData().stream().findFirst();
                if (row.isPresent()) {
                    List<String> nameColumnResponse = getRowRequest.getResponseColumnNames();
                    boolean allColumnsExist = true;
                    HashMap<String, String> responseValues = new HashMap<String, String>();
                    for (String responseColumnName : nameColumnResponse) {
                        if (((Map)row.get()).containsKey(responseColumnName)) {
                            String columnValue = String.valueOf(((Map)row.get()).get(responseColumnName));
                            responseValues.put(responseColumnName, columnValue);
                            continue;
                        }
                        allColumnsExist = false;
                        log.warn("Getting test data. Response column with name: [{}] was not found.", (Object)responseColumnName);
                        responseMessages.add(new ResponseMessage(ResponseType.ERROR, String.format("Column with name \"%s\" was not found!", nameColumnResponse)));
                    }
                    if (!allColumnsExist) continue;
                    try {
                        responseMessages.add(new ResponseMessage(ResponseType.SUCCESS, new ObjectMapper().writeValueAsString(responseValues), responseValues, finalResultLink));
                        continue;
                    }
                    catch (Exception e) {
                        log.error("Error while build occupy to return several rows response message.", (Throwable)e);
                        throw new TdmOccupyDataResponseMessageException();
                    }
                }
                log.warn("Getting test data. Rows were not found. Filters: {}", getRowRequest.getFilters());
                responseMessages.add(new ResponseMessage(ResponseType.ERROR, "No test data available for requested criteria!"));
            }
        } else {
            log.warn("Getting test data. Table with title:  [{}] was not found.", (Object)tableTitle);
            responseMessages.add(new ResponseMessage(ResponseType.ERROR, String.format("Table with title \"%s\" was not found!", tableTitle)));
            return responseMessages;
        }
        return responseMessages;
    }

    @Override
    public List<ResponseMessage> getTestData(@Nonnull UUID projectId, @Nullable UUID systemId, @Nonnull String tableTitle, @Nonnull List<GetRowRequest> getRowRequests) {
        ArrayList<ResponseMessage> responseMessages = new ArrayList<ResponseMessage>();
        TableDetails tableDetails = this.getTableDetails(projectId, systemId, tableTitle);
        if (tableDetails.isExists()) {
            for (GetRowRequest getRowRequest : getRowRequests) {
                TestDataTable table = this.testDataTableRepository.getTestData(false, tableDetails.getTableName(), null, 1, getRowRequest.getFilters(), null, false);
                this.testDataTableRepository.updateLastUsage(tableDetails.getTableName());
                Optional row = table.getData().stream().findFirst();
                if (row.isPresent()) {
                    String nameColumnResponse = getRowRequest.getNameColumnResponse();
                    if (((Map)row.get()).containsKey(nameColumnResponse)) {
                        String value = ((Map)row.get()).get(nameColumnResponse).toString();
                        responseMessages.add(new ResponseMessage(ResponseType.SUCCESS, value));
                        continue;
                    }
                    log.warn("Getting test data. Response column with name: [{}] was not found.", (Object)nameColumnResponse);
                    responseMessages.add(new ResponseMessage(ResponseType.ERROR, String.format("Column with name \"%s\" was not found!", nameColumnResponse)));
                    continue;
                }
                log.warn("Getting test data. Rows were not found. Filters: {}", getRowRequest.getFilters());
                responseMessages.add(new ResponseMessage(ResponseType.ERROR, "No test data available for requested criteria!"));
            }
        } else {
            log.warn("Getting test data. Table with title:  [{}] was not found.", (Object)tableTitle);
            responseMessages.add(new ResponseMessage(ResponseType.ERROR, String.format("Table with title \"%s\" was not found!", tableTitle)));
            return responseMessages;
        }
        return responseMessages;
    }

    @Override
    public List<ResponseMessage> addInfoToRow(@Nonnull UUID projectId, @Nullable UUID systemId, @Nonnull String tableTitle, List<AddInfoToRowRequest> addInfoToRowRequests) {
        ArrayList<ResponseMessage> responseMessages = new ArrayList<ResponseMessage>();
        TableDetails table = this.getTableDetails(projectId, systemId, tableTitle);
        if (table.isExists()) {
            for (AddInfoToRowRequest addInfoToRowRequest : addInfoToRowRequests) {
                int updatedRowsCount = this.testDataTableRepository.addInfoToRow(table.getTableName(), addInfoToRowRequest.getFilters(), addInfoToRowRequest.getRecordWithDataForUpdate());
                this.testDataTableRepository.updateLastUsage(table.getTableName());
                if (updatedRowsCount > 0) {
                    String msg = String.format("\"%s\" rows were successfully updated", updatedRowsCount);
                    responseMessages.add(new ResponseMessage(ResponseType.SUCCESS, msg));
                    continue;
                }
                responseMessages.add(new ResponseMessage(ResponseType.ERROR, "No test data available for requested criteria!"));
            }
        } else {
            String msg = String.format("Table with title \"%s\" was not found!", tableTitle);
            log.warn("Add info to row in test data table. {}", (Object)msg);
            responseMessages.add(new ResponseMessage(ResponseType.ERROR, msg));
            return responseMessages;
        }
        return responseMessages;
    }

    @Override
    public List<ResponseMessage> refreshTables(@Nonnull UUID projectId, @Nullable UUID systemId, @Nonnull String tableTitle, @Nonnull String tdmUrl) {
        List<TestDataTableCatalog> catalogList = Objects.nonNull(systemId) ? Collections.singletonList(this.catalogRepository.findByProjectIdAndSystemIdAndTableTitle(projectId, systemId, tableTitle)) : this.catalogRepository.findAllByProjectIdAndTableTitle(projectId, tableTitle);
        if (catalogList.isEmpty()) {
            String message = "Tables with title: " + tableTitle + " was not found under project with id: " + projectId;
            log.warn(message);
            return Collections.singletonList(new ResponseMessage(ResponseType.ERROR, message));
        }
        return this.refreshTables(catalogList, tdmUrl);
    }

    private List<ResponseMessage> refreshTables(@Nonnull List<TestDataTableCatalog> tableCatalogs, @Nonnull String tdmUrl) {
        ArrayList<ResponseMessage> responseMessages = new ArrayList<ResponseMessage>();
        tableCatalogs.forEach(tableCatalog -> {
            String resultLink = this.formResultLink(tableCatalog.getProjectId(), tableCatalog.getEnvironmentId(), tableCatalog.getSystemId(), tdmUrl);
            try {
                RefreshResults refreshResults = this.dataRefreshService.runRefresh(tableCatalog.getTableName(), false);
                String msg = String.format("Successfully refreshed %s records fot table: %s.", refreshResults.getRecordsTotal(), tableCatalog.getTableTitle());
                responseMessages.add(new ResponseMessage(ResponseType.SUCCESS, msg, resultLink));
                this.testDataTableRepository.updateLastUsage(tableCatalog.getTableName());
            }
            catch (Exception e) {
                String message = "Failed to refresh table with title:" + tableCatalog.getTableTitle() + ". Root cause: " + e.getMessage();
                log.error(message, (Throwable)e);
                responseMessages.add(new ResponseMessage(ResponseType.ERROR, message, resultLink));
            }
        });
        return responseMessages;
    }

    @Override
    public List<ResponseMessage> truncateTable(@Nonnull UUID projectId, @Nullable UUID systemId, @Nonnull String tableTitle) {
        TableDetails tableDetails = this.getTableDetails(projectId, systemId, tableTitle);
        ResponseMessage responseMessage = new ResponseMessage();
        this.lockManager.executeWithLockWithUniqueLockKey("truncate table: " + tableDetails.getTableName(), () -> {
            TestDataTableCatalog catalog = this.catalogRepository.findByProjectIdAndSystemIdAndTableTitle(projectId, systemId, tableTitle);
            if (Objects.isNull(catalog)) {
                String message = String.format("Tables with title: %s was not found under project with id: %s", tableTitle, projectId);
                log.warn(message);
                responseMessage.setType(ResponseType.ERROR);
                responseMessage.setContent(message);
                responseMessage.setLink("");
            } else {
                String tableName = catalog.getTableName();
                String message = String.format("Table %s has been truncated.", tableName);
                this.testDataTableRepository.truncateTable(tableName);
                this.testDataTableRepository.updateLastUsage(tableName);
                log.info(message);
                responseMessage.setType(ResponseType.SUCCESS);
                responseMessage.setContent(message);
                responseMessage.setLink("");
            }
        });
        return Collections.singletonList(responseMessage);
    }

    @Override
    public List<ResponseMessage> runCleanupForTable(@Nonnull UUID projectId, @Nullable UUID systemId, @Nonnull String tableTitle) {
        TestDataTableCatalog tableCatalog = this.catalogRepository.findByProjectIdAndSystemIdAndTableTitle(projectId, systemId, tableTitle);
        if (tableCatalog == null) {
            String message = String.format("Table \"%s\" hasn't been found. Could you please check provided data.", tableTitle);
            return Collections.singletonList(new ResponseMessage(ResponseType.ERROR, message));
        }
        if (tableCatalog.getCleanupConfigId() == null) {
            String message = String.format("Cleanup hasn't been configured for table \"%s\".", tableTitle);
            return Collections.singletonList(new ResponseMessage(ResponseType.ERROR, message));
        }
        TestDataCleanupConfig cleanupConfigId = (TestDataCleanupConfig)this.cleanupConfigRepository.findById(tableCatalog.getCleanupConfigId()).orElseThrow(() -> new TdmSearchCleanupConfigException(tableCatalog.getCleanupConfigId().toString()));
        CleanupResults cleanupResults = null;
        try {
            cleanupResults = this.cleanupService.runCleanup(tableCatalog.getTableName(), cleanupConfigId);
            this.testDataTableRepository.updateLastUsage(tableCatalog.getTableName());
        }
        catch (Exception e) {
            String message = String.format("Cleanup %s for table %s failed.\n" + e.getMessage(), cleanupConfigId, tableCatalog.getTableName());
            log.info(message);
            return Collections.singletonList(new ResponseMessage(ResponseType.ERROR, message));
        }
        String message = String.format("For table \"%s\" with total records %s has been removed %s records.", cleanupResults.getTableName(), cleanupResults.getRecordsTotal(), cleanupResults.getRecordsRemoved());
        log.info(message);
        return Collections.singletonList(new ResponseMessage(ResponseType.SUCCESS, message));
    }

    private String formResultLink(UUID projectId, UUID environmentId, UUID systemId, String tdmUrl) {
        return String.format(DATA_REFRESH_LINK, tdmUrl, projectId, environmentId, systemId);
    }

    private TableDetails getTableDetails(@Nonnull UUID projectId, @Nullable UUID systemId, @Nonnull String tableTitle) {
        TestDataTableCatalog tableCatalog = null;
        if (systemId == null) {
            Optional existedCatalog = this.catalogRepository.findAllByProjectIdAndTableTitle(projectId, tableTitle).stream().findFirst();
            if (existedCatalog.isPresent()) {
                tableCatalog = (TestDataTableCatalog)existedCatalog.get();
            }
        } else {
            tableCatalog = this.catalogRepository.findByProjectIdAndSystemIdAndTableTitle(projectId, systemId, tableTitle);
        }
        if (tableCatalog != null) {
            return new TableDetails(tableCatalog.getTableName(), true);
        }
        return new TableDetails(TestDataTableConvertor.generateTestDataTableName(), false);
    }
}

