/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.repo.impl;

import com.google.common.base.Strings;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.List;
import javax.annotation.Nonnull;
import javax.sql.DataSource;
import org.qubership.atp.crypt.api.Decryptor;
import org.qubership.atp.crypt.exception.AtpDecryptException;
import org.qubership.atp.tdm.env.configurator.model.Server;
import org.qubership.atp.tdm.env.configurator.service.EnvironmentsService;
import org.qubership.atp.tdm.exceptions.db.TdmDbConnectionException;
import org.qubership.atp.tdm.exceptions.db.TdmDbDecryptException;
import org.qubership.atp.tdm.exceptions.db.TdmDbDriverException;
import org.qubership.atp.tdm.exceptions.db.TdmDbDriverNotFoundException;
import org.qubership.atp.tdm.exceptions.db.TdmDbJdbsTemplateException;
import org.qubership.atp.tdm.model.TestDataTableCatalog;
import org.qubership.atp.tdm.repo.CatalogRepository;
import org.qubership.atp.tdm.repo.SqlRepository;
import org.qubership.atp.tdm.utils.TestDataUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DriverManagerDataSource;
import org.springframework.stereotype.Repository;

@Repository
public class SqlRepositoryImpl
implements SqlRepository {
    private static final Logger log = LoggerFactory.getLogger(SqlRepositoryImpl.class);
    private static final String ORACLE_DB_TYPE = "oracle";
    private static final String POSTGRES_DB_TYPE = "postgresql";
    private static final String H2_DB_TYPE = "h2";
    private static final String DB_CONNECTION_NAME = "DB";
    private final Decryptor decryptor;

    @Autowired
    public SqlRepositoryImpl(@Nonnull Decryptor decryptor) {
        this.decryptor = decryptor;
    }

    @Override
    public Connection createConnection(Server server) {
        String dbType = server.getProperty("db_type");
        this.getDbDriverName(dbType);
        String jdbcUrl = server.getProperty("jdbc_url");
        String dbLogin = server.getProperty("db_login");
        String dbPassword = server.getProperty("db_password");
        String connectionString = this.createConnectionString(dbType, server);
        this.validateConnectionString(connectionString);
        if (Strings.isNullOrEmpty((String)jdbcUrl)) {
            return this.createConnection(connectionString, dbLogin, dbPassword);
        }
        return this.createConnection(jdbcUrl, dbLogin, dbPassword);
    }

    private void validateConnectionString(String connectionString) {
        if (!(connectionString.startsWith("jdbc:oracle:thin:@") || connectionString.startsWith("jdbc:postgresql://") || connectionString.startsWith("jdbc:h2:"))) {
            throw new SecurityException("Unsupported DB type");
        }
    }

    private Connection createConnection(String connectionString, String user, String password) {
        try {
            log.debug("Connection string: {}", (Object)connectionString);
            return DriverManager.getConnection(connectionString, this.decryptor.decryptIfEncrypted(user), this.decryptor.decryptIfEncrypted(password));
        }
        catch (Exception e) {
            log.error(String.format("Can not create connection for [%s].", connectionString), (Throwable)e);
            throw new TdmDbConnectionException(connectionString);
        }
    }

    @Override
    public Server getServer(String tableName, CatalogRepository catalogRepository, EnvironmentsService environmentsService) {
        TestDataTableCatalog tableCatalog = catalogRepository.findByTableName(tableName);
        List connections = environmentsService.getConnectionsSystemById(tableCatalog.getSystemId());
        return TestDataUtils.getServer(connections, DB_CONNECTION_NAME);
    }

    @Override
    public JdbcTemplate createJdbcTemplate(Server server) {
        JdbcTemplate jdbcTemplate;
        block10: {
            String dbType = server.getProperty("db_type");
            String dbDriverName = this.getDbDriverName(dbType);
            Connection connection = this.createConnection(server);
            try {
                JdbcTemplate jdbcTemplate2 = null;
                if (server.getProperty("jdbc_url").isEmpty()) {
                    String jdbcUrl = this.createConnectionString(dbType, server);
                    jdbcTemplate2 = new JdbcTemplate(this.createDataSource(dbDriverName, jdbcUrl, server.getProperty("db_login"), server.getProperty("db_password")));
                } else {
                    jdbcTemplate2 = new JdbcTemplate(this.createDataSource(dbDriverName, server.getProperty("jdbc_url"), server.getProperty("db_login"), server.getProperty("db_password")));
                }
                jdbcTemplate = jdbcTemplate2;
                if (connection == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.error("Error access DB of system.", (Throwable)e);
                    throw new TdmDbJdbsTemplateException();
                }
            }
            connection.close();
        }
        return jdbcTemplate;
    }

    @Override
    public JdbcTemplate createJdbcTemplate(Server server, int queryTimeout) {
        JdbcTemplate template = this.createJdbcTemplate(server);
        template.setQueryTimeout(queryTimeout);
        return template;
    }

    private DataSource createDataSource(String driverName, String connectionString, String user, String password) {
        DriverManagerDataSource dataSource = new DriverManagerDataSource();
        dataSource.setDriverClassName(driverName);
        dataSource.setUrl(connectionString);
        dataSource.setUsername(this.getDecryptIfEncrypted(user));
        dataSource.setPassword(this.getDecryptIfEncrypted(password));
        return dataSource;
    }

    private String getDbDriverName(String dbType) {
        try {
            if (ORACLE_DB_TYPE.equals(this.getDecryptIfEncrypted(dbType))) {
                Class.forName("oracle.jdbc.driver.OracleDriver");
                return "oracle.jdbc.driver.OracleDriver";
            }
            if (POSTGRES_DB_TYPE.equals(this.getDecryptIfEncrypted(dbType))) {
                Class.forName("org.postgresql.Driver");
                return "org.postgresql.Driver";
            }
            if (H2_DB_TYPE.equals(this.getDecryptIfEncrypted(dbType))) {
                Class.forName("org.h2.Driver");
                return "org.postgresql.Driver";
            }
            throw new TdmDbDriverException(dbType);
        }
        catch (ClassNotFoundException e) {
            throw new TdmDbDriverNotFoundException(dbType);
        }
    }

    private String createConnectionString(String dbType, Server server) {
        if (ORACLE_DB_TYPE.equals(this.getDecryptIfEncrypted(dbType))) {
            return "jdbc:oracle:thin:@" + this.getDecryptedProperty(server, "db_host") + ":" + this.getDecryptedProperty(server, "db_port") + "/" + this.getDecryptedProperty(server, "db_name");
        }
        if (POSTGRES_DB_TYPE.equals(this.getDecryptIfEncrypted(dbType))) {
            return "jdbc:postgresql://" + this.getDecryptedProperty(server, "db_host") + ":" + this.getDecryptedProperty(server, "db_port") + "/" + this.getDecryptedProperty(server, "db_name");
        }
        if (H2_DB_TYPE.equals(this.getDecryptIfEncrypted(dbType))) {
            return "jdbc:h2:" + this.getDecryptedProperty(server, "db_host");
        }
        throw new TdmDbDriverException(dbType);
    }

    private String getDecryptedProperty(Server server, String key) {
        return this.getDecryptIfEncrypted(server.getProperty(key));
    }

    private String getDecryptIfEncrypted(String var) {
        try {
            return this.decryptor.decryptIfEncrypted(var);
        }
        catch (AtpDecryptException e) {
            log.error(String.format("Decrypt is failed for: %s", var), (Throwable)e);
            throw new TdmDbDecryptException(var);
        }
    }
}

