/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.repo.impl.extractors;

import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.NotNull;
import org.qubership.atp.tdm.exceptions.internal.TdmGetTableException;
import org.qubership.atp.tdm.model.ExportFileType;
import org.qubership.atp.tdm.model.table.TestDataType;
import org.qubership.atp.tdm.model.table.column.TestDataTableColumn;
import org.qubership.atp.tdm.service.ColumnService;
import org.qubership.atp.tdm.utils.TestDataTableConvertor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;

public class TestDataTableAsFileExtractor
implements ResultSetExtractor<File> {
    private static final Logger log = LoggerFactory.getLogger(TestDataTableAsFileExtractor.class);
    private final ColumnService columnService;
    private String tableName;
    private ExportFileType fileType;

    TestDataTableAsFileExtractor(@Nonnull ColumnService columnService, @Nonnull String tableName, @Nonnull ExportFileType fileType) {
        this.columnService = columnService;
        this.tableName = tableName;
        this.fileType = fileType;
    }

    public File extractData(@NotNull ResultSet resultSet) throws SQLException, DataAccessException {
        List<TestDataTableColumn> columns = this.columnService.extractColumns(this.tableName, TestDataType.ALL, resultSet);
        try {
            if (ExportFileType.EXCEL.equals((Object)this.fileType)) {
                return TestDataTableConvertor.convertTableToExcelFile(this.tableName, columns, resultSet);
            }
            return TestDataTableConvertor.convertTableToCsvFile(this.tableName, columns, resultSet);
        }
        catch (IOException e) {
            log.error(String.format("Error while getting table in %s format.", this.fileType.name()), (Throwable)e);
            throw new TdmGetTableException(this.fileType.name());
        }
    }
}

