/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.repo.impl.extractors;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.atp.tdm.model.DateFormatter;
import org.qubership.atp.tdm.model.table.TestDataTable;
import org.qubership.atp.tdm.model.table.TestDataTableOrder;
import org.qubership.atp.tdm.model.table.TestDataType;
import org.qubership.atp.tdm.model.table.column.TestDataTableColumn;
import org.qubership.atp.tdm.service.ColumnService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;

public class TestDataTableExtractor
implements ResultSetExtractor<TestDataTable> {
    private static final Logger log = LoggerFactory.getLogger(TestDataTableExtractor.class);
    private final ColumnService columnService;
    private final JdbcTemplate jdbcTemplate;
    private final String tableName;
    private final String countQuery;
    private TestDataType testDataType;
    private TestDataTableOrder testDataTableOrder;

    TestDataTableExtractor(@Nonnull ColumnService columnService, @Nonnull JdbcTemplate jdbcTemplate, @Nonnull String tableName, @Nonnull String countQuery, @Nonnull TestDataType testDataType, @Nullable TestDataTableOrder testDataTableOrder) {
        this(columnService, jdbcTemplate, tableName, countQuery);
        this.testDataType = testDataType;
        this.testDataTableOrder = testDataTableOrder;
    }

    TestDataTableExtractor(@Nonnull ColumnService columnService, @Nonnull JdbcTemplate jdbcTemplate, @Nonnull String tableName, @Nonnull String countQuery) {
        this.columnService = columnService;
        this.jdbcTemplate = jdbcTemplate;
        this.tableName = tableName;
        this.countQuery = countQuery;
    }

    public TestDataTable extractData(@Nonnull ResultSet resultSet) throws SQLException, DataAccessException {
        log.debug("ExtractData Start");
        TestDataTable testDataTable = new TestDataTable();
        List<TestDataTableColumn> columns = this.getColumns(resultSet, this.testDataType, this.testDataTableOrder);
        testDataTable.setColumns(columns);
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        while (resultSet.next()) {
            HashMap<String, Object> row = new HashMap<String, Object>();
            for (TestDataTableColumn column : columns) {
                String columnName = column.getIdentity().getColumnName();
                row.put(columnName, this.formatColumn(resultSet.getObject(columnName)));
            }
            rows.add(row);
        }
        testDataTable.setData(rows);
        testDataTable.setRecords(this.count(this.countQuery));
        log.debug("ExtractData Finish");
        return testDataTable;
    }

    private List<TestDataTableColumn> getColumns(@Nonnull ResultSet resultSet, @Nonnull TestDataType testDataType, @Nonnull TestDataTableOrder testDataTableOrder) throws SQLException {
        return this.columnService.extractColumns(this.tableName, testDataType, resultSet, testDataTableOrder);
    }

    private Object formatColumn(Object value) {
        if (value instanceof Timestamp) {
            value = DateFormatter.DB_DATE_FORMATTER.format(new Timestamp(((Timestamp)value).getTime()));
            return value;
        }
        return value;
    }

    private Integer count(@Nonnull String query) {
        try {
            log.debug("count start");
            Integer i = (Integer)this.jdbcTemplate.queryForObject(query, Integer.class);
            log.debug("count finish");
            return i;
        }
        catch (Exception e) {
            return 0;
        }
    }
}

