/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.repo.impl.extractors;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.qubership.atp.tdm.model.DateFormatter;
import org.qubership.atp.tdm.model.table.TestDataTable;
import org.qubership.atp.tdm.model.table.TestDataType;
import org.qubership.atp.tdm.model.table.column.TestDataTableColumn;
import org.qubership.atp.tdm.service.ColumnService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;

public class TestDataTableMultipleExtractor
implements ResultSetExtractor<TestDataTable> {
    private static final Logger log = LoggerFactory.getLogger(TestDataTableMultipleExtractor.class);
    private final ColumnService columnService;
    private final String tableName;
    private TestDataType testDataType;

    TestDataTableMultipleExtractor(@Nonnull ColumnService columnService, @Nonnull String tableName, @Nonnull TestDataType testDataType) {
        this.columnService = columnService;
        this.tableName = tableName;
        this.testDataType = testDataType;
    }

    public TestDataTable extractData(@Nonnull ResultSet resultSet) throws SQLException, DataAccessException {
        log.debug("ExtractData Start");
        TestDataTable testDataTable = new TestDataTable();
        List<TestDataTableColumn> columns = this.getColumns(resultSet, this.testDataType);
        testDataTable.setColumns(columns);
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        while (resultSet.next()) {
            HashMap<String, Object> row = new HashMap<String, Object>();
            for (TestDataTableColumn column : columns) {
                String columnName = column.getIdentity().getColumnName();
                row.put(columnName, this.formatColumn(resultSet.getObject(columnName)));
            }
            rows.add(row);
        }
        testDataTable.setData(rows);
        log.debug("ExtractData Finish");
        return testDataTable;
    }

    private List<TestDataTableColumn> getColumns(@Nonnull ResultSet resultSet, @Nonnull TestDataType testDataType) throws SQLException {
        return this.columnService.extractColumnsMultiple(this.tableName, testDataType, resultSet);
    }

    private Object formatColumn(Object value) {
        if (value instanceof Timestamp) {
            value = DateFormatter.DB_DATE_FORMATTER.format(new Timestamp(((Timestamp)value).getTime()));
        }
        return value;
    }
}

