/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.repo.impl.loader;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.qubership.atp.tdm.model.table.TestDataTable;
import org.qubership.atp.tdm.model.table.column.TestDataTableColumn;
import org.qubership.atp.tdm.model.table.column.TestDataTableColumnIdentity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.dao.DataAccessException;

public class TestDataSqlLoader {
    private static final Logger log = LoggerFactory.getLogger(TestDataSqlLoader.class);
    private final Map<Integer, String> columns = new HashMap<Integer, String>();
    private final Connection connection;
    private final String sqlQuery;
    private final Integer queryTimeout;

    public TestDataSqlLoader(@Nonnull Connection connection, @Nonnull String sqlQuery, @Nonnull Integer queryTimeout) {
        this.connection = connection;
        this.sqlQuery = sqlQuery;
        this.queryTimeout = queryTimeout;
    }

    public TestDataTable process() throws Exception {
        log.info("Executing query: {}", (Object)this.sqlQuery);
        try (CallableStatement statement = this.connection.prepareCall(this.sqlQuery);){
            TestDataTable testDataTable;
            block12: {
                ExecutorService executorService = Executors.newSingleThreadExecutor();
                Map mdcContext = MDC.getCopyOfContextMap();
                ResultSet rs = executorService.submit(() -> {
                    MdcUtils.setContextMap((Map)mdcContext);
                    return statement.executeQuery();
                }).get(this.queryTimeout.intValue(), TimeUnit.SECONDS);
                try {
                    testDataTable = this.extractData(rs);
                    if (rs == null) break block12;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return testDataTable;
        }
    }

    private TestDataTable extractData(ResultSet resultSet) throws SQLException, DataAccessException {
        log.info("Extracting data from result set...");
        TestDataTable testDataTable = new TestDataTable();
        ResultSetMetaData metaData = resultSet.getMetaData();
        int colCount = metaData.getColumnCount();
        for (int c2 = 1; c2 <= colCount; ++c2) {
            String columnName = metaData.getColumnName(c2);
            this.columns.put(c2, columnName);
        }
        testDataTable.setColumns(this.columns.values().stream().map(c -> new TestDataTableColumn(new TestDataTableColumnIdentity("", (String)c))).collect(Collectors.toList()));
        log.info("Processing rows...");
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        while (resultSet.next()) {
            HashMap<String, Object> row = new HashMap<String, Object>();
            for (int key : this.columns.keySet()) {
                String columnName = this.columns.get(key);
                row.put(columnName, resultSet.getObject(columnName));
            }
            rows.add(row);
        }
        testDataTable.setData(rows);
        log.info("Extracting finished.");
        return testDataTable;
    }
}

