/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.service.impl;

import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.GroupMatcher;
import org.qubership.atp.tdm.service.SchedulerService;
import org.qubership.atp.tdm.utils.scheduler.ScheduleConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SchedulerServiceImpl
implements SchedulerService {
    private static final Logger log = LoggerFactory.getLogger(SchedulerServiceImpl.class);
    private final Scheduler scheduler;

    @Autowired
    public SchedulerServiceImpl(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    @Override
    public void reschedule(@Nonnull JobDetail job, @Nonnull ScheduleConfig config, @Nonnull String group, @Nonnull String identityName) {
        Trigger trigger = Optional.of(TriggerBuilder.newTrigger().withIdentity(identityName, group)).map(builder -> config.isScheduled() ? builder.withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)config.getSchedule())) : builder).get().build();
        this.reschedule(job, trigger, config.isScheduled());
        log.info("Job with id [" + identityName + "] and group [" + group + "] was scheduled");
    }

    @Override
    public void reschedule(@Nonnull JobDetail job, @Nonnull ScheduleConfig config, @Nonnull String group) {
        this.reschedule(job, config, group, config.getId().toString());
    }

    @Override
    @Transactional
    public void reschedule(@Nonnull JobDetail job, @Nonnull Trigger trigger, boolean turnOn) {
        if (this.schedulerIsEnabled()) {
            try {
                if (!this.scheduler.isStarted() || this.scheduler.isInStandbyMode()) {
                    this.scheduler.start();
                }
                if (this.scheduler.checkExists(job.getKey())) {
                    if (turnOn) {
                        this.scheduler.rescheduleJob(trigger.getKey(), trigger);
                    } else {
                        this.scheduler.deleteJob(job.getKey());
                        Set triggers = this.scheduler.getTriggerKeys(GroupMatcher.anyGroup());
                        Predicate<TriggerKey> futureTrigger = key -> {
                            try {
                                return this.scheduler.getTrigger(key).mayFireAgain();
                            }
                            catch (SchedulerException e) {
                                return true;
                            }
                        };
                        if (triggers.isEmpty() || triggers.stream().noneMatch(futureTrigger)) {
                            this.scheduler.standby();
                        }
                    }
                } else if (turnOn) {
                    this.scheduler.scheduleJob(job, trigger);
                }
            }
            catch (SchedulerException e) {
                log.error("An error occurred while rescheduling a job", (Throwable)e);
            }
        } else {
            log.warn("Cannot reschedule a job since scheduler isn't serviceable");
        }
    }

    @Override
    @Transactional
    public void deleteJob(@Nonnull JobKey jobKey) {
        if (this.schedulerIsEnabled()) {
            try {
                if (this.scheduler.checkExists(jobKey)) {
                    this.scheduler.deleteJob(jobKey);
                }
            }
            catch (SchedulerException e) {
                log.error("An error occurred while removing a job", (Throwable)e);
            }
        } else {
            log.warn("Cannot remove a job since scheduler isn't serviceable");
        }
    }

    @Override
    public boolean checkExists(@Nonnull JobKey jobKey) {
        if (this.schedulerIsEnabled()) {
            try {
                return this.scheduler.checkExists(jobKey);
            }
            catch (SchedulerException e) {
                log.error("An error occurred while checking a job", (Throwable)e);
            }
        } else {
            log.warn("Cannot check a job since scheduler isn't serviceable");
        }
        return false;
    }

    private boolean schedulerIsEnabled() {
        try {
            return this.scheduler != null && this.scheduler.isStarted();
        }
        catch (SchedulerException e) {
            log.error("Error while scheduler check", (Throwable)e);
            return false;
        }
    }
}

