/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.service.impl;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.NotNull;
import org.qubership.atp.tdm.model.TestDataTableCatalog;
import org.qubership.atp.tdm.model.table.TestDataFlagsTable;
import org.qubership.atp.tdm.repo.CatalogRepository;
import org.qubership.atp.tdm.repo.TestDataColumnFlagsRepository;
import org.qubership.atp.tdm.service.TestDataFlagsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class TestDataFlagsServiceImpl
implements TestDataFlagsService {
    private static final Logger log = LoggerFactory.getLogger(TestDataFlagsServiceImpl.class);
    private final TestDataColumnFlagsRepository testDataColumnFlagsRepository;
    private final CatalogRepository catalogRepository;

    @Lazy
    @Autowired
    public TestDataFlagsServiceImpl(@Nonnull TestDataColumnFlagsRepository testDataColumnFlagsRepository, @Nonnull CatalogRepository catalogRepository) {
        this.testDataColumnFlagsRepository = testDataColumnFlagsRepository;
        this.catalogRepository = catalogRepository;
    }

    @Override
    public void setValidateUnoccupiedResourcesFlag(@NotNull String tableName, @NotNull Boolean validateUnoccupiedResources, @Nonnull Boolean isAll) {
        if (isAll.booleanValue()) {
            this.bulkSetValidateUnoccupiedResourcesFlag(tableName, validateUnoccupiedResources);
        } else {
            TestDataFlagsTable testDataFlagsTable = new TestDataFlagsTable(tableName, validateUnoccupiedResources);
            this.testDataColumnFlagsRepository.save(testDataFlagsTable);
            log.info("Flag {} has been installed for table: {}", (Object)validateUnoccupiedResources, (Object)tableName);
        }
    }

    private void bulkSetValidateUnoccupiedResourcesFlag(@NotNull String tableName, @NotNull Boolean validateUnoccupiedResources) {
        log.info("Setting bulk Validate Unoccupied Resources Flag.");
        TestDataTableCatalog testDataCatalog = this.catalogRepository.findByTableName(tableName);
        List<TestDataFlagsTable> flagsTableList = this.catalogRepository.findAllByProjectIdAndTableTitle(testDataCatalog.getProjectId(), testDataCatalog.getTableTitle()).stream().map(catalog -> new TestDataFlagsTable(catalog.getTableName(), validateUnoccupiedResources)).collect(Collectors.toList());
        flagsTableList.forEach(testDataFlagsTable -> {
            this.testDataColumnFlagsRepository.save(testDataFlagsTable);
            log.info("Flag {} has been installed for table: {}", (Object)validateUnoccupiedResources, (Object)testDataFlagsTable.getTableName());
        });
    }

    @Override
    public TestDataFlagsTable getValidateUnoccupiedResourcesFlag(@NotNull String tableName) {
        return this.testDataColumnFlagsRepository.findRowByTableName(tableName);
    }

    @Override
    public void deleteRowByTableName(@Nonnull String tableName) {
        this.testDataColumnFlagsRepository.deleteRowByTableName(tableName);
    }
}

