/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.service.impl;

import java.io.File;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ObjectUtils;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.qubership.atp.common.lock.LockManager;
import org.qubership.atp.crypt.api.Decryptor;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.qubership.atp.tdm.env.configurator.model.AbstractConfiguratorModel;
import org.qubership.atp.tdm.env.configurator.model.Environment;
import org.qubership.atp.tdm.env.configurator.model.Project;
import org.qubership.atp.tdm.env.configurator.model.Server;
import org.qubership.atp.tdm.env.configurator.model.System;
import org.qubership.atp.tdm.env.configurator.service.EnvironmentsService;
import org.qubership.atp.tdm.exceptions.internal.TdmEnvironmentSystemException;
import org.qubership.atp.tdm.exceptions.internal.TdmRetrieveTestDataException;
import org.qubership.atp.tdm.exceptions.internal.TdmSearchDataByCriteriaException;
import org.qubership.atp.tdm.exceptions.internal.TdmSearchTableException;
import org.qubership.atp.tdm.mdc.MdcField;
import org.qubership.atp.tdm.mdc.TdmMdcHelper;
import org.qubership.atp.tdm.model.ColumnValues;
import org.qubership.atp.tdm.model.DropResults;
import org.qubership.atp.tdm.model.EnvsList;
import org.qubership.atp.tdm.model.ImportTestDataStatistic;
import org.qubership.atp.tdm.model.TestDataOccupyStatistic;
import org.qubership.atp.tdm.model.TestDataTableCatalog;
import org.qubership.atp.tdm.model.TestDataTableImportInfo;
import org.qubership.atp.tdm.model.ei.TdmDataToExport;
import org.qubership.atp.tdm.model.scheduler.CleanRemovingHistoryJob;
import org.qubership.atp.tdm.model.scheduler.TableCleanerJob;
import org.qubership.atp.tdm.model.statistics.DateStatistics;
import org.qubership.atp.tdm.model.statistics.DateStatisticsItem;
import org.qubership.atp.tdm.model.statistics.StatisticsItem;
import org.qubership.atp.tdm.model.table.TableColumnValues;
import org.qubership.atp.tdm.model.table.TestDataFlagsTable;
import org.qubership.atp.tdm.model.table.TestDataTable;
import org.qubership.atp.tdm.model.table.TestDataTableFilter;
import org.qubership.atp.tdm.model.table.TestDataTableOrder;
import org.qubership.atp.tdm.model.table.conditions.search.SearchConditionType;
import org.qubership.atp.tdm.repo.CatalogRepository;
import org.qubership.atp.tdm.repo.ImportInfoRepository;
import org.qubership.atp.tdm.repo.ProjectInformationRepository;
import org.qubership.atp.tdm.repo.TestDataTableRepository;
import org.qubership.atp.tdm.repo.impl.SystemColumns;
import org.qubership.atp.tdm.service.CleanupService;
import org.qubership.atp.tdm.service.ColumnService;
import org.qubership.atp.tdm.service.DataRefreshService;
import org.qubership.atp.tdm.service.SchedulerService;
import org.qubership.atp.tdm.service.StatisticsService;
import org.qubership.atp.tdm.service.TestDataFlagsService;
import org.qubership.atp.tdm.service.TestDataService;
import org.qubership.atp.tdm.utils.DataUtils;
import org.qubership.atp.tdm.utils.DateFormatters;
import org.qubership.atp.tdm.utils.TestDataTableConvertor;
import org.qubership.atp.tdm.utils.TestDataUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class TestDataServiceImpl
implements TestDataService {
    private static final Logger log = LoggerFactory.getLogger(TestDataServiceImpl.class);
    private static final List<String> INTERNAL_COLUMNS = new ArrayList<String>(Arrays.asList("OCCUPIED_DATE", "ROW_ID", "SELECTED", "OCCUPIED_BY"));
    private static final String DB_CONNECTION_NAME = "DB";
    private static final String SCHED_GROUP = "REMOVING_TABLE";
    private static final Pattern COLUMN_PATTERN = Pattern.compile("\\$\\{'([^']+)'}");
    private final String removingCron;
    private final String historyCleanerCron;
    private final Integer defaultQueryTimeout;
    private final CatalogRepository catalogRepository;
    private final TestDataTableRepository testDataTableRepository;
    private final EnvironmentsService environmentsService;
    private final CleanupService cleanupService;
    private final StatisticsService statisticsService;
    private final DataRefreshService dataRefreshService;
    private final ColumnService columnService;
    private final ImportInfoRepository importInfoRepository;
    private final TestDataFlagsService testDataFlagsService;
    private final ProjectInformationRepository projectInformationRepository;
    private final LockManager lockManager;
    private final TdmMdcHelper tdmMdcHelper;
    private final SchedulerService schedulerService;

    @Autowired
    public TestDataServiceImpl(@Nonnull CatalogRepository catalogRepository, @Nonnull TestDataTableRepository testDataTableRepository, @Nonnull EnvironmentsService environmentsService, @Nonnull CleanupService cleanupService, @Nonnull StatisticsService statisticsService, @Nonnull DataRefreshService dataRefreshService, @Nonnull ColumnService columnService, @Nonnull ImportInfoRepository importInfoRepository, @Nonnull Decryptor decryptor, @Nonnull TestDataFlagsService testDataFlagsService, @Nonnull ProjectInformationRepository projectInformationRepository, @Nonnull LockManager lockManager, @Nonnull SchedulerService schedulerService, @Value(value="${external.query.default.timeout:1800}") Integer defaultQueryTimeout, @Value(value="${table.expiration.cron}") String removingCron, @Value(value="${clean.removed.tables.history.cron}") String historyCleanerCron, TdmMdcHelper helper) {
        this.catalogRepository = catalogRepository;
        this.testDataTableRepository = testDataTableRepository;
        this.environmentsService = environmentsService;
        this.cleanupService = cleanupService;
        this.statisticsService = statisticsService;
        this.dataRefreshService = dataRefreshService;
        this.columnService = columnService;
        this.importInfoRepository = importInfoRepository;
        this.testDataFlagsService = testDataFlagsService;
        this.projectInformationRepository = projectInformationRepository;
        this.lockManager = lockManager;
        this.defaultQueryTimeout = defaultQueryTimeout;
        this.tdmMdcHelper = helper;
        this.schedulerService = schedulerService;
        this.removingCron = removingCron;
        this.historyCleanerCron = historyCleanerCron;
    }

    @Override
    public List<TestDataTableCatalog> getTestDataTablesCatalog(@Nonnull UUID projectId, @Nullable UUID systemId) {
        List<TestDataTableCatalog> tableCatalogs = systemId != null ? this.catalogRepository.findAllByProjectIdAndSystemId(projectId, systemId) : this.catalogRepository.findAllByProjectId(projectId);
        return this.fillImportInformation(tableCatalogs);
    }

    private List<TestDataTableCatalog> fillImportInformation(List<TestDataTableCatalog> tableCatalogs) {
        ArrayList<TestDataTableCatalog> testDataTableCatalogs = new ArrayList<TestDataTableCatalog>();
        tableCatalogs.forEach(tableCatalog -> {
            TestDataTableImportInfo importInfo = this.importInfoRepository.findByTableName(tableCatalog.getTableName());
            if (Objects.nonNull(importInfo)) {
                tableCatalog.setImportQuery(importInfo.getTableQuery());
                tableCatalog.setQueryTimeout(importInfo.getQueryTimeout());
            }
            testDataTableCatalogs.add((TestDataTableCatalog)tableCatalog);
        });
        return testDataTableCatalogs;
    }

    @Override
    public TdmDataToExport tablesToExport(@Nonnull UUID projectId) {
        List<String> tableIds = this.catalogRepository.findAllByProjectId(projectId).stream().map(TestDataTableCatalog::getTableName).collect(Collectors.toList());
        return new TdmDataToExport(projectId, tableIds);
    }

    @Override
    public Map<String, String> tablesToExportByEnvironment(@Nonnull UUID projectId, @Nonnull UUID environmentId) {
        return this.catalogRepository.findAllByProjectIdAndEnvironmentId(projectId, environmentId).stream().collect(Collectors.toMap(TestDataTableCatalog::getTableName, TestDataTableCatalog::getTableTitle));
    }

    @Override
    public TestDataTable getTestData(@Nonnull String tableName) {
        return this.testDataTableRepository.getTestData(false, tableName, null, null, null, null, false);
    }

    @Override
    public TestDataTable getTestData(@Nonnull String tableName, @Nullable Integer offset, @Nullable Integer limit, @Nullable List<TestDataTableFilter> filters, @Nullable TestDataTableOrder testDataTableOrder, @Nonnull Boolean isOccupied) {
        this.testDataTableRepository.updateLastUsage(tableName);
        return this.testDataTableRepository.getTestData(isOccupied, tableName, offset, limit, filters, testDataTableOrder, false);
    }

    @Override
    public TestDataTable getTestData(@Nonnull String tableName, @Nonnull List<String> columnNames, @Nullable List<TestDataTableFilter> filters) {
        return this.testDataTableRepository.getTestData(tableName, columnNames, filters);
    }

    @Override
    public List<ImportTestDataStatistic> importExcelTestData(@Nonnull UUID projectId, @Nullable UUID environmentId, @Nullable UUID systemId, @Nonnull String tableTitle, @Nonnull Boolean runSqlScriptAfterExcelImport, @Nonnull MultipartFile file) {
        ImportTestDataStatistic statistic;
        log.info("Excel import started. Table title [{}]", (Object)tableTitle);
        if (Objects.isNull(environmentId) || Objects.isNull(systemId)) {
            throw new TdmEnvironmentSystemException();
        }
        TestDataTableCatalog tableCatalog = this.catalogRepository.findByProjectIdAndSystemIdAndTableTitle(projectId, systemId, tableTitle);
        String tableName = "";
        if (Objects.nonNull(tableCatalog)) {
            tableName = tableCatalog.getTableName();
            statistic = this.testDataTableRepository.importExcelTestData(tableCatalog.getTableName(), true, file);
            this.testDataTableRepository.updateLastUsage(tableCatalog.getTableName());
        } else {
            tableName = TestDataTableConvertor.generateTestDataTableName();
            statistic = this.testDataTableRepository.importExcelTestData(tableName, false, file);
            this.testDataTableRepository.saveTestDataTableCatalog(tableName, tableTitle, projectId, systemId, environmentId);
            this.testDataFlagsService.setValidateUnoccupiedResourcesFlag(tableName, false, false);
            this.testDataTableRepository.updateLastUsage(tableName);
            if (Objects.nonNull(systemId)) {
                this.columnService.setUpLinks(projectId, systemId, tableTitle, tableName);
            }
        }
        if (runSqlScriptAfterExcelImport.booleanValue()) {
            if (Objects.nonNull(environmentId) && Objects.nonNull(systemId)) {
                this.updateImportedData(projectId, environmentId, systemId, tableName);
            } else {
                String message = "Unable to update table [" + tableName + "]. System or environment not specified.";
                log.info(message);
                statistic = new ImportTestDataStatistic("", message, 0);
            }
        }
        log.info("Excel import successfully finished.");
        return Collections.singletonList(statistic);
    }

    private ImportTestDataStatistic updateImportedData(@Nonnull UUID projectId, @Nullable UUID environmentId, @Nullable UUID systemId, @Nonnull String tableName) {
        TestDataTableImportInfo importInfo = this.importInfoRepository.findByTableName(tableName);
        ImportTestDataStatistic statistic = new ImportTestDataStatistic();
        if (Objects.nonNull(importInfo.getTableQuery())) {
            Integer queryTimeout = (Integer)ObjectUtils.defaultIfNull((Object)importInfo.getQueryTimeout(), (Object)this.defaultQueryTimeout);
            statistic = this.updateTestDataBySql(projectId, environmentId, systemId, tableName, importInfo.getTableQuery(), queryTimeout);
        }
        return statistic;
    }

    @Override
    public List<ImportTestDataStatistic> importSqlTestData(@Nonnull UUID projectId, @Nonnull List<UUID> environmentsIds, @Nonnull String systemName, @Nonnull String tableTitle, @Nonnull String query, @Nonnull Integer queryTimeout) {
        log.info("SQL import started. Table title: [{}]", (Object)tableTitle);
        ArrayList<ImportTestDataStatistic> statistics = new ArrayList<ImportTestDataStatistic>();
        for (UUID environmentId : environmentsIds) {
            MdcUtils.put((String)MdcField.ENVIRONMENT_ID.toString(), (UUID)environmentId);
            log.info("Start SQL import for environment with id: " + environmentId);
            ImportTestDataStatistic statistic = this.importSqlTestData(projectId, environmentId, systemName, tableTitle, query, queryTimeout);
            statistics.add(statistic);
            MDC.remove((String)MdcField.ENVIRONMENT_ID.toString());
        }
        log.info("SQL import successfully finished.");
        return statistics;
    }

    private ImportTestDataStatistic importSqlTestData(@Nonnull UUID projectId, @Nonnull UUID environmentId, @Nonnull String systemName, @Nonnull String tableTitle, @Nonnull String query, @Nonnull Integer queryTimeout) {
        System system;
        String envName;
        ImportTestDataStatistic statistic = new ImportTestDataStatistic();
        try {
            envName = this.environmentsService.getEnvNameById(environmentId);
        }
        catch (Exception e) {
            String message = String.format("Environment: [%s] was not found.", environmentId);
            log.error(message);
            statistic.setError(message);
            statistic.setEnvName(environmentId.toString());
            return statistic;
        }
        try {
            system = this.environmentsService.getFullSystemByName(projectId, environmentId, systemName);
        }
        catch (Exception e) {
            String message = String.format("System with name[%s] for environment[%s] was not found.", systemName, environmentId);
            log.error(message);
            statistic.setError(message);
            statistic.setEnvName(envName);
            return statistic;
        }
        try {
            UUID systemId = system.getId();
            Server server = system.getServer(DB_CONNECTION_NAME);
            TestDataTableCatalog tableCatalog = this.catalogRepository.findByProjectIdAndSystemIdAndTableTitle(projectId, systemId, tableTitle);
            if (tableCatalog != null) {
                statistic = this.testDataTableRepository.importSqlTestData(tableCatalog.getTableName(), true, query, queryTimeout, server);
                this.importInfoRepository.save(new TestDataTableImportInfo(tableCatalog.getTableName(), query, queryTimeout));
                this.testDataTableRepository.updateLastUsage(tableCatalog.getTableName());
            } else {
                String tableName = TestDataTableConvertor.generateTestDataTableName();
                statistic = this.testDataTableRepository.importSqlTestData(tableName, false, query, queryTimeout, server);
                this.testDataTableRepository.saveTestDataTableCatalog(tableName, tableTitle, projectId, systemId, environmentId);
                this.testDataTableRepository.updateLastUsage(tableName);
                this.testDataFlagsService.setValidateUnoccupiedResourcesFlag(tableName, false, false);
                this.importInfoRepository.save(new TestDataTableImportInfo(tableName, query, queryTimeout));
                this.columnService.setUpLinks(projectId, systemId, tableTitle, tableName);
            }
        }
        catch (Exception e) {
            statistic.setError(e.getMessage());
        }
        statistic.setEnvName(envName);
        return statistic;
    }

    @Override
    public void occupyTestData(@Nonnull String tableName, @Nonnull String occupiedBy, @Nonnull List<UUID> rows) {
        String date = this.testDataTableRepository.occupyTestData(tableName, occupiedBy, rows);
        TestDataTableCatalog catalog = this.catalogRepository.findByTableName(tableName);
        this.testDataTableRepository.updateLastUsage(tableName);
        this.tdmMdcHelper.putConfigFields(catalog);
        LocalDateTime occupyTime = LocalDateTime.parse(date, DateFormatters.FULL_DATE_FORMATTER);
        rows.forEach(row -> {
            LocalDateTime createdTime = LocalDateTime.parse(String.valueOf(this.getTableRow(tableName, "ROW_ID", row.toString(), true).get("CREATED_WHEN")), DateFormatters.FULL_DATE_FORMATTER);
            this.statisticsService.saveOccupyStatistic(new TestDataOccupyStatistic((UUID)row, catalog.getProjectId(), catalog.getSystemId(), tableName, catalog.getTableTitle(), occupiedBy, occupyTime, createdTime));
        });
    }

    @Override
    public void releaseTestData(@Nonnull String tableName, @Nonnull List<UUID> rows) {
        this.testDataTableRepository.releaseTestData(tableName, rows);
        this.statisticsService.deleteAllOccupyStatisticByRowId(rows);
    }

    @Override
    public DropResults deleteTestData(@Nonnull String tableName) {
        this.lockManager.executeWithLockWithUniqueLockKey("delete test data: " + tableName, () -> {
            TestDataTableCatalog catalog = this.catalogRepository.findByTableName(tableName);
            UUID configId = catalog.getRefreshConfigId();
            if (Objects.nonNull(configId)) {
                this.dataRefreshService.removeJob(configId);
            }
            try {
                this.statisticsService.fillCreatedWhenStatistics(tableName, catalog);
            }
            catch (BadSqlGrammarException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            this.catalogRepository.deleteByTableName(tableName);
            this.testDataTableRepository.dropTable(tableName);
            this.cleanupService.removeUnused();
            this.statisticsService.removeUnused();
            this.testDataFlagsService.deleteRowByTableName(tableName);
            this.columnService.deleteByTableName(tableName);
            this.importInfoRepository.deleteByTableName(tableName);
        });
        return new DropResults(tableName);
    }

    @Override
    public DropResults truncateDataInTable(@Nonnull String tableName, @Nonnull UUID projectId, UUID systemId) {
        this.lockManager.executeWithLockWithUniqueLockKey("truncate Data In Table : " + tableName, () -> {
            TestDataTableCatalog catalog = this.getTestDataTablesCatalog(projectId, systemId).stream().filter(x -> x.getTableName().equals(tableName)).findFirst().orElseThrow(() -> new IllegalArgumentException(tableName + " table not found."));
            this.tdmMdcHelper.putConfigFields(catalog);
            this.testDataTableRepository.truncateTable(catalog.getTableName());
            this.testDataTableRepository.updateLastUsage(catalog.getTableName());
            this.tdmMdcHelper.removeConfigFields();
        });
        return new DropResults(tableName);
    }

    @Override
    public void deleteTestDataTableRows(@Nonnull String tableName, @Nonnull List<UUID> rows) {
        this.lockManager.executeWithLockWithUniqueLockKey("deleteTestDataTableRows: " + tableName, () -> {
            TestDataTableCatalog catalog = this.catalogRepository.findByTableName(tableName);
            this.statisticsService.fillCreatedWhenStatistics(tableName, catalog, rows);
            this.testDataTableRepository.deleteRows(tableName, rows);
            this.testDataTableRepository.updateLastUsage(tableName);
        });
    }

    @Override
    public File getTestDataTableAsExcelFile(@Nonnull String tableName) {
        return this.testDataTableRepository.getTestDataTableAsExcel(tableName, null, null, null);
    }

    @Override
    public File getTestDataTableAsCsvFile(@Nonnull String tableName) {
        return this.testDataTableRepository.getTestDataTableAsCsv(tableName, null, null, null);
    }

    @Override
    public String getPreviewLink(@Nonnull UUID projectId, @Nullable UUID systemId, @Nullable String endpoint, @Nonnull String columnName, @Nullable String tableName, @Nonnull Boolean pickUpFullLinkFromTableCell) {
        if (pickUpFullLinkFromTableCell.booleanValue()) {
            return this.testDataTableRepository.getFirstRecordFromDataStorageTable(tableName, columnName);
        }
        return this.columnService.getColumnLink(projectId, systemId, endpoint);
    }

    @Override
    public EnvsList getTableEnvironments(@Nonnull UUID projectId, @Nonnull String tableTitle) {
        List<TestDataTableCatalog> tableCatalogs = this.catalogRepository.findAllByProjectIdAndTableTitle(projectId, tableTitle);
        List<UUID> environmentIds = tableCatalogs.stream().map(TestDataTableCatalog::getEnvironmentId).distinct().collect(Collectors.toList());
        return new EnvsList(environmentIds);
    }

    @Override
    public void alterOccupiedByColumn() {
        this.testDataTableRepository.alterOccupiedByColumn(this.catalogRepository.findAll().stream().map(TestDataTableCatalog::getTableName).collect(Collectors.toList()));
    }

    @Override
    public void setupColumnLinks(@Nonnull Boolean isAll, @Nonnull UUID projectId, @Nonnull UUID systemId, @Nonnull String tableName, @Nonnull String columnName, @Nonnull String endpoint, @Nonnull Boolean validateUnoccupiedResources, @Nonnull Boolean pickUpFullLinkFromTableCell) {
        this.lockManager.executeWithLockWithUniqueLockKey("set up column links: " + tableName, () -> {
            this.columnService.setupColumnLinks(isAll, projectId, systemId, tableName, columnName, endpoint, pickUpFullLinkFromTableCell);
            this.testDataTableRepository.updateLastUsage(tableName);
            this.testDataFlagsService.setValidateUnoccupiedResourcesFlag(tableName, validateUnoccupiedResources, isAll);
        });
    }

    @Override
    public void deleteProjectFromCatalogue(UUID projectId) {
        this.catalogRepository.findAllByProjectId(projectId).forEach(table -> {
            this.testDataTableRepository.dropTable(table.getTableName());
            this.catalogRepository.delete(table);
            log.info("Links on table '{}' was deleted from catalogue.", (Object)table.getTableName());
        });
        this.projectInformationRepository.deleteById(projectId);
    }

    @Override
    public void alterCreatedWhenColumn() {
        this.testDataTableRepository.alterCreatedWhenColumn(this.catalogRepository.findAll().stream().map(TestDataTableCatalog::getTableName).collect(Collectors.toList()));
    }

    @Override
    public void fillEnvIdColumn() {
        HashMap projects = new HashMap();
        List tablesCatalog = this.catalogRepository.findAll();
        tablesCatalog.forEach(catalog -> {
            log.info(catalog.getTableName() + " " + catalog.getTableTitle());
            Project project = null;
            UUID projectId = catalog.getProjectId();
            if (Objects.nonNull(catalog.getSystemId())) {
                if (projects.containsKey(projectId)) {
                    project = (Project)projects.get(projectId);
                    log.info("Get project from storage by id: {}", (Object)projectId);
                } else {
                    log.info("Load project by id: {} from env service", (Object)projectId);
                    try {
                        project = this.environmentsService.getFullProject(projectId);
                        projects.put(projectId, project);
                    }
                    catch (Exception e) {
                        if (e.getCause().getMessage().contains("not found")) {
                            log.info("Project with id: {} was not loaded.", (Object)projectId);
                            log.info("Delete table: {}", catalog);
                            this.deleteTestData(catalog.getTableName());
                        }
                        log.error("Error loading project by id: {}", (Object)projectId, (Object)e);
                    }
                }
                if (Objects.nonNull(project)) {
                    Optional<Environment> environment = project.getEnvironments().stream().filter(env -> env.getSystems().stream().map(AbstractConfiguratorModel::getId).collect(Collectors.toList()).contains(catalog.getSystemId())).findFirst();
                    environment.ifPresent(rnv -> catalog.setEnvironmentId(rnv.getId()));
                }
            }
        });
        this.catalogRepository.saveAll(tablesCatalog);
    }

    @Override
    public String evaluateQuery(@Nonnull String tableName, @Nonnull String query) {
        this.testDataTableRepository.updateLastUsage(tableName);
        return this.testDataTableRepository.evaluateQuery(tableName, query);
    }

    @Override
    public ColumnValues getColumnDistinctValues(@Nonnull String tableName, @Nonnull String columnName, Boolean occupied) {
        return this.testDataTableRepository.getColumnDistinctValues(tableName, columnName, occupied);
    }

    @Override
    public DateStatistics getTableByCreatedWhen(@Nonnull List<TestDataTableCatalog> catalogList, @Nonnull LocalDate dateFrom, @Nonnull LocalDate dateTo) {
        DateStatistics dateStatistics = new DateStatistics();
        ArrayList<DateStatisticsItem> listStatisticsItems = new ArrayList<DateStatisticsItem>();
        dateStatistics.setDates(DataUtils.getStatisticsInterval(dateFrom, dateTo));
        catalogList.forEach(catalog -> {
            TestDataTable table = this.testDataTableRepository.getTableByCreatedWhen(catalog.getTableName(), dateFrom, dateTo);
            LocalDate iterDate = dateFrom;
            DateStatisticsItem statisticsItem = new DateStatisticsItem(catalog.getTableTitle());
            ArrayList<Long> created = new ArrayList<Long>();
            switch (DataUtils.statisticsInterval) {
                case YEARS: {
                    do {
                        long count = 0L;
                        for (Map<String, Object> row : table.getData()) {
                            LocalDate createdWhen = LocalDateTime.parse(row.get(SystemColumns.CREATED_WHEN.getName()).toString(), DateFormatters.FULL_DATE_FORMATTER).toLocalDate();
                            if (iterDate.getYear() != createdWhen.getYear()) continue;
                            ++count;
                        }
                        created.add(count);
                    } while (!(iterDate = iterDate.plusYears(1L)).isAfter(dateTo));
                    break;
                }
                case WEEKS: {
                    do {
                        long count = 0L;
                        for (Map<String, Object> row : table.getData()) {
                            LocalDate createdWhen = LocalDateTime.parse(row.get(SystemColumns.CREATED_WHEN.getName()).toString(), DateFormatters.FULL_DATE_FORMATTER).toLocalDate();
                            if (iterDate.getYear() != createdWhen.getYear() || iterDate.getMonth() != createdWhen.getMonth() || !createdWhen.isEqual(iterDate) && !createdWhen.isAfter(iterDate) || !createdWhen.isBefore(iterDate.plusWeeks(1L))) continue;
                            ++count;
                        }
                        created.add(count);
                    } while (!(iterDate = iterDate.plusWeeks(1L)).isAfter(dateTo));
                    break;
                }
                case DAYS: {
                    do {
                        long count = 0L;
                        for (Map<String, Object> row : table.getData()) {
                            LocalDate createdWhen = LocalDateTime.parse(row.get(SystemColumns.CREATED_WHEN.getName()).toString(), DateFormatters.FULL_DATE_FORMATTER).toLocalDate();
                            if (iterDate.getYear() != createdWhen.getYear() || iterDate.getMonth() != createdWhen.getMonth() || iterDate.getDayOfMonth() != createdWhen.getDayOfMonth()) continue;
                            ++count;
                        }
                        created.add(count);
                    } while (!(iterDate = iterDate.plusDays(1L)).isAfter(dateTo));
                    break;
                }
                default: {
                    do {
                        long count = 0L;
                        for (Map<String, Object> row : table.getData()) {
                            LocalDate createdWhen = LocalDateTime.parse(row.get(SystemColumns.CREATED_WHEN.getName()).toString(), DateFormatters.FULL_DATE_FORMATTER).toLocalDate();
                            if (iterDate.getYear() != createdWhen.getYear() || iterDate.getMonth() != createdWhen.getMonth()) continue;
                            ++count;
                        }
                        created.add(count);
                    } while (!(iterDate = iterDate.plusMonths(1L)).isAfter(dateTo));
                }
            }
            UUID system = catalog.getSystemId();
            if (system != null) {
                statisticsItem.setSystem(system.toString());
            }
            statisticsItem.setCreated(created);
            listStatisticsItems.add(statisticsItem);
        });
        listStatisticsItems.sort(Comparator.comparing(StatisticsItem::getContext));
        dateStatistics.setItems(listStatisticsItems);
        return dateStatistics;
    }

    @Override
    public Map<String, Object> getTableRow(@Nonnull UUID projectId, @Nullable UUID systemId, @Nonnull String tableTitle, @Nonnull String columnName, @Nonnull String searchValue, boolean occupied) {
        TestDataTable table;
        log.info("Starting search for table {} under project {} and system {}", new Object[]{tableTitle, projectId, systemId});
        TestDataTableCatalog catalog = this.catalogRepository.findByProjectIdAndSystemIdAndTableTitle(projectId, systemId, tableTitle);
        if (Objects.isNull(catalog)) {
            throw new TdmSearchTableException(tableTitle, projectId.toString(), systemId.toString());
        }
        ArrayList<TestDataTableFilter> filters = new ArrayList<TestDataTableFilter>();
        TestDataTableFilter filter = new TestDataTableFilter(columnName, SearchConditionType.EQUALS.toString(), Collections.singletonList(searchValue), true);
        filters.add(filter);
        try {
            table = this.testDataTableRepository.getTestData(occupied, catalog.getTableName(), null, null, filters, null, false);
            this.testDataTableRepository.updateLastUsage(catalog.getTableName());
        }
        catch (Exception e) {
            if (Objects.isNull(systemId)) {
                log.error(String.format("Error while retrieving test data from table %s under project %s.", tableTitle, projectId), (Throwable)e);
                throw new TdmRetrieveTestDataException(tableTitle, projectId.toString());
            }
            log.error(String.format("Error while retrieving test data from table %s under project %s and system %s", tableTitle, projectId, systemId), (Throwable)e);
            throw new TdmRetrieveTestDataException(tableTitle, projectId.toString(), systemId.toString());
        }
        Optional row = table.getData().stream().findFirst();
        if (row.isPresent()) {
            log.info("Successfully retrieved row from table {} under project {} and system {}.", new Object[]{tableTitle, projectId, systemId});
            return (Map)row.get();
        }
        throw new TdmSearchDataByCriteriaException(tableTitle, projectId.toString(), systemId.toString());
    }

    @Override
    public Map<String, Object> getTableRow(@Nonnull String tableName, @Nonnull String columnName, @Nonnull String searchValue, boolean occupied) {
        TestDataTable table;
        log.info("Starting search for table {}", (Object)tableName);
        TestDataTableCatalog catalog = this.catalogRepository.findByTableName(tableName);
        if (Objects.isNull(catalog)) {
            throw new TdmSearchTableException(tableName);
        }
        ArrayList<TestDataTableFilter> filters = new ArrayList<TestDataTableFilter>();
        TestDataTableFilter filter = new TestDataTableFilter(columnName, SearchConditionType.EQUALS.toString(), Collections.singletonList(searchValue), true);
        filters.add(filter);
        try {
            table = this.testDataTableRepository.getTestData(occupied, catalog.getTableName(), null, null, filters, null, false);
        }
        catch (Exception e) {
            log.error(String.format("Error while retrieving test data from table %s", tableName), (Throwable)e);
            throw new TdmRetrieveTestDataException(tableName);
        }
        Optional row = table.getData().stream().findFirst();
        if (row.isPresent()) {
            log.info("Successfully retrieved row from table {}.", (Object)tableName);
            return (Map)row.get();
        }
        throw new TdmSearchDataByCriteriaException(tableName);
    }

    @Override
    public boolean changeTestDataTitle(@Nonnull String tableName, @Nullable String tableTitle) {
        return this.testDataTableRepository.changeTestDataTitle(tableName, tableTitle);
    }

    @Override
    public void alterOccupyStatistic() {
        List tablesCatalog = this.catalogRepository.findAll();
        tablesCatalog.forEach(catalog -> {
            this.tdmMdcHelper.putConfigFields((TestDataTableCatalog)catalog);
            try {
                TestDataTable table = this.testDataTableRepository.getTestData(true, catalog.getTableName(), null, null, null, null, false);
                if (table.getData().size() > 0) {
                    List<Map<String, Object>> rows = table.getData();
                    for (Map<String, Object> row : rows) {
                        log.debug("Processing row #{} from table {}", row.get("ROW_ID"), (Object)catalog.getTableName());
                        if (!Objects.nonNull(row.get("OCCUPIED_BY"))) continue;
                        String dateOccupied = String.valueOf(row.get("OCCUPIED_DATE"));
                        String dateCreated = String.valueOf(row.get("CREATED_WHEN"));
                        LocalDateTime occupyTime = LocalDateTime.parse(dateOccupied, DateFormatters.FULL_DATE_FORMATTER);
                        LocalDateTime createTime = LocalDateTime.parse(dateCreated, DateFormatters.FULL_DATE_FORMATTER);
                        this.statisticsService.saveOccupyStatistic(new TestDataOccupyStatistic(UUID.fromString(row.get("ROW_ID").toString()), catalog.getProjectId(), catalog.getSystemId(), catalog.getTableName(), catalog.getTableTitle(), String.valueOf(row.get("OCCUPIED_BY")), occupyTime, createTime));
                    }
                }
            }
            catch (BadSqlGrammarException e) {
                log.error("Table with name {} does not exist.", (Object)catalog.getTableName());
            }
            finally {
                this.tdmMdcHelper.removeConfigFields();
            }
        });
    }

    @Override
    public ImportTestDataStatistic updateTestDataBySql(@Nonnull UUID projectId, @Nonnull UUID environmentId, @Nonnull UUID systemId, @Nonnull String tableName, @Nonnull String query, @Nonnull Integer queryTimeout) {
        List connections = this.environmentsService.getConnectionsSystemById(systemId);
        TestDataTableImportInfo importInfo = this.importInfoRepository.findByTableName(tableName);
        ImportTestDataStatistic[] statistic = new ImportTestDataStatistic[1];
        this.lockManager.executeWithLockWithUniqueLockKey("update table by sql " + tableName, () -> {
            if (importInfo != null) {
                importInfo.setQueryTimeout(queryTimeout);
                importInfo.setUpdateByQuery(query);
                this.importInfoRepository.save(importInfo);
                this.testDataTableRepository.updateLastUsage(tableName);
            } else {
                this.importInfoRepository.save(new TestDataTableImportInfo(tableName, null, queryTimeout, query));
                this.testDataTableRepository.updateLastUsage(tableName);
            }
            statistic[0] = this.testDataTableRepository.updateTableBySql(tableName, query, queryTimeout, TestDataUtils.getServer(connections, DB_CONNECTION_NAME));
            statistic[0].setEnvName(this.environmentsService.getEnvNameById(environmentId));
        });
        return statistic[0];
    }

    @Override
    public TestDataFlagsTable getUnoccupiedValidationFlagStatus(@Nonnull String tableName) {
        return this.testDataFlagsService.getValidateUnoccupiedResourcesFlag(tableName);
    }

    @Override
    public void resolveDiscrepancyTestDataFlagsTableAndTestDataTableCatalog() {
        this.testDataTableRepository.getTestDataTableCatalogDiscrepancyTestDataFlagsTable().forEach(row -> this.testDataFlagsService.setValidateUnoccupiedResourcesFlag((String)row, false, false));
        this.testDataTableRepository.getTestDataFlagsTableDiscrepancyTestDataTableCatalog().forEach(this.testDataFlagsService::deleteRowByTableName);
    }

    public void schedule() {
        JobDetail cleanerJob = JobBuilder.newJob(TableCleanerJob.class).withIdentity("REMOVING_TABLE_delete_tables").build();
        Trigger cleanerTrigger = Optional.of(TriggerBuilder.newTrigger().withIdentity("REMOVING_TABLE_delete_tables")).map(builder -> builder.withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)this.removingCron))).get().build();
        this.schedulerService.reschedule(cleanerJob, cleanerTrigger, true);
        JobDetail historyCleanerJob = JobBuilder.newJob(CleanRemovingHistoryJob.class).withIdentity("REMOVING_TABLE_clean_history").build();
        Trigger historyCleanerTrigger = Optional.of(TriggerBuilder.newTrigger().withIdentity("REMOVING_TABLE_clean_history")).map(builder -> builder.withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)this.historyCleanerCron))).get().build();
        this.schedulerService.reschedule(historyCleanerJob, historyCleanerTrigger, true);
    }

    @Override
    public List<TableColumnValues> getDistinctTablesColumnValues(@Nonnull UUID systemId, @Nonnull UUID environmentId, @Nonnull String columnName) {
        List<TestDataTableCatalog> tableCatalogs = this.catalogRepository.findAllByEnvironmentIdAndSystemId(environmentId, systemId);
        List<String> tablesWithColumn = this.testDataTableRepository.getTablesBySystemIdAndExistingColumn(systemId, environmentId, columnName);
        ArrayList<TableColumnValues> columnValues = new ArrayList<TableColumnValues>();
        for (String tableName : tablesWithColumn) {
            TableColumnValues columnValue = new TableColumnValues();
            columnValue.setTableName(tableName);
            columnValue.setValues(this.testDataTableRepository.getColumnDistinctValues(tableName, columnName, null).getItems());
            columnValue.setTableTitle(tableCatalogs.stream().filter(table -> table.getTableName().equalsIgnoreCase(tableName)).map(TestDataTableCatalog::getTableTitle).findFirst().orElse(""));
            columnValues.add(columnValue);
        }
        return columnValues;
    }

    @Override
    public List<String> getAllColumnNamesBySystemId(@Nonnull UUID systemId) {
        List<String> allColumnsBySystemId = this.testDataTableRepository.getAllColumnNamesBySystemId(systemId);
        allColumnsBySystemId.removeAll(INTERNAL_COLUMNS);
        return allColumnsBySystemId;
    }
}

