/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.utils;

import java.io.IOException;
import java.nio.file.Path;
import java.time.LocalDate;
import java.time.Period;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.qubership.atp.tdm.exceptions.db.TdmDbCheckColumnNameException;
import org.qubership.atp.tdm.exceptions.db.TdmDbCheckQueryException;
import org.qubership.atp.tdm.exceptions.db.TdmDbCheckTableNameException;
import org.qubership.atp.tdm.model.statistics.StatisticsInterval;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.FileSystemUtils;

public class DataUtils {
    private static final Logger log = LoggerFactory.getLogger(DataUtils.class);
    private static final int UI_SUITABLE_PERIODS = 8;
    private static final int WEEK_LENGTH = 7;
    public static StatisticsInterval statisticsInterval;
    private static final String WEEK_PLACEHOLDER = "w";
    private static final String DAY_PLACEHOLDER = "d";

    public static LocalDate calculateExpiredData(@Nonnull String dateConfig) {
        dateConfig = dateConfig.replaceAll("\\s", "");
        int weekPlace = dateConfig.indexOf(WEEK_PLACEHOLDER);
        int weekCount = 0;
        if (weekPlace != -1) {
            weekCount = Integer.parseInt(dateConfig.substring(0, weekPlace));
        }
        int daysPlace = dateConfig.indexOf(DAY_PLACEHOLDER);
        int daysCount = 0;
        if (daysPlace != -1) {
            daysCount = Integer.parseInt(dateConfig.substring(weekPlace + 1, daysPlace));
        }
        return LocalDate.now().minusWeeks(weekCount).minusDays(daysCount);
    }

    public static List<String> getStatisticsInterval(@Nonnull LocalDate dateFrom, @Nonnull LocalDate dateTo) {
        ArrayList<String> dates = new ArrayList<String>();
        double days = ChronoUnit.DAYS.between(dateFrom, dateTo);
        long weeks = (long)Math.ceil(days / 7.0);
        Period period = Period.between(dateFrom, dateTo);
        if (period.getYears() == 0) {
            if (period.getMonths() == 0 && period.getDays() < 8) {
                for (int i = 0; i <= period.getDays(); ++i) {
                    dates.add(dateFrom.plusDays(i).format(DateTimeFormatter.ofPattern("yyyy-MMM-dd")));
                }
                statisticsInterval = StatisticsInterval.DAYS;
            } else if (weeks < 8L) {
                int i = 1;
                while ((long)i <= weeks) {
                    dates.add(dateFrom.plusWeeks(i - 1).format(DateTimeFormatter.ofPattern("yyyy-MMM-dd")) + " - " + dateFrom.plusWeeks(i).minusDays(1L).format(DateTimeFormatter.ofPattern("yyyy-MMM-dd")));
                    ++i;
                }
                statisticsInterval = StatisticsInterval.WEEKS;
            } else {
                for (int i = 0; i <= period.getMonths(); ++i) {
                    dates.add(dateFrom.plusMonths(i).format(DateTimeFormatter.ofPattern("yyyy-MMM")));
                }
                statisticsInterval = StatisticsInterval.MONTHS;
            }
        } else {
            for (int i = 0; i <= period.getYears(); ++i) {
                dates.add(dateFrom.plusYears(i).format(DateTimeFormatter.ofPattern("yyyy")) + " year");
            }
            statisticsInterval = StatisticsInterval.YEARS;
        }
        return dates;
    }

    public static Map<String, String> generateTimeStampDailyRange(String timeZone) {
        ZoneId zoneId = ZoneId.of(timeZone);
        LocalDate today = LocalDate.now(zoneId);
        String zdtStart = today.atStartOfDay(zoneId).toString().replaceAll("(:[0]{2}[\\[][GMT+]{4}[0-9]{2}:[0-9]{2}[]]$)", "");
        String zdtStop = today.plusDays(1L).atStartOfDay(zoneId).toString().replaceAll("(:[0]{2}[\\[][GMT+]{4}[0-9]{2}:[0-9]{2}[]]$)", "");
        HashMap<String, String> m = new HashMap<String, String>(2, 1.1f);
        m.put("startTimeStamp", zdtStart);
        m.put("endTimeStamp", zdtStop);
        return m;
    }

    public static void deleteFile(Path path) {
        if (path != null) {
            log.debug("delete path {}", (Object)path);
            try {
                FileSystemUtils.deleteRecursively((Path)path);
            }
            catch (IOException var3) {
                log.error("Cannot delete path {} ", (Object)path, (Object)var3);
            }
        }
    }

    public static void checkColumnName(String params) {
        if (params != null && params.contains("\"")) {
            log.error(String.format("Parameter [%s] must not contain the symbol: \"", params));
            throw new TdmDbCheckColumnNameException(params);
        }
    }

    public static void checkTableName(String name) {
        Pattern pattern;
        Matcher matcher;
        if (name != null && !(matcher = (pattern = Pattern.compile("^[a-zA-Z_0-9]+$")).matcher(name)).find()) {
            log.error(String.format("Table name: %s, does not match pattern.", name));
            throw new TdmDbCheckTableNameException(name);
        }
    }

    public static void checkQuery(String query) {
        String[] errorWord;
        if (query != null && Arrays.stream(errorWord = new String[]{"truncate ", "drop ", "delete ", "update ", "alter "}).anyMatch(word -> query.toLowerCase().contains(word.toLowerCase()))) {
            log.error("The request contains prohibited keyword");
            throw new TdmDbCheckQueryException();
        }
    }
}

