/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.websocket.bulkaction;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.qubership.atp.common.lock.LockManager;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.qubership.atp.tdm.env.configurator.model.LazyEnvironment;
import org.qubership.atp.tdm.env.configurator.service.EnvironmentsService;
import org.qubership.atp.tdm.exceptions.websocket.TdmGetEnvironmentNameException;
import org.qubership.atp.tdm.exceptions.websocket.TdmParseRequestException;
import org.qubership.atp.tdm.exceptions.websocket.TdmProcessBulkActionFuturesException;
import org.qubership.atp.tdm.exceptions.websocket.TdmSendMessageException;
import org.qubership.atp.tdm.exceptions.websocket.TdmWriteBulkActionResultsAsStringException;
import org.qubership.atp.tdm.mdc.MdcField;
import org.qubership.atp.tdm.mdc.TdmMdcHelper;
import org.qubership.atp.tdm.model.bulkaction.BulkActionConfig;
import org.qubership.atp.tdm.model.bulkaction.BulkActionContext;
import org.qubership.atp.tdm.model.bulkaction.BulkActionResult;
import org.qubership.atp.tdm.model.mail.bulkaction.AbstractBulkActionMailSender;
import org.qubership.atp.tdm.repo.CatalogRepository;
import org.qubership.atp.tdm.utils.CurrentTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;

public abstract class BulkActionsHandler
extends TextWebSocketHandler {
    private static final Logger log = LoggerFactory.getLogger(BulkActionsHandler.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final int NUMBER_OF_THREADS = 10;
    protected final EnvironmentsService environmentsService;
    private final ExecutorService executorService;
    private final AbstractBulkActionMailSender mailSender;
    private static final String STARTED = "STARTED";
    private static final String NOTHING_FOUND = "NOTHING_FOUND";
    private static final String FINISHED = "FINISHED";
    protected final CatalogRepository catalogRepository;
    protected final CurrentTime currentTime;
    protected final LockManager lockManager;
    protected final TdmMdcHelper mdcHelper;
    @Value(value="${atp.lock.bulk.action.duration.sec}")
    private int bulkActionDuration;

    public BulkActionsHandler(@Qualifier(value="websocket") ExecutorService executorService, @Nonnull CatalogRepository catalogRepository, @Nonnull EnvironmentsService environmentsService, @Nonnull AbstractBulkActionMailSender mailSender, @Nonnull CurrentTime currentTime, @Nonnull LockManager lockManager, @Nonnull TdmMdcHelper mdcHelper) {
        this.executorService = executorService;
        this.catalogRepository = catalogRepository;
        this.environmentsService = environmentsService;
        this.currentTime = currentTime;
        this.mailSender = mailSender;
        this.lockManager = lockManager;
        this.mdcHelper = mdcHelper;
    }

    public void handleTextMessage(WebSocketSession session, TextMessage message) {
        this.executorService.submit(() -> this.tryProcessRequest(session, message));
    }

    public String getEnvName(@Nonnull List<LazyEnvironment> lazyEnvironments, @Nonnull UUID envId) {
        return lazyEnvironments.stream().filter(env -> envId.equals(env.getId())).findFirst().orElseThrow(() -> new TdmGetEnvironmentNameException(envId.toString())).getName();
    }

    private void tryProcessRequest(@Nonnull WebSocketSession session, @Nonnull TextMessage message) {
        try {
            this.processRequest(session, message);
            this.closeSessionAsNormal(session);
        }
        catch (Exception e) {
            log.error("An error occurred while processing the Websocket request. Session: [{}].", (Object)session, (Object)e);
            this.closeSessionAsError(session);
        }
    }

    private void processRequest(@Nonnull WebSocketSession session, @Nonnull TextMessage message) {
        log.info("Websocket request processing started. Session: [{}]. TextMessage: [{}].", (Object)session, (Object)message);
        BulkActionConfig config = this.parseRequest(message);
        log.info("class name : {}", (Object)((Object)((Object)this)).getClass().getName());
        this.lockManager.executeWithLock(session.getUri().toString() + " " + config.getProjectId(), Integer.valueOf(this.bulkActionDuration), () -> {
            MDC.clear();
            MdcUtils.put((String)MdcField.PROJECT_ID.toString(), (UUID)config.getProjectId());
            long processId = this.currentTime.getCurrentTimeMillis();
            this.sendStatusMsg(session, processId, STARTED);
            ExecutorService executor = this.createExecutorService(config.isExecuteInParallel());
            List lazyEnvironments = this.environmentsService.getLazyEnvironmentsShort(config.getProjectId());
            List<Future<BulkActionResult>> futures = this.runBulkAction(session, executor, lazyEnvironments, config, processId);
            if (futures.isEmpty()) {
                this.sendStatusMsg(session, processId, NOTHING_FOUND);
            } else {
                this.handleResults(session, futures, config, processId);
                this.sendStatusMsg(session, processId, FINISHED);
            }
        });
    }

    private ExecutorService createExecutorService(boolean isExecuteInParallel) {
        if (isExecuteInParallel) {
            return Executors.newFixedThreadPool(10);
        }
        return Executors.newSingleThreadExecutor();
    }

    private BulkActionConfig parseRequest(@Nonnull TextMessage message) {
        String payload = (String)message.getPayload();
        try {
            return (BulkActionConfig)objectMapper.readValue(payload, BulkActionConfig.class);
        }
        catch (IOException e) {
            log.error(String.format("Error while parsing bulk action request: [%s]", message), (Throwable)e);
            throw new TdmParseRequestException(message.toString());
        }
    }

    private void closeSessionAsNormal(@Nonnull WebSocketSession session) {
        this.tryCloseSession(session, CloseStatus.NORMAL);
    }

    private void closeSessionAsError(@Nonnull WebSocketSession session) {
        this.tryCloseSession(session, CloseStatus.SERVER_ERROR);
    }

    private void tryCloseSession(@Nonnull WebSocketSession session, @Nonnull CloseStatus status) {
        try {
            session.close(status);
            log.info("Websocket session closed. Session: [{}].", (Object)session);
        }
        catch (Exception e) {
            log.error("Can't close WebSocket session. Session: [{}].", (Object)session, (Object)e);
        }
    }

    private void sendStatusMsg(@Nonnull WebSocketSession session, long processId, @Nonnull String status) {
        try {
            this.sendMessage(session, "{\"id\":" + processId + ", \"status\": \"" + status + "\"}");
        }
        catch (IOException e) {
            log.error("Error while sending a message with process id.", (Throwable)e);
        }
    }

    private void sendMessage(@Nonnull WebSocketSession session, @Nonnull BulkActionResult results) {
        String payloadText = this.writeBulkActionResultAsString(results);
        try {
            this.sendMessage(session, payloadText);
        }
        catch (Exception e) {
            log.error(String.format("Error while sending message: %s", payloadText), (Throwable)e);
            throw new TdmSendMessageException(payloadText);
        }
    }

    private void sendMessage(@Nonnull WebSocketSession session, @Nonnull String payloadText) throws IOException {
        if (session.isOpen()) {
            session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)payloadText));
            log.info("Message sent. Session: [{}]. Size: [{}].", (Object)session, (Object)payloadText.getBytes().length);
        } else {
            log.warn("Trying to sent message but session is closed.");
        }
    }

    private String writeBulkActionResultAsString(@Nonnull BulkActionResult results) {
        try {
            return objectMapper.writeValueAsString((Object)results);
        }
        catch (Exception e) {
            log.error(String.format("Error while writing bulk action results as string: %s", results), (Throwable)e);
            throw new TdmWriteBulkActionResultsAsStringException(results.toString());
        }
    }

    private void handleResults(@Nonnull WebSocketSession session, @Nonnull List<Future<BulkActionResult>> futures, @Nonnull BulkActionConfig config, long processId) {
        log.trace("Handle bulk action results, session: {}, id: {}", (Object)session.getId(), (Object)processId);
        for (Future<BulkActionResult> future : futures) {
            try {
                this.sendMessage(session, future.get());
            }
            catch (Exception e) {
                log.error("Error while processing bulk action futures.", (Throwable)e);
                throw new TdmProcessBulkActionFuturesException();
            }
        }
        log.trace("Bulk action results handled.");
        if (config.isSendResult()) {
            log.info("Send email results, session: {}, id: {}", (Object)session.getId(), (Object)processId);
            this.sendResultViaMail(this.mailSender, processId, config, futures);
        }
    }

    private void sendResultViaMail(@Nonnull AbstractBulkActionMailSender mailSender, long id, @Nonnull BulkActionConfig config, @Nonnull List<Future<BulkActionResult>> futures) {
        log.trace("Collecting bulk action results...");
        Executors.newSingleThreadExecutor().submit(() -> {
            BulkActionContext bulkActionContext = this.buildBulkActionContext(this.environmentsService, id, config, futures);
            log.trace("Sending bulk action result to email...");
            mailSender.send(bulkActionContext, config.getProjectId());
            log.info(bulkActionContext.getResults().toString());
            log.trace("Email sent.");
        });
    }

    private BulkActionContext buildBulkActionContext(@Nonnull EnvironmentsService environmentsService, long id, @Nonnull BulkActionConfig config, @Nonnull List<Future<BulkActionResult>> futures) {
        log.trace("Build bulk action context with id: {}, config: {}", (Object)id, (Object)config);
        BulkActionContext bulkActionContext = new BulkActionContext();
        bulkActionContext.setId(id);
        bulkActionContext.setProjectName(environmentsService.getLazyProjectById(config.getProjectId()).getName());
        bulkActionContext.setRecipients(config.getRecipients());
        try {
            bulkActionContext.setEnvironmentName(environmentsService.getEnvNameById(config.getEnvironmentId()));
        }
        catch (Exception e) {
            bulkActionContext.setEnvironmentName("Not Found");
        }
        try {
            bulkActionContext.setSystemName(environmentsService.getLazySystemById(config.getSystemId()).getName());
        }
        catch (Exception e) {
            bulkActionContext.setSystemName("Not Found");
        }
        bulkActionContext.setResults(futures.stream().map(i -> {
            try {
                return (BulkActionResult)i.get();
            }
            catch (Exception e) {
                log.error("Error while processing bulk action futures.", (Throwable)e);
                throw new TdmProcessBulkActionFuturesException();
            }
        }).collect(Collectors.toList()));
        log.trace("Build bulk action context has been created.");
        return bulkActionContext;
    }

    public abstract List<Future<BulkActionResult>> runBulkAction(@Nonnull WebSocketSession var1, @Nonnull ExecutorService var2, @Nonnull List<LazyEnvironment> var3, @Nonnull BulkActionConfig var4, long var5);
}

