/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.websocket.bulkaction.dataload;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.qubership.atp.common.lock.LockManager;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.qubership.atp.tdm.env.configurator.model.LazyEnvironment;
import org.qubership.atp.tdm.env.configurator.service.EnvironmentsService;
import org.qubership.atp.tdm.exceptions.websocket.TdmGetEnvironmentNameException;
import org.qubership.atp.tdm.mdc.TdmMdcHelper;
import org.qubership.atp.tdm.model.TestDataTableCatalog;
import org.qubership.atp.tdm.model.bulkaction.BulkActionResult;
import org.qubership.atp.tdm.model.mail.bulkaction.AbstractBulkActionMailSender;
import org.qubership.atp.tdm.model.refresh.RefreshResults;
import org.qubership.atp.tdm.repo.CatalogRepository;
import org.qubership.atp.tdm.repo.ImportInfoRepository;
import org.qubership.atp.tdm.service.DataRefreshService;
import org.qubership.atp.tdm.utils.CurrentTime;
import org.qubership.atp.tdm.websocket.bulkaction.BulkActionsHandler;
import org.slf4j.MDC;

public abstract class AbstractBulkDataLoadHandler
extends BulkActionsHandler {
    private final DataRefreshService dataRefreshService;
    protected final ImportInfoRepository importInfoRepository;

    AbstractBulkDataLoadHandler(ExecutorService executorService, @Nonnull CatalogRepository catalogRepository, @Nonnull ImportInfoRepository importInfoRepository, @Nonnull EnvironmentsService environmentsService, @Nonnull AbstractBulkActionMailSender mailSender, @Nonnull DataRefreshService dataRefreshService, @Nonnull CurrentTime currentTime, @Nonnull LockManager lockManager, TdmMdcHelper helper) {
        super(executorService, catalogRepository, environmentsService, mailSender, currentTime, lockManager, helper);
        this.dataRefreshService = dataRefreshService;
        this.importInfoRepository = importInfoRepository;
    }

    public List<Future<BulkActionResult>> runBulkAction(@Nonnull ExecutorService executor, @Nonnull List<LazyEnvironment> lazyEnvironments, @Nonnull List<TestDataTableCatalog> refreshCatalogs, boolean saveOccupiedData) {
        ArrayList<Future<BulkActionResult>> futures = new ArrayList<Future<BulkActionResult>>();
        Map mdcMap = MDC.getCopyOfContextMap();
        refreshCatalogs.forEach(tableCatalog -> {
            Future<BulkActionResult> future = executor.submit(() -> {
                MdcUtils.setContextMap((Map)mdcMap);
                String envName = lazyEnvironments.stream().filter(env -> tableCatalog.getEnvironmentId().equals(env.getId())).findFirst().orElseThrow(() -> new TdmGetEnvironmentNameException(tableCatalog.getEnvironmentId().toString())).getName();
                try {
                    this.mdcHelper.putConfigFields((TestDataTableCatalog)tableCatalog);
                    RefreshResults refreshResults = this.dataRefreshService.runRefresh(tableCatalog.getTableName(), saveOccupiedData);
                    BulkActionResult bulkActionResult = new BulkActionResult(tableCatalog.getTableTitle(), tableCatalog.getTableName(), envName, refreshResults);
                    return bulkActionResult;
                }
                catch (Exception e) {
                    BulkActionResult bulkActionResult = new BulkActionResult(tableCatalog.getTableTitle(), tableCatalog.getTableName(), envName, e);
                    return bulkActionResult;
                }
                finally {
                    this.mdcHelper.removeConfigFields();
                }
            });
            futures.add(future);
        });
        return futures;
    }
}

