/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.core.transformers.javassist;

import javassist.CtClass;
import javassist.CtField;
import javassist.Modifier;
import org.powermock.core.transformers.TransformStrategy;
import org.powermock.core.transformers.javassist.AbstractJavaAssistMockTransformer;

public class StaticFinalFieldsMockTransformer
extends AbstractJavaAssistMockTransformer {
    public StaticFinalFieldsMockTransformer(TransformStrategy strategy) {
        super(strategy);
    }

    @Override
    public CtClass transform(CtClass clazz) {
        if (clazz.isInterface()) {
            return clazz;
        }
        if (this.getStrategy() != TransformStrategy.INST_REDEFINE) {
            for (CtField f : clazz.getDeclaredFields()) {
                int modifiers = f.getModifiers();
                if (!Modifier.isFinal((int)modifiers) || !Modifier.isStatic((int)modifiers)) continue;
                f.setModifiers(modifiers ^ 0x10);
            }
        }
        return clazz;
    }
}

