/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.env.configurator.model;

import java.util.List;
import java.util.UUID;
import org.qubership.atp.tdm.env.configurator.exceptions.internal.TdmEnvDbConnectionException;
import org.qubership.atp.tdm.env.configurator.model.AbstractConfiguratorModel;
import org.qubership.atp.tdm.env.configurator.model.Connection;
import org.qubership.atp.tdm.env.configurator.model.Server;

public class System
extends AbstractConfiguratorModel {
    private UUID environmentId;
    private List<Connection> connections;

    public Connection getConnection(String connectionName) {
        return this.connections.stream().filter(system -> connectionName.equalsIgnoreCase(system.getName())).findFirst().orElseThrow(() -> new TdmEnvDbConnectionException(connectionName));
    }

    public Server getServer(String name) {
        return new Server(this.getConnection(name), name);
    }

    public static SystemBuilder builder() {
        return new SystemBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof System)) {
            return false;
        }
        System other = (System)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UUID this$environmentId = this.getEnvironmentId();
        UUID other$environmentId = other.getEnvironmentId();
        if (this$environmentId == null ? other$environmentId != null : !((Object)this$environmentId).equals(other$environmentId)) {
            return false;
        }
        List<Connection> this$connections = this.getConnections();
        List<Connection> other$connections = other.getConnections();
        return !(this$connections == null ? other$connections != null : !((Object)this$connections).equals(other$connections));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof System;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        UUID $environmentId = this.getEnvironmentId();
        result = result * 59 + ($environmentId == null ? 43 : ((Object)$environmentId).hashCode());
        List<Connection> $connections = this.getConnections();
        result = result * 59 + ($connections == null ? 43 : ((Object)$connections).hashCode());
        return result;
    }

    public UUID getEnvironmentId() {
        return this.environmentId;
    }

    public List<Connection> getConnections() {
        return this.connections;
    }

    public void setEnvironmentId(UUID environmentId) {
        this.environmentId = environmentId;
    }

    public void setConnections(List<Connection> connections) {
        this.connections = connections;
    }

    @Override
    public String toString() {
        return "System(environmentId=" + this.getEnvironmentId() + ", connections=" + this.getConnections() + ")";
    }

    public System() {
    }

    public System(UUID environmentId, List<Connection> connections) {
        this.environmentId = environmentId;
        this.connections = connections;
    }

    public static class SystemBuilder {
        private UUID environmentId;
        private List<Connection> connections;

        SystemBuilder() {
        }

        public SystemBuilder environmentId(UUID environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public SystemBuilder connections(List<Connection> connections) {
            this.connections = connections;
            return this;
        }

        public System build() {
            return new System(this.environmentId, this.connections);
        }

        public String toString() {
            return "System.SystemBuilder(environmentId=" + this.environmentId + ", connections=" + this.connections + ")";
        }
    }
}

