/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.provider.mappersync;

import java.util.function.Consumer;
import org.keycloak.broker.provider.mappersync.AbstractConfigPropertySynchronizer;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.KeycloakModelUtils;

public class RoleConfigPropertyByClientIdSynchronizer
extends AbstractConfigPropertySynchronizer<ClientModel.ClientIdChangeEvent> {
    public static final RoleConfigPropertyByClientIdSynchronizer INSTANCE = new RoleConfigPropertyByClientIdSynchronizer();

    private RoleConfigPropertyByClientIdSynchronizer() {
    }

    @Override
    public Class<ClientModel.ClientIdChangeEvent> getEventClass() {
        return ClientModel.ClientIdChangeEvent.class;
    }

    @Override
    public RealmModel extractRealm(ClientModel.ClientIdChangeEvent event) {
        return event.getUpdatedClient().getRealm();
    }

    @Override
    public String getConfigPropertyName() {
        return "role";
    }

    @Override
    protected void updateConfigPropertyIfNecessary(ClientModel.ClientIdChangeEvent event, String currentPropertyValue, Consumer<String> propertyUpdater) {
        String[] parsedConfiguredRoleQualifier = KeycloakModelUtils.parseRole(currentPropertyValue);
        String configuredClientId = parsedConfiguredRoleQualifier[0];
        if (configuredClientId == null) {
            return;
        }
        String configuredRoleName = parsedConfiguredRoleQualifier[1];
        if (configuredClientId.equals(event.getPreviousClientId())) {
            String newRoleQualifier = KeycloakModelUtils.buildRoleQualifier(event.getNewClientId(), configuredRoleName);
            propertyUpdater.accept(newRoleQualifier);
        }
    }
}

