/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.springsecurity.filter;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.StringUtils;

public class KeycloakCsrfRequestMatcher
implements RequestMatcher {
    private static final List<String> ALLOWED_ENDPOINTS = Arrays.asList("k_logout", "k_push_not_before", "k_query_bearer_token", "k_test_available");
    private Pattern allowedMethods = Pattern.compile("^(GET|HEAD|TRACE|OPTIONS)$");
    private Pattern allowedEndpoints = Pattern.compile(String.format("^\\/(%s)$", StringUtils.arrayToDelimitedString((Object[])ALLOWED_ENDPOINTS.toArray(), (String)"|")));

    public boolean matches(HttpServletRequest request) {
        String uri = request.getRequestURI().replaceFirst(request.getContextPath(), "");
        return !this.allowedEndpoints.matcher(uri).matches() && !this.allowedMethods.matcher(request.getMethod()).matches();
    }
}

