/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.brave.bridge;

import brave.propagation.ThreadLocalCurrentTraceContext;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.brave.bridge.BraveScope;
import org.springframework.cloud.sleuth.brave.bridge.BraveTraceContext;
import org.springframework.cloud.sleuth.brave.bridge.RevertingScope;

public class BraveCurrentTraceContext
implements CurrentTraceContext {
    final ThreadLocal<CurrentTraceContext.Scope> scopes = new ThreadLocal();
    final brave.propagation.CurrentTraceContext delegate;

    public BraveCurrentTraceContext(brave.propagation.CurrentTraceContext delegate) {
        this.delegate = delegate;
    }

    public TraceContext context() {
        brave.propagation.TraceContext context = this.delegate.get();
        return context == null ? null : new BraveTraceContext(context);
    }

    public CurrentTraceContext.Scope newScope(TraceContext context) {
        if (context == null) {
            this.clearScopes();
            return CurrentTraceContext.Scope.NOOP;
        }
        return new RevertingScope(this, new BraveScope(this.delegate.newScope(BraveTraceContext.toBrave(context))));
    }

    public CurrentTraceContext.Scope maybeScope(TraceContext context) {
        if (context == null) {
            this.clearScopes();
            return CurrentTraceContext.Scope.NOOP;
        }
        return new RevertingScope(this, new BraveScope(this.delegate.maybeScope(BraveTraceContext.toBrave(context))));
    }

    private void clearScopes() {
        CurrentTraceContext.Scope current = this.scopes.get();
        while (current != null) {
            current.close();
            current = this.scopes.get();
        }
        if (this.delegate instanceof ThreadLocalCurrentTraceContext) {
            ((ThreadLocalCurrentTraceContext)this.delegate).clear();
        }
    }

    public <C> Callable<C> wrap(Callable<C> task) {
        return this.delegate.wrap(task);
    }

    public Runnable wrap(Runnable task) {
        return this.delegate.wrap(task);
    }

    public Executor wrap(Executor delegate) {
        return this.delegate.executor(delegate);
    }

    public ExecutorService wrap(ExecutorService delegate) {
        return this.delegate.executorService(delegate);
    }

    static brave.propagation.CurrentTraceContext toBrave(CurrentTraceContext context) {
        return ((BraveCurrentTraceContext)context).delegate;
    }

    static CurrentTraceContext fromBrave(brave.propagation.CurrentTraceContext context) {
        return new BraveCurrentTraceContext(context);
    }
}

