/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.integration.configuration.interceptors;

import java.util.List;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.slf4j.MDC;

public class MdcRestTemplateInterceptor
implements HttpRequestInterceptor {
    List<String> businessIds;

    public MdcRestTemplateInterceptor(List<String> businessIds) {
        this.businessIds = businessIds;
    }

    public void process(HttpRequest request, HttpContext context) {
        this.businessIds.forEach(idName -> {
            String value = MDC.get((String)idName);
            if (value != null) {
                request.addHeader(MdcUtils.convertIdNameToHeader(idName), value);
            }
        });
    }
}

