/*
 * Decompiled with CFR 0.152.
 */
package org.antechrestos.restclienttest.context;

import lombok.NonNull;

public final class Payload {
    private final Type type;
    private final String value;

    Payload(@NonNull Type type, @NonNull String value) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.type = type;
        this.value = value;
    }

    public static PayloadBuilder builder() {
        return new PayloadBuilder();
    }

    public Type getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Payload)) {
            return false;
        }
        Payload other = (Payload)o;
        Type this$type = this.getType();
        Type other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public String toString() {
        return "Payload(type=" + (Object)((Object)this.getType()) + ", value=" + this.getValue() + ")";
    }

    public static class PayloadBuilder {
        private Type type;
        private String value;

        PayloadBuilder() {
        }

        public PayloadBuilder type(Type type) {
            this.type = type;
            return this;
        }

        public PayloadBuilder value(String value) {
            this.value = value;
            return this;
        }

        public Payload build() {
            return new Payload(this.type, this.value);
        }

        public String toString() {
            return "Payload.PayloadBuilder(type=" + (Object)((Object)this.type) + ", value=" + this.value + ")";
        }
    }

    public static enum Type {
        RAW_STRING,
        CLASSPATH_RESOURCE;

    }
}

