/*
 * Decompiled with CFR 0.152.
 */
package org.antechrestos.restclienttest.mockclient;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.antechrestos.restclienttest.context.Context;
import org.antechrestos.restclienttest.mockclient.MockClientHttpResponse;
import org.junit.Assert;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;

class MockClientHttpRequest
implements ClientHttpRequest {
    private final ByteArrayOutputStream body;
    private final HttpHeaders headers;
    private Context context;
    private Map<String, List<String>> queriedParameters;

    MockClientHttpRequest(Context context, Map<String, List<String>> queriedParameters) {
        this.context = context;
        this.headers = new HttpHeaders();
        this.body = new ByteArrayOutputStream();
        this.queriedParameters = queriedParameters;
    }

    public ClientHttpResponse execute() throws IOException {
        this.checkHeaders();
        this.checkQuery();
        this.checkBody();
        return new MockClientHttpResponse(this.context);
    }

    public HttpMethod getMethod() {
        return this.context.getMethod();
    }

    public URI getURI() {
        return this.context.getUrl();
    }

    private void checkBody() throws IOException {
        if (this.context.getRequestPayload() != null) {
            byte[] bytes = this.body.toByteArray();
            try {
                Assert.assertArrayEquals((byte[])this.context.getRequestPayload(), (byte[])bytes);
            }
            catch (AssertionError ae) {
                throw new AssertionError((Object)String.format("actual request body [%s] doesn't match expected [%s]", new String(bytes), new String(this.context.getRequestPayload())));
            }
        }
    }

    private void checkQuery() {
        this.compareMultiValuedMap(this.context.getQueryParameters(), this.queriedParameters, key -> "Query parameter " + key + " should be set", (key, missingValue, queriedValues) -> "Missing expected value \"" + missingValue + "\" for query parameter " + key + ". Got: " + queriedValues);
    }

    private void checkHeaders() {
        this.compareMultiValuedMap((Map<String, List<String>>)this.context.getRequestHeaders(), (Map<String, List<String>>)this.headers, key -> "Header " + key + "should be valued", (key, missingValue, queriedValues) -> "Missing expected value \"" + missingValue + "\" for request header " + key + ". Got: " + queriedValues);
    }

    private void compareMultiValuedMap(Map<String, List<String>> required, Map<String, List<String>> queried, Function<String, String> missingKeyMessageGenerator, InvalidValueMessageBuilder badValue) {
        required.entrySet().stream().peek(entry -> Assert.assertTrue((String)((String)missingKeyMessageGenerator.apply((String)entry.getKey())), (boolean)queried.containsKey(entry.getKey()))).forEach(entry -> {
            List valuesPresent = (List)queried.get(entry.getKey());
            Optional<String> missingValue = ((List)entry.getValue()).stream().filter(value -> !valuesPresent.contains(value)).findFirst();
            if (missingValue.isPresent()) {
                Assert.fail((String)badValue.apply((String)entry.getKey(), missingValue.get(), valuesPresent));
            }
        });
    }

    public ByteArrayOutputStream getBody() {
        return this.body;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    private static interface InvalidValueMessageBuilder {
        public String apply(String var1, String var2, List<String> var3);
    }
}

