/*
 * Decompiled with CFR 0.152.
 */
package org.antechrestos.restclienttest.utils;

import java.net.URI;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class URIHelper {
    public static URI removeQueryParameters(URI uri) {
        String query = uri.getRawQuery();
        String uriStr = uri.toString();
        if (query != null) {
            uriStr = uriStr.substring(0, uriStr.length() - query.length());
        }
        if (uriStr.endsWith("?")) {
            uriStr = uriStr.substring(0, uriStr.length() - 1);
        }
        return URI.create(uriStr);
    }

    public static Map<String, List<String>> getQueryParameters(URI uri) {
        String query = uri.getQuery();
        if (query != null) {
            return Arrays.stream(query.split("&")).map(s -> s.split("=")).map(split -> {
                if (((String[])split).length > 1) {
                    return new AbstractMap.SimpleImmutableEntry<String, String>(split[0], split[1]);
                }
                return new AbstractMap.SimpleImmutableEntry<String, Object>(split[0], null);
            }).collect(Collectors.groupingBy(AbstractMap.SimpleImmutableEntry::getKey, Collectors.mapping(AbstractMap.SimpleImmutableEntry::getValue, Collectors.toList())));
        }
        return Collections.emptyMap();
    }

    private URIHelper() {
    }
}

