/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.sqlbuilder.custom.mysql;

import com.healthmarketscience.common.util.AppendableExt;
import com.healthmarketscience.sqlbuilder.Converter;
import com.healthmarketscience.sqlbuilder.NumberValueObject;
import com.healthmarketscience.sqlbuilder.SelectQuery;
import com.healthmarketscience.sqlbuilder.SqlObject;
import com.healthmarketscience.sqlbuilder.ValidationContext;
import com.healthmarketscience.sqlbuilder.ValidationException;
import com.healthmarketscience.sqlbuilder.Verifiable;
import com.healthmarketscience.sqlbuilder.custom.CustomSyntax;
import com.healthmarketscience.sqlbuilder.custom.HookType;
import java.io.IOException;

public class MysLimitClause
extends CustomSyntax
implements Verifiable<MysLimitClause> {
    private SqlObject _rowCount;
    private SqlObject _offset;

    public MysLimitClause(Object rowCount) {
        this(null, rowCount);
    }

    public MysLimitClause(Object offset, Object rowCount) {
        this._offset = offset != null ? Converter.toValueSqlObject(offset) : null;
        this._rowCount = Converter.toValueSqlObject(rowCount);
    }

    @Override
    public void apply(SelectQuery query) {
        query.addCustomization(SelectQuery.Hook.FOR_UPDATE, HookType.BEFORE, (Object)this);
    }

    @Override
    public void appendTo(AppendableExt app) throws IOException {
        app.append(" LIMIT ");
        if (this._offset != null) {
            app.append(this._offset).append(", ");
        }
        app.append(this._rowCount);
    }

    @Override
    protected void collectSchemaObjects(ValidationContext vContext) {
        vContext.addVerifiable(this);
        if (this._offset != null) {
            MysLimitClause.collectSchemaObjects(this._offset, vContext);
        }
        MysLimitClause.collectSchemaObjects(this._rowCount, vContext);
    }

    @Override
    public final MysLimitClause validate() throws ValidationException {
        this.doValidate();
        return this;
    }

    @Override
    public void validate(ValidationContext vContext) throws ValidationException {
        if (this._offset != null) {
            MysLimitClause.validateValue(this._offset, "offset");
        }
        if (this._rowCount == null) {
            throw new ValidationException("Limit clause is missing row count");
        }
        MysLimitClause.validateValue(this._rowCount, "row count");
    }

    private static void validateValue(SqlObject valueObj, String type) {
        if (!(valueObj instanceof NumberValueObject)) {
            return;
        }
        if (!((NumberValueObject)valueObj).isIntegralInRange(0L, Long.MAX_VALUE)) {
            throw new ValidationException("Limit " + type + " value must be positive integer, given: " + valueObj);
        }
    }
}

